/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fis.model.FisResponse;
import software.amazon.awssdk.services.fis.model.TargetResourceTypeSummary;
import software.amazon.awssdk.services.fis.model.TargetResourceTypeSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTargetResourceTypesResponse
extends FisResponse
implements ToCopyableBuilder<Builder, ListTargetResourceTypesResponse> {
    private static final SdkField<List<TargetResourceTypeSummary>> TARGET_RESOURCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("targetResourceTypes").getter(ListTargetResourceTypesResponse.getter(ListTargetResourceTypesResponse::targetResourceTypes)).setter(ListTargetResourceTypesResponse.setter(Builder::targetResourceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResourceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TargetResourceTypeSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTargetResourceTypesResponse.getter(ListTargetResourceTypesResponse::nextToken)).setter(ListTargetResourceTypesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_RESOURCE_TYPES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTargetResourceTypesResponse.memberNameToFieldInitializer();
    private final List<TargetResourceTypeSummary> targetResourceTypes;
    private final String nextToken;

    private ListTargetResourceTypesResponse(BuilderImpl builder) {
        super(builder);
        this.targetResourceTypes = builder.targetResourceTypes;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTargetResourceTypes() {
        return this.targetResourceTypes != null && !(this.targetResourceTypes instanceof SdkAutoConstructList);
    }

    public final List<TargetResourceTypeSummary> targetResourceTypes() {
        return this.targetResourceTypes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetResourceTypes() ? this.targetResourceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTargetResourceTypesResponse)) {
            return false;
        }
        ListTargetResourceTypesResponse other = (ListTargetResourceTypesResponse)((Object)obj);
        return this.hasTargetResourceTypes() == other.hasTargetResourceTypes() && Objects.equals(this.targetResourceTypes(), other.targetResourceTypes()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTargetResourceTypesResponse").add("TargetResourceTypes", this.hasTargetResourceTypes() ? this.targetResourceTypes() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "targetResourceTypes": {
                return Optional.ofNullable(clazz.cast(this.targetResourceTypes()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("targetResourceTypes", TARGET_RESOURCE_TYPES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTargetResourceTypesResponse, T> g) {
        return obj -> g.apply((ListTargetResourceTypesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FisResponse.BuilderImpl
    implements Builder {
        private List<TargetResourceTypeSummary> targetResourceTypes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTargetResourceTypesResponse model) {
            super(model);
            this.targetResourceTypes(model.targetResourceTypes);
            this.nextToken(model.nextToken);
        }

        public final List<TargetResourceTypeSummary.Builder> getTargetResourceTypes() {
            List<TargetResourceTypeSummary.Builder> result = TargetResourceTypeSummaryListCopier.copyToBuilder(this.targetResourceTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetResourceTypes(Collection<TargetResourceTypeSummary.BuilderImpl> targetResourceTypes) {
            this.targetResourceTypes = TargetResourceTypeSummaryListCopier.copyFromBuilder(targetResourceTypes);
        }

        @Override
        public final Builder targetResourceTypes(Collection<TargetResourceTypeSummary> targetResourceTypes) {
            this.targetResourceTypes = TargetResourceTypeSummaryListCopier.copy(targetResourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetResourceTypes(TargetResourceTypeSummary ... targetResourceTypes) {
            this.targetResourceTypes(Arrays.asList(targetResourceTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetResourceTypes(Consumer<TargetResourceTypeSummary.Builder> ... targetResourceTypes) {
            this.targetResourceTypes(Stream.of(targetResourceTypes).map(c -> (TargetResourceTypeSummary)((TargetResourceTypeSummary.Builder)TargetResourceTypeSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTargetResourceTypesResponse build() {
            return new ListTargetResourceTypesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FisResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTargetResourceTypesResponse> {
        public Builder targetResourceTypes(Collection<TargetResourceTypeSummary> var1);

        public Builder targetResourceTypes(TargetResourceTypeSummary ... var1);

        public Builder targetResourceTypes(Consumer<TargetResourceTypeSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

