/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fis;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.fis.DefaultFisAsyncClient;
import software.amazon.awssdk.services.fis.DefaultFisBaseClientBuilder;
import software.amazon.awssdk.services.fis.FisAsyncClient;
import software.amazon.awssdk.services.fis.FisAsyncClientBuilder;
import software.amazon.awssdk.services.fis.FisServiceClientConfiguration;
import software.amazon.awssdk.services.fis.endpoints.FisEndpointProvider;

@SdkInternalApi
final class DefaultFisAsyncClientBuilder
extends DefaultFisBaseClientBuilder<FisAsyncClientBuilder, FisAsyncClient>
implements FisAsyncClientBuilder {
    DefaultFisAsyncClientBuilder() {
    }

    @Override
    public DefaultFisAsyncClientBuilder endpointProvider(FisEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final FisAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultFisAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        FisServiceClientConfiguration serviceClientConfiguration = FisServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultFisAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

