/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.fis.model.FisRequest;
import software.amazon.awssdk.services.fis.model.UpdateExperimentTemplateActionInputItem;
import software.amazon.awssdk.services.fis.model.UpdateExperimentTemplateActionInputMapCopier;
import software.amazon.awssdk.services.fis.model.UpdateExperimentTemplateLogConfigurationInput;
import software.amazon.awssdk.services.fis.model.UpdateExperimentTemplateStopConditionInput;
import software.amazon.awssdk.services.fis.model.UpdateExperimentTemplateStopConditionInputListCopier;
import software.amazon.awssdk.services.fis.model.UpdateExperimentTemplateTargetInput;
import software.amazon.awssdk.services.fis.model.UpdateExperimentTemplateTargetInputMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateExperimentTemplateRequest
extends FisRequest
implements ToCopyableBuilder<Builder, UpdateExperimentTemplateRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(UpdateExperimentTemplateRequest.getter(UpdateExperimentTemplateRequest::id)).setter(UpdateExperimentTemplateRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateExperimentTemplateRequest.getter(UpdateExperimentTemplateRequest::description)).setter(UpdateExperimentTemplateRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<UpdateExperimentTemplateStopConditionInput>> STOP_CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("stopConditions").getter(UpdateExperimentTemplateRequest.getter(UpdateExperimentTemplateRequest::stopConditions)).setter(UpdateExperimentTemplateRequest.setter(Builder::stopConditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopConditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UpdateExperimentTemplateStopConditionInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, UpdateExperimentTemplateTargetInput>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("targets").getter(UpdateExperimentTemplateRequest.getter(UpdateExperimentTemplateRequest::targets)).setter(UpdateExperimentTemplateRequest.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targets").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UpdateExperimentTemplateTargetInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, UpdateExperimentTemplateActionInputItem>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("actions").getter(UpdateExperimentTemplateRequest.getter(UpdateExperimentTemplateRequest::actions)).setter(UpdateExperimentTemplateRequest.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UpdateExperimentTemplateActionInputItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(UpdateExperimentTemplateRequest.getter(UpdateExperimentTemplateRequest::roleArn)).setter(UpdateExperimentTemplateRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<UpdateExperimentTemplateLogConfigurationInput> LOG_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logConfiguration").getter(UpdateExperimentTemplateRequest.getter(UpdateExperimentTemplateRequest::logConfiguration)).setter(UpdateExperimentTemplateRequest.setter(Builder::logConfiguration)).constructor(UpdateExperimentTemplateLogConfigurationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DESCRIPTION_FIELD, STOP_CONDITIONS_FIELD, TARGETS_FIELD, ACTIONS_FIELD, ROLE_ARN_FIELD, LOG_CONFIGURATION_FIELD));
    private final String id;
    private final String description;
    private final List<UpdateExperimentTemplateStopConditionInput> stopConditions;
    private final Map<String, UpdateExperimentTemplateTargetInput> targets;
    private final Map<String, UpdateExperimentTemplateActionInputItem> actions;
    private final String roleArn;
    private final UpdateExperimentTemplateLogConfigurationInput logConfiguration;

    private UpdateExperimentTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.description = builder.description;
        this.stopConditions = builder.stopConditions;
        this.targets = builder.targets;
        this.actions = builder.actions;
        this.roleArn = builder.roleArn;
        this.logConfiguration = builder.logConfiguration;
    }

    public final String id() {
        return this.id;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasStopConditions() {
        return this.stopConditions != null && !(this.stopConditions instanceof SdkAutoConstructList);
    }

    public final List<UpdateExperimentTemplateStopConditionInput> stopConditions() {
        return this.stopConditions;
    }

    public final boolean hasTargets() {
        return this.targets != null && !(this.targets instanceof SdkAutoConstructMap);
    }

    public final Map<String, UpdateExperimentTemplateTargetInput> targets() {
        return this.targets;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructMap);
    }

    public final Map<String, UpdateExperimentTemplateActionInputItem> actions() {
        return this.actions;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final UpdateExperimentTemplateLogConfigurationInput logConfiguration() {
        return this.logConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStopConditions() ? this.stopConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargets() ? this.targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.logConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateExperimentTemplateRequest)) {
            return false;
        }
        UpdateExperimentTemplateRequest other = (UpdateExperimentTemplateRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.description(), other.description()) && this.hasStopConditions() == other.hasStopConditions() && Objects.equals(this.stopConditions(), other.stopConditions()) && this.hasTargets() == other.hasTargets() && Objects.equals(this.targets(), other.targets()) && this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.logConfiguration(), other.logConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateExperimentTemplateRequest").add("Id", (Object)this.id()).add("Description", (Object)this.description()).add("StopConditions", this.hasStopConditions() ? this.stopConditions() : null).add("Targets", this.hasTargets() ? this.targets() : null).add("Actions", this.hasActions() ? this.actions() : null).add("RoleArn", (Object)this.roleArn()).add("LogConfiguration", (Object)this.logConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "stopConditions": {
                return Optional.ofNullable(clazz.cast(this.stopConditions()));
            }
            case "targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "logConfiguration": {
                return Optional.ofNullable(clazz.cast(this.logConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateExperimentTemplateRequest, T> g) {
        return obj -> g.apply((UpdateExperimentTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FisRequest.BuilderImpl
    implements Builder {
        private String id;
        private String description;
        private List<UpdateExperimentTemplateStopConditionInput> stopConditions = DefaultSdkAutoConstructList.getInstance();
        private Map<String, UpdateExperimentTemplateTargetInput> targets = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, UpdateExperimentTemplateActionInputItem> actions = DefaultSdkAutoConstructMap.getInstance();
        private String roleArn;
        private UpdateExperimentTemplateLogConfigurationInput logConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateExperimentTemplateRequest model) {
            super(model);
            this.id(model.id);
            this.description(model.description);
            this.stopConditions(model.stopConditions);
            this.targets(model.targets);
            this.actions(model.actions);
            this.roleArn(model.roleArn);
            this.logConfiguration(model.logConfiguration);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<UpdateExperimentTemplateStopConditionInput.Builder> getStopConditions() {
            List<UpdateExperimentTemplateStopConditionInput.Builder> result = UpdateExperimentTemplateStopConditionInputListCopier.copyToBuilder(this.stopConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStopConditions(Collection<UpdateExperimentTemplateStopConditionInput.BuilderImpl> stopConditions) {
            this.stopConditions = UpdateExperimentTemplateStopConditionInputListCopier.copyFromBuilder(stopConditions);
        }

        @Override
        public final Builder stopConditions(Collection<UpdateExperimentTemplateStopConditionInput> stopConditions) {
            this.stopConditions = UpdateExperimentTemplateStopConditionInputListCopier.copy(stopConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stopConditions(UpdateExperimentTemplateStopConditionInput ... stopConditions) {
            this.stopConditions(Arrays.asList(stopConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stopConditions(Consumer<UpdateExperimentTemplateStopConditionInput.Builder> ... stopConditions) {
            this.stopConditions(Stream.of(stopConditions).map(c -> (UpdateExperimentTemplateStopConditionInput)((UpdateExperimentTemplateStopConditionInput.Builder)UpdateExperimentTemplateStopConditionInput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, UpdateExperimentTemplateTargetInput.Builder> getTargets() {
            Map<String, UpdateExperimentTemplateTargetInput.Builder> result = UpdateExperimentTemplateTargetInputMapCopier.copyToBuilder(this.targets);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setTargets(Map<String, UpdateExperimentTemplateTargetInput.BuilderImpl> targets) {
            this.targets = UpdateExperimentTemplateTargetInputMapCopier.copyFromBuilder(targets);
        }

        @Override
        public final Builder targets(Map<String, UpdateExperimentTemplateTargetInput> targets) {
            this.targets = UpdateExperimentTemplateTargetInputMapCopier.copy(targets);
            return this;
        }

        public final Map<String, UpdateExperimentTemplateActionInputItem.Builder> getActions() {
            Map<String, UpdateExperimentTemplateActionInputItem.Builder> result = UpdateExperimentTemplateActionInputMapCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setActions(Map<String, UpdateExperimentTemplateActionInputItem.BuilderImpl> actions) {
            this.actions = UpdateExperimentTemplateActionInputMapCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Map<String, UpdateExperimentTemplateActionInputItem> actions) {
            this.actions = UpdateExperimentTemplateActionInputMapCopier.copy(actions);
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final UpdateExperimentTemplateLogConfigurationInput.Builder getLogConfiguration() {
            return this.logConfiguration != null ? this.logConfiguration.toBuilder() : null;
        }

        public final void setLogConfiguration(UpdateExperimentTemplateLogConfigurationInput.BuilderImpl logConfiguration) {
            this.logConfiguration = logConfiguration != null ? logConfiguration.build() : null;
        }

        @Override
        public final Builder logConfiguration(UpdateExperimentTemplateLogConfigurationInput logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateExperimentTemplateRequest build() {
            return new UpdateExperimentTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FisRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateExperimentTemplateRequest> {
        public Builder id(String var1);

        public Builder description(String var1);

        public Builder stopConditions(Collection<UpdateExperimentTemplateStopConditionInput> var1);

        public Builder stopConditions(UpdateExperimentTemplateStopConditionInput ... var1);

        public Builder stopConditions(Consumer<UpdateExperimentTemplateStopConditionInput.Builder> ... var1);

        public Builder targets(Map<String, UpdateExperimentTemplateTargetInput> var1);

        public Builder actions(Map<String, UpdateExperimentTemplateActionInputItem> var1);

        public Builder roleArn(String var1);

        public Builder logConfiguration(UpdateExperimentTemplateLogConfigurationInput var1);

        default public Builder logConfiguration(Consumer<UpdateExperimentTemplateLogConfigurationInput.Builder> logConfiguration) {
            return this.logConfiguration((UpdateExperimentTemplateLogConfigurationInput)((UpdateExperimentTemplateLogConfigurationInput.Builder)UpdateExperimentTemplateLogConfigurationInput.builder().applyMutation(logConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

