/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fis.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.fis.FisClient;
import software.amazon.awssdk.services.fis.model.ListTargetResourceTypesRequest;
import software.amazon.awssdk.services.fis.model.ListTargetResourceTypesResponse;

public class ListTargetResourceTypesIterable
implements SdkIterable<ListTargetResourceTypesResponse> {
    private final FisClient client;
    private final ListTargetResourceTypesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTargetResourceTypesIterable(FisClient client, ListTargetResourceTypesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTargetResourceTypesResponseFetcher();
    }

    public Iterator<ListTargetResourceTypesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListTargetResourceTypesResponseFetcher
    implements SyncPageFetcher<ListTargetResourceTypesResponse> {
        private ListTargetResourceTypesResponseFetcher() {
        }

        public boolean hasNextPage(ListTargetResourceTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTargetResourceTypesResponse nextPage(ListTargetResourceTypesResponse previousPage) {
            if (previousPage == null) {
                return ListTargetResourceTypesIterable.this.client.listTargetResourceTypes(ListTargetResourceTypesIterable.this.firstRequest);
            }
            return ListTargetResourceTypesIterable.this.client.listTargetResourceTypes((ListTargetResourceTypesRequest)((Object)ListTargetResourceTypesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

