/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.firehose.model.DeliveryStreamEncryptionConfiguration;
import software.amazon.awssdk.services.firehose.model.DeliveryStreamStatus;
import software.amazon.awssdk.services.firehose.model.DeliveryStreamType;
import software.amazon.awssdk.services.firehose.model.DestinationDescription;
import software.amazon.awssdk.services.firehose.model.DestinationDescriptionListCopier;
import software.amazon.awssdk.services.firehose.model.SourceDescription;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeliveryStreamDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeliveryStreamDescription> {
    private static final SdkField<String> DELIVERY_STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeliveryStreamDescription.getter(DeliveryStreamDescription::deliveryStreamName)).setter(DeliveryStreamDescription.setter(Builder::deliveryStreamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryStreamName").build()}).build();
    private static final SdkField<String> DELIVERY_STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeliveryStreamDescription.getter(DeliveryStreamDescription::deliveryStreamARN)).setter(DeliveryStreamDescription.setter(Builder::deliveryStreamARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryStreamARN").build()}).build();
    private static final SdkField<String> DELIVERY_STREAM_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeliveryStreamDescription.getter(DeliveryStreamDescription::deliveryStreamStatusAsString)).setter(DeliveryStreamDescription.setter(Builder::deliveryStreamStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryStreamStatus").build()}).build();
    private static final SdkField<DeliveryStreamEncryptionConfiguration> DELIVERY_STREAM_ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DeliveryStreamDescription.getter(DeliveryStreamDescription::deliveryStreamEncryptionConfiguration)).setter(DeliveryStreamDescription.setter(Builder::deliveryStreamEncryptionConfiguration)).constructor(DeliveryStreamEncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryStreamEncryptionConfiguration").build()}).build();
    private static final SdkField<String> DELIVERY_STREAM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeliveryStreamDescription.getter(DeliveryStreamDescription::deliveryStreamTypeAsString)).setter(DeliveryStreamDescription.setter(Builder::deliveryStreamType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryStreamType").build()}).build();
    private static final SdkField<String> VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeliveryStreamDescription.getter(DeliveryStreamDescription::versionId)).setter(DeliveryStreamDescription.setter(Builder::versionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionId").build()}).build();
    private static final SdkField<Instant> CREATE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DeliveryStreamDescription.getter(DeliveryStreamDescription::createTimestamp)).setter(DeliveryStreamDescription.setter(Builder::createTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTimestamp").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DeliveryStreamDescription.getter(DeliveryStreamDescription::lastUpdateTimestamp)).setter(DeliveryStreamDescription.setter(Builder::lastUpdateTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTimestamp").build()}).build();
    private static final SdkField<SourceDescription> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DeliveryStreamDescription.getter(DeliveryStreamDescription::source)).setter(DeliveryStreamDescription.setter(Builder::source)).constructor(SourceDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<List<DestinationDescription>> DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DeliveryStreamDescription.getter(DeliveryStreamDescription::destinations)).setter(DeliveryStreamDescription.setter(Builder::destinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DestinationDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> HAS_MORE_DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(DeliveryStreamDescription.getter(DeliveryStreamDescription::hasMoreDestinations)).setter(DeliveryStreamDescription.setter(Builder::hasMoreDestinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HasMoreDestinations").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_STREAM_NAME_FIELD, DELIVERY_STREAM_ARN_FIELD, DELIVERY_STREAM_STATUS_FIELD, DELIVERY_STREAM_ENCRYPTION_CONFIGURATION_FIELD, DELIVERY_STREAM_TYPE_FIELD, VERSION_ID_FIELD, CREATE_TIMESTAMP_FIELD, LAST_UPDATE_TIMESTAMP_FIELD, SOURCE_FIELD, DESTINATIONS_FIELD, HAS_MORE_DESTINATIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String deliveryStreamName;
    private final String deliveryStreamARN;
    private final String deliveryStreamStatus;
    private final DeliveryStreamEncryptionConfiguration deliveryStreamEncryptionConfiguration;
    private final String deliveryStreamType;
    private final String versionId;
    private final Instant createTimestamp;
    private final Instant lastUpdateTimestamp;
    private final SourceDescription source;
    private final List<DestinationDescription> destinations;
    private final Boolean hasMoreDestinations;

    private DeliveryStreamDescription(BuilderImpl builder) {
        this.deliveryStreamName = builder.deliveryStreamName;
        this.deliveryStreamARN = builder.deliveryStreamARN;
        this.deliveryStreamStatus = builder.deliveryStreamStatus;
        this.deliveryStreamEncryptionConfiguration = builder.deliveryStreamEncryptionConfiguration;
        this.deliveryStreamType = builder.deliveryStreamType;
        this.versionId = builder.versionId;
        this.createTimestamp = builder.createTimestamp;
        this.lastUpdateTimestamp = builder.lastUpdateTimestamp;
        this.source = builder.source;
        this.destinations = builder.destinations;
        this.hasMoreDestinations = builder.hasMoreDestinations;
    }

    public String deliveryStreamName() {
        return this.deliveryStreamName;
    }

    public String deliveryStreamARN() {
        return this.deliveryStreamARN;
    }

    public DeliveryStreamStatus deliveryStreamStatus() {
        return DeliveryStreamStatus.fromValue(this.deliveryStreamStatus);
    }

    public String deliveryStreamStatusAsString() {
        return this.deliveryStreamStatus;
    }

    public DeliveryStreamEncryptionConfiguration deliveryStreamEncryptionConfiguration() {
        return this.deliveryStreamEncryptionConfiguration;
    }

    public DeliveryStreamType deliveryStreamType() {
        return DeliveryStreamType.fromValue(this.deliveryStreamType);
    }

    public String deliveryStreamTypeAsString() {
        return this.deliveryStreamType;
    }

    public String versionId() {
        return this.versionId;
    }

    public Instant createTimestamp() {
        return this.createTimestamp;
    }

    public Instant lastUpdateTimestamp() {
        return this.lastUpdateTimestamp;
    }

    public SourceDescription source() {
        return this.source;
    }

    public List<DestinationDescription> destinations() {
        return this.destinations;
    }

    public Boolean hasMoreDestinations() {
        return this.hasMoreDestinations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryStreamARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryStreamStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryStreamEncryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryStreamTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinations());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMoreDestinations());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeliveryStreamDescription)) {
            return false;
        }
        DeliveryStreamDescription other = (DeliveryStreamDescription)obj;
        return Objects.equals(this.deliveryStreamName(), other.deliveryStreamName()) && Objects.equals(this.deliveryStreamARN(), other.deliveryStreamARN()) && Objects.equals(this.deliveryStreamStatusAsString(), other.deliveryStreamStatusAsString()) && Objects.equals(this.deliveryStreamEncryptionConfiguration(), other.deliveryStreamEncryptionConfiguration()) && Objects.equals(this.deliveryStreamTypeAsString(), other.deliveryStreamTypeAsString()) && Objects.equals(this.versionId(), other.versionId()) && Objects.equals(this.createTimestamp(), other.createTimestamp()) && Objects.equals(this.lastUpdateTimestamp(), other.lastUpdateTimestamp()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.destinations(), other.destinations()) && Objects.equals(this.hasMoreDestinations(), other.hasMoreDestinations());
    }

    public String toString() {
        return ToString.builder((String)"DeliveryStreamDescription").add("DeliveryStreamName", (Object)this.deliveryStreamName()).add("DeliveryStreamARN", (Object)this.deliveryStreamARN()).add("DeliveryStreamStatus", (Object)this.deliveryStreamStatusAsString()).add("DeliveryStreamEncryptionConfiguration", (Object)this.deliveryStreamEncryptionConfiguration()).add("DeliveryStreamType", (Object)this.deliveryStreamTypeAsString()).add("VersionId", (Object)this.versionId()).add("CreateTimestamp", (Object)this.createTimestamp()).add("LastUpdateTimestamp", (Object)this.lastUpdateTimestamp()).add("Source", (Object)this.source()).add("Destinations", this.destinations()).add("HasMoreDestinations", (Object)this.hasMoreDestinations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeliveryStreamName": {
                return Optional.ofNullable(clazz.cast(this.deliveryStreamName()));
            }
            case "DeliveryStreamARN": {
                return Optional.ofNullable(clazz.cast(this.deliveryStreamARN()));
            }
            case "DeliveryStreamStatus": {
                return Optional.ofNullable(clazz.cast(this.deliveryStreamStatusAsString()));
            }
            case "DeliveryStreamEncryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.deliveryStreamEncryptionConfiguration()));
            }
            case "DeliveryStreamType": {
                return Optional.ofNullable(clazz.cast(this.deliveryStreamTypeAsString()));
            }
            case "VersionId": {
                return Optional.ofNullable(clazz.cast(this.versionId()));
            }
            case "CreateTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createTimestamp()));
            }
            case "LastUpdateTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTimestamp()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "Destinations": {
                return Optional.ofNullable(clazz.cast(this.destinations()));
            }
            case "HasMoreDestinations": {
                return Optional.ofNullable(clazz.cast(this.hasMoreDestinations()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeliveryStreamDescription, T> g) {
        return obj -> g.apply((DeliveryStreamDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deliveryStreamName;
        private String deliveryStreamARN;
        private String deliveryStreamStatus;
        private DeliveryStreamEncryptionConfiguration deliveryStreamEncryptionConfiguration;
        private String deliveryStreamType;
        private String versionId;
        private Instant createTimestamp;
        private Instant lastUpdateTimestamp;
        private SourceDescription source;
        private List<DestinationDescription> destinations = DefaultSdkAutoConstructList.getInstance();
        private Boolean hasMoreDestinations;

        private BuilderImpl() {
        }

        private BuilderImpl(DeliveryStreamDescription model) {
            this.deliveryStreamName(model.deliveryStreamName);
            this.deliveryStreamARN(model.deliveryStreamARN);
            this.deliveryStreamStatus(model.deliveryStreamStatus);
            this.deliveryStreamEncryptionConfiguration(model.deliveryStreamEncryptionConfiguration);
            this.deliveryStreamType(model.deliveryStreamType);
            this.versionId(model.versionId);
            this.createTimestamp(model.createTimestamp);
            this.lastUpdateTimestamp(model.lastUpdateTimestamp);
            this.source(model.source);
            this.destinations(model.destinations);
            this.hasMoreDestinations(model.hasMoreDestinations);
        }

        public final String getDeliveryStreamName() {
            return this.deliveryStreamName;
        }

        @Override
        public final Builder deliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        public final void setDeliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
        }

        public final String getDeliveryStreamARN() {
            return this.deliveryStreamARN;
        }

        @Override
        public final Builder deliveryStreamARN(String deliveryStreamARN) {
            this.deliveryStreamARN = deliveryStreamARN;
            return this;
        }

        public final void setDeliveryStreamARN(String deliveryStreamARN) {
            this.deliveryStreamARN = deliveryStreamARN;
        }

        public final String getDeliveryStreamStatusAsString() {
            return this.deliveryStreamStatus;
        }

        @Override
        public final Builder deliveryStreamStatus(String deliveryStreamStatus) {
            this.deliveryStreamStatus = deliveryStreamStatus;
            return this;
        }

        @Override
        public final Builder deliveryStreamStatus(DeliveryStreamStatus deliveryStreamStatus) {
            this.deliveryStreamStatus(deliveryStreamStatus.toString());
            return this;
        }

        public final void setDeliveryStreamStatus(String deliveryStreamStatus) {
            this.deliveryStreamStatus = deliveryStreamStatus;
        }

        public final DeliveryStreamEncryptionConfiguration.Builder getDeliveryStreamEncryptionConfiguration() {
            return this.deliveryStreamEncryptionConfiguration != null ? this.deliveryStreamEncryptionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder deliveryStreamEncryptionConfiguration(DeliveryStreamEncryptionConfiguration deliveryStreamEncryptionConfiguration) {
            this.deliveryStreamEncryptionConfiguration = deliveryStreamEncryptionConfiguration;
            return this;
        }

        public final void setDeliveryStreamEncryptionConfiguration(DeliveryStreamEncryptionConfiguration.BuilderImpl deliveryStreamEncryptionConfiguration) {
            this.deliveryStreamEncryptionConfiguration = deliveryStreamEncryptionConfiguration != null ? deliveryStreamEncryptionConfiguration.build() : null;
        }

        public final String getDeliveryStreamTypeAsString() {
            return this.deliveryStreamType;
        }

        @Override
        public final Builder deliveryStreamType(String deliveryStreamType) {
            this.deliveryStreamType = deliveryStreamType;
            return this;
        }

        @Override
        public final Builder deliveryStreamType(DeliveryStreamType deliveryStreamType) {
            this.deliveryStreamType(deliveryStreamType.toString());
            return this;
        }

        public final void setDeliveryStreamType(String deliveryStreamType) {
            this.deliveryStreamType = deliveryStreamType;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final Instant getCreateTimestamp() {
            return this.createTimestamp;
        }

        @Override
        public final Builder createTimestamp(Instant createTimestamp) {
            this.createTimestamp = createTimestamp;
            return this;
        }

        public final void setCreateTimestamp(Instant createTimestamp) {
            this.createTimestamp = createTimestamp;
        }

        public final Instant getLastUpdateTimestamp() {
            return this.lastUpdateTimestamp;
        }

        @Override
        public final Builder lastUpdateTimestamp(Instant lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
            return this;
        }

        public final void setLastUpdateTimestamp(Instant lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
        }

        public final SourceDescription.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        @Override
        public final Builder source(SourceDescription source) {
            this.source = source;
            return this;
        }

        public final void setSource(SourceDescription.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        public final Collection<DestinationDescription.Builder> getDestinations() {
            return this.destinations != null ? (Collection)this.destinations.stream().map(DestinationDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder destinations(Collection<DestinationDescription> destinations) {
            this.destinations = DestinationDescriptionListCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(DestinationDescription ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<DestinationDescription.Builder> ... destinations) {
            this.destinations(Stream.of(destinations).map(c -> (DestinationDescription)((DestinationDescription.Builder)DestinationDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDestinations(Collection<DestinationDescription.BuilderImpl> destinations) {
            this.destinations = DestinationDescriptionListCopier.copyFromBuilder(destinations);
        }

        public final Boolean getHasMoreDestinations() {
            return this.hasMoreDestinations;
        }

        @Override
        public final Builder hasMoreDestinations(Boolean hasMoreDestinations) {
            this.hasMoreDestinations = hasMoreDestinations;
            return this;
        }

        public final void setHasMoreDestinations(Boolean hasMoreDestinations) {
            this.hasMoreDestinations = hasMoreDestinations;
        }

        public DeliveryStreamDescription build() {
            return new DeliveryStreamDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeliveryStreamDescription> {
        public Builder deliveryStreamName(String var1);

        public Builder deliveryStreamARN(String var1);

        public Builder deliveryStreamStatus(String var1);

        public Builder deliveryStreamStatus(DeliveryStreamStatus var1);

        public Builder deliveryStreamEncryptionConfiguration(DeliveryStreamEncryptionConfiguration var1);

        default public Builder deliveryStreamEncryptionConfiguration(Consumer<DeliveryStreamEncryptionConfiguration.Builder> deliveryStreamEncryptionConfiguration) {
            return this.deliveryStreamEncryptionConfiguration((DeliveryStreamEncryptionConfiguration)((DeliveryStreamEncryptionConfiguration.Builder)DeliveryStreamEncryptionConfiguration.builder().applyMutation(deliveryStreamEncryptionConfiguration)).build());
        }

        public Builder deliveryStreamType(String var1);

        public Builder deliveryStreamType(DeliveryStreamType var1);

        public Builder versionId(String var1);

        public Builder createTimestamp(Instant var1);

        public Builder lastUpdateTimestamp(Instant var1);

        public Builder source(SourceDescription var1);

        default public Builder source(Consumer<SourceDescription.Builder> source) {
            return this.source((SourceDescription)((SourceDescription.Builder)SourceDescription.builder().applyMutation(source)).build());
        }

        public Builder destinations(Collection<DestinationDescription> var1);

        public Builder destinations(DestinationDescription ... var1);

        public Builder destinations(Consumer<DestinationDescription.Builder> ... var1);

        public Builder hasMoreDestinations(Boolean var1);
    }
}

