/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the destination configure settings for Apache Iceberg Table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IcebergDestinationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<IcebergDestinationConfiguration.Builder, IcebergDestinationConfiguration> {
    private static final SdkField<List<DestinationTableConfiguration>> DESTINATION_TABLE_CONFIGURATION_LIST_FIELD = SdkField
            .<List<DestinationTableConfiguration>> builder(MarshallingType.LIST)
            .memberName("DestinationTableConfigurationList")
            .getter(getter(IcebergDestinationConfiguration::destinationTableConfigurationList))
            .setter(setter(Builder::destinationTableConfigurationList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationTableConfigurationList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DestinationTableConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(DestinationTableConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SchemaEvolutionConfiguration> SCHEMA_EVOLUTION_CONFIGURATION_FIELD = SdkField
            .<SchemaEvolutionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("SchemaEvolutionConfiguration")
            .getter(getter(IcebergDestinationConfiguration::schemaEvolutionConfiguration))
            .setter(setter(Builder::schemaEvolutionConfiguration))
            .constructor(SchemaEvolutionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaEvolutionConfiguration")
                    .build()).build();

    private static final SdkField<TableCreationConfiguration> TABLE_CREATION_CONFIGURATION_FIELD = SdkField
            .<TableCreationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("TableCreationConfiguration")
            .getter(getter(IcebergDestinationConfiguration::tableCreationConfiguration))
            .setter(setter(Builder::tableCreationConfiguration))
            .constructor(TableCreationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableCreationConfiguration").build())
            .build();

    private static final SdkField<BufferingHints> BUFFERING_HINTS_FIELD = SdkField
            .<BufferingHints> builder(MarshallingType.SDK_POJO).memberName("BufferingHints")
            .getter(getter(IcebergDestinationConfiguration::bufferingHints)).setter(setter(Builder::bufferingHints))
            .constructor(BufferingHints::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BufferingHints").build()).build();

    private static final SdkField<CloudWatchLoggingOptions> CLOUD_WATCH_LOGGING_OPTIONS_FIELD = SdkField
            .<CloudWatchLoggingOptions> builder(MarshallingType.SDK_POJO).memberName("CloudWatchLoggingOptions")
            .getter(getter(IcebergDestinationConfiguration::cloudWatchLoggingOptions))
            .setter(setter(Builder::cloudWatchLoggingOptions)).constructor(CloudWatchLoggingOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptions").build())
            .build();

    private static final SdkField<ProcessingConfiguration> PROCESSING_CONFIGURATION_FIELD = SdkField
            .<ProcessingConfiguration> builder(MarshallingType.SDK_POJO).memberName("ProcessingConfiguration")
            .getter(getter(IcebergDestinationConfiguration::processingConfiguration))
            .setter(setter(Builder::processingConfiguration)).constructor(ProcessingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingConfiguration").build())
            .build();

    private static final SdkField<String> S3_BACKUP_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3BackupMode").getter(getter(IcebergDestinationConfiguration::s3BackupModeAsString))
            .setter(setter(Builder::s3BackupMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BackupMode").build()).build();

    private static final SdkField<RetryOptions> RETRY_OPTIONS_FIELD = SdkField.<RetryOptions> builder(MarshallingType.SDK_POJO)
            .memberName("RetryOptions").getter(getter(IcebergDestinationConfiguration::retryOptions))
            .setter(setter(Builder::retryOptions)).constructor(RetryOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryOptions").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleARN").getter(getter(IcebergDestinationConfiguration::roleARN)).setter(setter(Builder::roleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()).build();

    private static final SdkField<Boolean> APPEND_ONLY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AppendOnly").getter(getter(IcebergDestinationConfiguration::appendOnly))
            .setter(setter(Builder::appendOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppendOnly").build()).build();

    private static final SdkField<CatalogConfiguration> CATALOG_CONFIGURATION_FIELD = SdkField
            .<CatalogConfiguration> builder(MarshallingType.SDK_POJO).memberName("CatalogConfiguration")
            .getter(getter(IcebergDestinationConfiguration::catalogConfiguration)).setter(setter(Builder::catalogConfiguration))
            .constructor(CatalogConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogConfiguration").build())
            .build();

    private static final SdkField<S3DestinationConfiguration> S3_CONFIGURATION_FIELD = SdkField
            .<S3DestinationConfiguration> builder(MarshallingType.SDK_POJO).memberName("S3Configuration")
            .getter(getter(IcebergDestinationConfiguration::s3Configuration)).setter(setter(Builder::s3Configuration))
            .constructor(S3DestinationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Configuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DESTINATION_TABLE_CONFIGURATION_LIST_FIELD, SCHEMA_EVOLUTION_CONFIGURATION_FIELD, TABLE_CREATION_CONFIGURATION_FIELD,
            BUFFERING_HINTS_FIELD, CLOUD_WATCH_LOGGING_OPTIONS_FIELD, PROCESSING_CONFIGURATION_FIELD, S3_BACKUP_MODE_FIELD,
            RETRY_OPTIONS_FIELD, ROLE_ARN_FIELD, APPEND_ONLY_FIELD, CATALOG_CONFIGURATION_FIELD, S3_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<DestinationTableConfiguration> destinationTableConfigurationList;

    private final SchemaEvolutionConfiguration schemaEvolutionConfiguration;

    private final TableCreationConfiguration tableCreationConfiguration;

    private final BufferingHints bufferingHints;

    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;

    private final ProcessingConfiguration processingConfiguration;

    private final String s3BackupMode;

    private final RetryOptions retryOptions;

    private final String roleARN;

    private final Boolean appendOnly;

    private final CatalogConfiguration catalogConfiguration;

    private final S3DestinationConfiguration s3Configuration;

    private IcebergDestinationConfiguration(BuilderImpl builder) {
        this.destinationTableConfigurationList = builder.destinationTableConfigurationList;
        this.schemaEvolutionConfiguration = builder.schemaEvolutionConfiguration;
        this.tableCreationConfiguration = builder.tableCreationConfiguration;
        this.bufferingHints = builder.bufferingHints;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
        this.processingConfiguration = builder.processingConfiguration;
        this.s3BackupMode = builder.s3BackupMode;
        this.retryOptions = builder.retryOptions;
        this.roleARN = builder.roleARN;
        this.appendOnly = builder.appendOnly;
        this.catalogConfiguration = builder.catalogConfiguration;
        this.s3Configuration = builder.s3Configuration;
    }

    /**
     * For responses, this returns true if the service returned a value for the DestinationTableConfigurationList
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasDestinationTableConfigurationList() {
        return destinationTableConfigurationList != null && !(destinationTableConfigurationList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides a list of <code>DestinationTableConfigurations</code> which Firehose uses to deliver data to Apache
     * Iceberg Tables. Firehose will write data with insert if table specific configuration is not provided here.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestinationTableConfigurationList}
     * method.
     * </p>
     * 
     * @return Provides a list of <code>DestinationTableConfigurations</code> which Firehose uses to deliver data to
     *         Apache Iceberg Tables. Firehose will write data with insert if table specific configuration is not
     *         provided here.
     */
    public final List<DestinationTableConfiguration> destinationTableConfigurationList() {
        return destinationTableConfigurationList;
    }

    /**
     * <p>
     * The configuration to enable automatic schema evolution.
     * </p>
     * <p>
     * Amazon Data Firehose is in preview release and is subject to change.
     * </p>
     * 
     * @return The configuration to enable automatic schema evolution.</p>
     *         <p>
     *         Amazon Data Firehose is in preview release and is subject to change.
     */
    public final SchemaEvolutionConfiguration schemaEvolutionConfiguration() {
        return schemaEvolutionConfiguration;
    }

    /**
     * <p>
     * The configuration to enable automatic table creation.
     * </p>
     * <p>
     * Amazon Data Firehose is in preview release and is subject to change.
     * </p>
     * 
     * @return The configuration to enable automatic table creation.</p>
     *         <p>
     *         Amazon Data Firehose is in preview release and is subject to change.
     */
    public final TableCreationConfiguration tableCreationConfiguration() {
        return tableCreationConfiguration;
    }

    /**
     * Returns the value of the BufferingHints property for this object.
     * 
     * @return The value of the BufferingHints property for this object.
     */
    public final BufferingHints bufferingHints() {
        return bufferingHints;
    }

    /**
     * Returns the value of the CloudWatchLoggingOptions property for this object.
     * 
     * @return The value of the CloudWatchLoggingOptions property for this object.
     */
    public final CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return cloudWatchLoggingOptions;
    }

    /**
     * Returns the value of the ProcessingConfiguration property for this object.
     * 
     * @return The value of the ProcessingConfiguration property for this object.
     */
    public final ProcessingConfiguration processingConfiguration() {
        return processingConfiguration;
    }

    /**
     * <p>
     * Describes how Firehose will backup records. Currently,S3 backup only supports <code>FailedDataOnly</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3BackupMode} will
     * return {@link IcebergS3BackupMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #s3BackupModeAsString}.
     * </p>
     * 
     * @return Describes how Firehose will backup records. Currently,S3 backup only supports <code>FailedDataOnly</code>
     *         .
     * @see IcebergS3BackupMode
     */
    public final IcebergS3BackupMode s3BackupMode() {
        return IcebergS3BackupMode.fromValue(s3BackupMode);
    }

    /**
     * <p>
     * Describes how Firehose will backup records. Currently,S3 backup only supports <code>FailedDataOnly</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3BackupMode} will
     * return {@link IcebergS3BackupMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #s3BackupModeAsString}.
     * </p>
     * 
     * @return Describes how Firehose will backup records. Currently,S3 backup only supports <code>FailedDataOnly</code>
     *         .
     * @see IcebergS3BackupMode
     */
    public final String s3BackupModeAsString() {
        return s3BackupMode;
    }

    /**
     * Returns the value of the RetryOptions property for this object.
     * 
     * @return The value of the RetryOptions property for this object.
     */
    public final RetryOptions retryOptions() {
        return retryOptions;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role to be assumed by Firehose for calling Apache Iceberg Tables.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role to be assumed by Firehose for calling Apache Iceberg
     *         Tables.
     */
    public final String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * Describes whether all incoming data for this delivery stream will be append only (inserts only and not for
     * updates and deletes) for Iceberg delivery. This feature is only applicable for Apache Iceberg Tables.
     * </p>
     * <p>
     * The default value is false. If you set this value to true, Firehose automatically increases the throughput limit
     * of a stream based on the throttling levels of the stream. If you set this parameter to true for a stream with
     * updates and deletes, you will see out of order delivery.
     * </p>
     * 
     * @return Describes whether all incoming data for this delivery stream will be append only (inserts only and not
     *         for updates and deletes) for Iceberg delivery. This feature is only applicable for Apache Iceberg
     *         Tables.</p>
     *         <p>
     *         The default value is false. If you set this value to true, Firehose automatically increases the
     *         throughput limit of a stream based on the throttling levels of the stream. If you set this parameter to
     *         true for a stream with updates and deletes, you will see out of order delivery.
     */
    public final Boolean appendOnly() {
        return appendOnly;
    }

    /**
     * <p>
     * Configuration describing where the destination Apache Iceberg Tables are persisted.
     * </p>
     * 
     * @return Configuration describing where the destination Apache Iceberg Tables are persisted.
     */
    public final CatalogConfiguration catalogConfiguration() {
        return catalogConfiguration;
    }

    /**
     * Returns the value of the S3Configuration property for this object.
     * 
     * @return The value of the S3Configuration property for this object.
     */
    public final S3DestinationConfiguration s3Configuration() {
        return s3Configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode
                + Objects.hashCode(hasDestinationTableConfigurationList() ? destinationTableConfigurationList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(schemaEvolutionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(tableCreationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(bufferingHints());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLoggingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(processingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(s3BackupModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(retryOptions());
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(appendOnly());
        hashCode = 31 * hashCode + Objects.hashCode(catalogConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(s3Configuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IcebergDestinationConfiguration)) {
            return false;
        }
        IcebergDestinationConfiguration other = (IcebergDestinationConfiguration) obj;
        return hasDestinationTableConfigurationList() == other.hasDestinationTableConfigurationList()
                && Objects.equals(destinationTableConfigurationList(), other.destinationTableConfigurationList())
                && Objects.equals(schemaEvolutionConfiguration(), other.schemaEvolutionConfiguration())
                && Objects.equals(tableCreationConfiguration(), other.tableCreationConfiguration())
                && Objects.equals(bufferingHints(), other.bufferingHints())
                && Objects.equals(cloudWatchLoggingOptions(), other.cloudWatchLoggingOptions())
                && Objects.equals(processingConfiguration(), other.processingConfiguration())
                && Objects.equals(s3BackupModeAsString(), other.s3BackupModeAsString())
                && Objects.equals(retryOptions(), other.retryOptions()) && Objects.equals(roleARN(), other.roleARN())
                && Objects.equals(appendOnly(), other.appendOnly())
                && Objects.equals(catalogConfiguration(), other.catalogConfiguration())
                && Objects.equals(s3Configuration(), other.s3Configuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("IcebergDestinationConfiguration")
                .add("DestinationTableConfigurationList",
                        hasDestinationTableConfigurationList() ? destinationTableConfigurationList() : null)
                .add("SchemaEvolutionConfiguration", schemaEvolutionConfiguration())
                .add("TableCreationConfiguration", tableCreationConfiguration()).add("BufferingHints", bufferingHints())
                .add("CloudWatchLoggingOptions", cloudWatchLoggingOptions())
                .add("ProcessingConfiguration", processingConfiguration()).add("S3BackupMode", s3BackupModeAsString())
                .add("RetryOptions", retryOptions()).add("RoleARN", roleARN()).add("AppendOnly", appendOnly())
                .add("CatalogConfiguration", catalogConfiguration()).add("S3Configuration", s3Configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationTableConfigurationList":
            return Optional.ofNullable(clazz.cast(destinationTableConfigurationList()));
        case "SchemaEvolutionConfiguration":
            return Optional.ofNullable(clazz.cast(schemaEvolutionConfiguration()));
        case "TableCreationConfiguration":
            return Optional.ofNullable(clazz.cast(tableCreationConfiguration()));
        case "BufferingHints":
            return Optional.ofNullable(clazz.cast(bufferingHints()));
        case "CloudWatchLoggingOptions":
            return Optional.ofNullable(clazz.cast(cloudWatchLoggingOptions()));
        case "ProcessingConfiguration":
            return Optional.ofNullable(clazz.cast(processingConfiguration()));
        case "S3BackupMode":
            return Optional.ofNullable(clazz.cast(s3BackupModeAsString()));
        case "RetryOptions":
            return Optional.ofNullable(clazz.cast(retryOptions()));
        case "RoleARN":
            return Optional.ofNullable(clazz.cast(roleARN()));
        case "AppendOnly":
            return Optional.ofNullable(clazz.cast(appendOnly()));
        case "CatalogConfiguration":
            return Optional.ofNullable(clazz.cast(catalogConfiguration()));
        case "S3Configuration":
            return Optional.ofNullable(clazz.cast(s3Configuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DestinationTableConfigurationList", DESTINATION_TABLE_CONFIGURATION_LIST_FIELD);
        map.put("SchemaEvolutionConfiguration", SCHEMA_EVOLUTION_CONFIGURATION_FIELD);
        map.put("TableCreationConfiguration", TABLE_CREATION_CONFIGURATION_FIELD);
        map.put("BufferingHints", BUFFERING_HINTS_FIELD);
        map.put("CloudWatchLoggingOptions", CLOUD_WATCH_LOGGING_OPTIONS_FIELD);
        map.put("ProcessingConfiguration", PROCESSING_CONFIGURATION_FIELD);
        map.put("S3BackupMode", S3_BACKUP_MODE_FIELD);
        map.put("RetryOptions", RETRY_OPTIONS_FIELD);
        map.put("RoleARN", ROLE_ARN_FIELD);
        map.put("AppendOnly", APPEND_ONLY_FIELD);
        map.put("CatalogConfiguration", CATALOG_CONFIGURATION_FIELD);
        map.put("S3Configuration", S3_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IcebergDestinationConfiguration, T> g) {
        return obj -> g.apply((IcebergDestinationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IcebergDestinationConfiguration> {
        /**
         * <p>
         * Provides a list of <code>DestinationTableConfigurations</code> which Firehose uses to deliver data to Apache
         * Iceberg Tables. Firehose will write data with insert if table specific configuration is not provided here.
         * </p>
         * 
         * @param destinationTableConfigurationList
         *        Provides a list of <code>DestinationTableConfigurations</code> which Firehose uses to deliver data to
         *        Apache Iceberg Tables. Firehose will write data with insert if table specific configuration is not
         *        provided here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationTableConfigurationList(Collection<DestinationTableConfiguration> destinationTableConfigurationList);

        /**
         * <p>
         * Provides a list of <code>DestinationTableConfigurations</code> which Firehose uses to deliver data to Apache
         * Iceberg Tables. Firehose will write data with insert if table specific configuration is not provided here.
         * </p>
         * 
         * @param destinationTableConfigurationList
         *        Provides a list of <code>DestinationTableConfigurations</code> which Firehose uses to deliver data to
         *        Apache Iceberg Tables. Firehose will write data with insert if table specific configuration is not
         *        provided here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationTableConfigurationList(DestinationTableConfiguration... destinationTableConfigurationList);

        /**
         * <p>
         * Provides a list of <code>DestinationTableConfigurations</code> which Firehose uses to deliver data to Apache
         * Iceberg Tables. Firehose will write data with insert if table specific configuration is not provided here.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.firehose.model.DestinationTableConfiguration.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.firehose.model.DestinationTableConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.firehose.model.DestinationTableConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #destinationTableConfigurationList(List<DestinationTableConfiguration>)}.
         * 
         * @param destinationTableConfigurationList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.firehose.model.DestinationTableConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationTableConfigurationList(java.util.Collection<DestinationTableConfiguration>)
         */
        Builder destinationTableConfigurationList(
                Consumer<DestinationTableConfiguration.Builder>... destinationTableConfigurationList);

        /**
         * <p>
         * The configuration to enable automatic schema evolution.
         * </p>
         * <p>
         * Amazon Data Firehose is in preview release and is subject to change.
         * </p>
         * 
         * @param schemaEvolutionConfiguration
         *        The configuration to enable automatic schema evolution.</p>
         *        <p>
         *        Amazon Data Firehose is in preview release and is subject to change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaEvolutionConfiguration(SchemaEvolutionConfiguration schemaEvolutionConfiguration);

        /**
         * <p>
         * The configuration to enable automatic schema evolution.
         * </p>
         * <p>
         * Amazon Data Firehose is in preview release and is subject to change.
         * </p>
         * This is a convenience method that creates an instance of the {@link SchemaEvolutionConfiguration.Builder}
         * avoiding the need to create one manually via {@link SchemaEvolutionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SchemaEvolutionConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #schemaEvolutionConfiguration(SchemaEvolutionConfiguration)}.
         * 
         * @param schemaEvolutionConfiguration
         *        a consumer that will call methods on {@link SchemaEvolutionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schemaEvolutionConfiguration(SchemaEvolutionConfiguration)
         */
        default Builder schemaEvolutionConfiguration(Consumer<SchemaEvolutionConfiguration.Builder> schemaEvolutionConfiguration) {
            return schemaEvolutionConfiguration(SchemaEvolutionConfiguration.builder()
                    .applyMutation(schemaEvolutionConfiguration).build());
        }

        /**
         * <p>
         * The configuration to enable automatic table creation.
         * </p>
         * <p>
         * Amazon Data Firehose is in preview release and is subject to change.
         * </p>
         * 
         * @param tableCreationConfiguration
         *        The configuration to enable automatic table creation.</p>
         *        <p>
         *        Amazon Data Firehose is in preview release and is subject to change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableCreationConfiguration(TableCreationConfiguration tableCreationConfiguration);

        /**
         * <p>
         * The configuration to enable automatic table creation.
         * </p>
         * <p>
         * Amazon Data Firehose is in preview release and is subject to change.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableCreationConfiguration.Builder}
         * avoiding the need to create one manually via {@link TableCreationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableCreationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #tableCreationConfiguration(TableCreationConfiguration)}.
         * 
         * @param tableCreationConfiguration
         *        a consumer that will call methods on {@link TableCreationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tableCreationConfiguration(TableCreationConfiguration)
         */
        default Builder tableCreationConfiguration(Consumer<TableCreationConfiguration.Builder> tableCreationConfiguration) {
            return tableCreationConfiguration(TableCreationConfiguration.builder().applyMutation(tableCreationConfiguration)
                    .build());
        }

        /**
         * Sets the value of the BufferingHints property for this object.
         *
         * @param bufferingHints
         *        The new value for the BufferingHints property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bufferingHints(BufferingHints bufferingHints);

        /**
         * Sets the value of the BufferingHints property for this object.
         *
         * This is a convenience method that creates an instance of the {@link BufferingHints.Builder} avoiding the need
         * to create one manually via {@link BufferingHints#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BufferingHints.Builder#build()} is called immediately and its
         * result is passed to {@link #bufferingHints(BufferingHints)}.
         * 
         * @param bufferingHints
         *        a consumer that will call methods on {@link BufferingHints.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bufferingHints(BufferingHints)
         */
        default Builder bufferingHints(Consumer<BufferingHints.Builder> bufferingHints) {
            return bufferingHints(BufferingHints.builder().applyMutation(bufferingHints).build());
        }

        /**
         * Sets the value of the CloudWatchLoggingOptions property for this object.
         *
         * @param cloudWatchLoggingOptions
         *        The new value for the CloudWatchLoggingOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions);

        /**
         * Sets the value of the CloudWatchLoggingOptions property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CloudWatchLoggingOptions.Builder}
         * avoiding the need to create one manually via {@link CloudWatchLoggingOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudWatchLoggingOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #cloudWatchLoggingOptions(CloudWatchLoggingOptions)}.
         * 
         * @param cloudWatchLoggingOptions
         *        a consumer that will call methods on {@link CloudWatchLoggingOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLoggingOptions(CloudWatchLoggingOptions)
         */
        default Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOptions.Builder> cloudWatchLoggingOptions) {
            return cloudWatchLoggingOptions(CloudWatchLoggingOptions.builder().applyMutation(cloudWatchLoggingOptions).build());
        }

        /**
         * Sets the value of the ProcessingConfiguration property for this object.
         *
         * @param processingConfiguration
         *        The new value for the ProcessingConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingConfiguration(ProcessingConfiguration processingConfiguration);

        /**
         * Sets the value of the ProcessingConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ProcessingConfiguration.Builder} avoiding
         * the need to create one manually via {@link ProcessingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProcessingConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #processingConfiguration(ProcessingConfiguration)}.
         * 
         * @param processingConfiguration
         *        a consumer that will call methods on {@link ProcessingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processingConfiguration(ProcessingConfiguration)
         */
        default Builder processingConfiguration(Consumer<ProcessingConfiguration.Builder> processingConfiguration) {
            return processingConfiguration(ProcessingConfiguration.builder().applyMutation(processingConfiguration).build());
        }

        /**
         * <p>
         * Describes how Firehose will backup records. Currently,S3 backup only supports <code>FailedDataOnly</code>.
         * </p>
         * 
         * @param s3BackupMode
         *        Describes how Firehose will backup records. Currently,S3 backup only supports
         *        <code>FailedDataOnly</code>.
         * @see IcebergS3BackupMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IcebergS3BackupMode
         */
        Builder s3BackupMode(String s3BackupMode);

        /**
         * <p>
         * Describes how Firehose will backup records. Currently,S3 backup only supports <code>FailedDataOnly</code>.
         * </p>
         * 
         * @param s3BackupMode
         *        Describes how Firehose will backup records. Currently,S3 backup only supports
         *        <code>FailedDataOnly</code>.
         * @see IcebergS3BackupMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IcebergS3BackupMode
         */
        Builder s3BackupMode(IcebergS3BackupMode s3BackupMode);

        /**
         * Sets the value of the RetryOptions property for this object.
         *
         * @param retryOptions
         *        The new value for the RetryOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryOptions(RetryOptions retryOptions);

        /**
         * Sets the value of the RetryOptions property for this object.
         *
         * This is a convenience method that creates an instance of the {@link RetryOptions.Builder} avoiding the need
         * to create one manually via {@link RetryOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetryOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #retryOptions(RetryOptions)}.
         * 
         * @param retryOptions
         *        a consumer that will call methods on {@link RetryOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retryOptions(RetryOptions)
         */
        default Builder retryOptions(Consumer<RetryOptions.Builder> retryOptions) {
            return retryOptions(RetryOptions.builder().applyMutation(retryOptions).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role to be assumed by Firehose for calling Apache Iceberg Tables.
         * </p>
         * 
         * @param roleARN
         *        The Amazon Resource Name (ARN) of the IAM role to be assumed by Firehose for calling Apache Iceberg
         *        Tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * Describes whether all incoming data for this delivery stream will be append only (inserts only and not for
         * updates and deletes) for Iceberg delivery. This feature is only applicable for Apache Iceberg Tables.
         * </p>
         * <p>
         * The default value is false. If you set this value to true, Firehose automatically increases the throughput
         * limit of a stream based on the throttling levels of the stream. If you set this parameter to true for a
         * stream with updates and deletes, you will see out of order delivery.
         * </p>
         * 
         * @param appendOnly
         *        Describes whether all incoming data for this delivery stream will be append only (inserts only and not
         *        for updates and deletes) for Iceberg delivery. This feature is only applicable for Apache Iceberg
         *        Tables.</p>
         *        <p>
         *        The default value is false. If you set this value to true, Firehose automatically increases the
         *        throughput limit of a stream based on the throttling levels of the stream. If you set this parameter
         *        to true for a stream with updates and deletes, you will see out of order delivery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appendOnly(Boolean appendOnly);

        /**
         * <p>
         * Configuration describing where the destination Apache Iceberg Tables are persisted.
         * </p>
         * 
         * @param catalogConfiguration
         *        Configuration describing where the destination Apache Iceberg Tables are persisted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogConfiguration(CatalogConfiguration catalogConfiguration);

        /**
         * <p>
         * Configuration describing where the destination Apache Iceberg Tables are persisted.
         * </p>
         * This is a convenience method that creates an instance of the {@link CatalogConfiguration.Builder} avoiding
         * the need to create one manually via {@link CatalogConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CatalogConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #catalogConfiguration(CatalogConfiguration)}.
         * 
         * @param catalogConfiguration
         *        a consumer that will call methods on {@link CatalogConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #catalogConfiguration(CatalogConfiguration)
         */
        default Builder catalogConfiguration(Consumer<CatalogConfiguration.Builder> catalogConfiguration) {
            return catalogConfiguration(CatalogConfiguration.builder().applyMutation(catalogConfiguration).build());
        }

        /**
         * Sets the value of the S3Configuration property for this object.
         *
         * @param s3Configuration
         *        The new value for the S3Configuration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Configuration(S3DestinationConfiguration s3Configuration);

        /**
         * Sets the value of the S3Configuration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link S3DestinationConfiguration.Builder}
         * avoiding the need to create one manually via {@link S3DestinationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3DestinationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #s3Configuration(S3DestinationConfiguration)}.
         * 
         * @param s3Configuration
         *        a consumer that will call methods on {@link S3DestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Configuration(S3DestinationConfiguration)
         */
        default Builder s3Configuration(Consumer<S3DestinationConfiguration.Builder> s3Configuration) {
            return s3Configuration(S3DestinationConfiguration.builder().applyMutation(s3Configuration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<DestinationTableConfiguration> destinationTableConfigurationList = DefaultSdkAutoConstructList.getInstance();

        private SchemaEvolutionConfiguration schemaEvolutionConfiguration;

        private TableCreationConfiguration tableCreationConfiguration;

        private BufferingHints bufferingHints;

        private CloudWatchLoggingOptions cloudWatchLoggingOptions;

        private ProcessingConfiguration processingConfiguration;

        private String s3BackupMode;

        private RetryOptions retryOptions;

        private String roleARN;

        private Boolean appendOnly;

        private CatalogConfiguration catalogConfiguration;

        private S3DestinationConfiguration s3Configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(IcebergDestinationConfiguration model) {
            destinationTableConfigurationList(model.destinationTableConfigurationList);
            schemaEvolutionConfiguration(model.schemaEvolutionConfiguration);
            tableCreationConfiguration(model.tableCreationConfiguration);
            bufferingHints(model.bufferingHints);
            cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
            processingConfiguration(model.processingConfiguration);
            s3BackupMode(model.s3BackupMode);
            retryOptions(model.retryOptions);
            roleARN(model.roleARN);
            appendOnly(model.appendOnly);
            catalogConfiguration(model.catalogConfiguration);
            s3Configuration(model.s3Configuration);
        }

        public final List<DestinationTableConfiguration.Builder> getDestinationTableConfigurationList() {
            List<DestinationTableConfiguration.Builder> result = DestinationTableConfigurationListCopier
                    .copyToBuilder(this.destinationTableConfigurationList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinationTableConfigurationList(
                Collection<DestinationTableConfiguration.BuilderImpl> destinationTableConfigurationList) {
            this.destinationTableConfigurationList = DestinationTableConfigurationListCopier
                    .copyFromBuilder(destinationTableConfigurationList);
        }

        @Override
        public final Builder destinationTableConfigurationList(
                Collection<DestinationTableConfiguration> destinationTableConfigurationList) {
            this.destinationTableConfigurationList = DestinationTableConfigurationListCopier
                    .copy(destinationTableConfigurationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationTableConfigurationList(DestinationTableConfiguration... destinationTableConfigurationList) {
            destinationTableConfigurationList(Arrays.asList(destinationTableConfigurationList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationTableConfigurationList(
                Consumer<DestinationTableConfiguration.Builder>... destinationTableConfigurationList) {
            destinationTableConfigurationList(Stream.of(destinationTableConfigurationList)
                    .map(c -> DestinationTableConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final SchemaEvolutionConfiguration.Builder getSchemaEvolutionConfiguration() {
            return schemaEvolutionConfiguration != null ? schemaEvolutionConfiguration.toBuilder() : null;
        }

        public final void setSchemaEvolutionConfiguration(SchemaEvolutionConfiguration.BuilderImpl schemaEvolutionConfiguration) {
            this.schemaEvolutionConfiguration = schemaEvolutionConfiguration != null ? schemaEvolutionConfiguration.build()
                    : null;
        }

        @Override
        public final Builder schemaEvolutionConfiguration(SchemaEvolutionConfiguration schemaEvolutionConfiguration) {
            this.schemaEvolutionConfiguration = schemaEvolutionConfiguration;
            return this;
        }

        public final TableCreationConfiguration.Builder getTableCreationConfiguration() {
            return tableCreationConfiguration != null ? tableCreationConfiguration.toBuilder() : null;
        }

        public final void setTableCreationConfiguration(TableCreationConfiguration.BuilderImpl tableCreationConfiguration) {
            this.tableCreationConfiguration = tableCreationConfiguration != null ? tableCreationConfiguration.build() : null;
        }

        @Override
        public final Builder tableCreationConfiguration(TableCreationConfiguration tableCreationConfiguration) {
            this.tableCreationConfiguration = tableCreationConfiguration;
            return this;
        }

        public final BufferingHints.Builder getBufferingHints() {
            return bufferingHints != null ? bufferingHints.toBuilder() : null;
        }

        public final void setBufferingHints(BufferingHints.BuilderImpl bufferingHints) {
            this.bufferingHints = bufferingHints != null ? bufferingHints.build() : null;
        }

        @Override
        public final Builder bufferingHints(BufferingHints bufferingHints) {
            this.bufferingHints = bufferingHints;
            return this;
        }

        public final CloudWatchLoggingOptions.Builder getCloudWatchLoggingOptions() {
            return cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.toBuilder() : null;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions.BuilderImpl cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.build() : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public final ProcessingConfiguration.Builder getProcessingConfiguration() {
            return processingConfiguration != null ? processingConfiguration.toBuilder() : null;
        }

        public final void setProcessingConfiguration(ProcessingConfiguration.BuilderImpl processingConfiguration) {
            this.processingConfiguration = processingConfiguration != null ? processingConfiguration.build() : null;
        }

        @Override
        public final Builder processingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
            return this;
        }

        public final String getS3BackupMode() {
            return s3BackupMode;
        }

        public final void setS3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
        }

        @Override
        public final Builder s3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
            return this;
        }

        @Override
        public final Builder s3BackupMode(IcebergS3BackupMode s3BackupMode) {
            this.s3BackupMode(s3BackupMode == null ? null : s3BackupMode.toString());
            return this;
        }

        public final RetryOptions.Builder getRetryOptions() {
            return retryOptions != null ? retryOptions.toBuilder() : null;
        }

        public final void setRetryOptions(RetryOptions.BuilderImpl retryOptions) {
            this.retryOptions = retryOptions != null ? retryOptions.build() : null;
        }

        @Override
        public final Builder retryOptions(RetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public final String getRoleARN() {
            return roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final Boolean getAppendOnly() {
            return appendOnly;
        }

        public final void setAppendOnly(Boolean appendOnly) {
            this.appendOnly = appendOnly;
        }

        @Override
        public final Builder appendOnly(Boolean appendOnly) {
            this.appendOnly = appendOnly;
            return this;
        }

        public final CatalogConfiguration.Builder getCatalogConfiguration() {
            return catalogConfiguration != null ? catalogConfiguration.toBuilder() : null;
        }

        public final void setCatalogConfiguration(CatalogConfiguration.BuilderImpl catalogConfiguration) {
            this.catalogConfiguration = catalogConfiguration != null ? catalogConfiguration.build() : null;
        }

        @Override
        public final Builder catalogConfiguration(CatalogConfiguration catalogConfiguration) {
            this.catalogConfiguration = catalogConfiguration;
            return this;
        }

        public final S3DestinationConfiguration.Builder getS3Configuration() {
            return s3Configuration != null ? s3Configuration.toBuilder() : null;
        }

        public final void setS3Configuration(S3DestinationConfiguration.BuilderImpl s3Configuration) {
            this.s3Configuration = s3Configuration != null ? s3Configuration.build() : null;
        }

        @Override
        public final Builder s3Configuration(S3DestinationConfiguration s3Configuration) {
            this.s3Configuration = s3Configuration;
            return this;
        }

        @Override
        public IcebergDestinationConfiguration build() {
            return new IcebergDestinationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
