/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The native Hive / HCatalog JsonSerDe. Used by Firehose for deserializing data, which means converting it from the
 * JSON format in preparation for serializing it to the Parquet or ORC format. This is one of two deserializers you can
 * choose, depending on which one offers the functionality you need. The other option is the OpenX SerDe.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HiveJsonSerDe implements SdkPojo, Serializable, ToCopyableBuilder<HiveJsonSerDe.Builder, HiveJsonSerDe> {
    private static final SdkField<List<String>> TIMESTAMP_FORMATS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TimestampFormats")
            .getter(getter(HiveJsonSerDe::timestampFormats))
            .setter(setter(Builder::timestampFormats))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestampFormats").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FORMATS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> timestampFormats;

    private HiveJsonSerDe(BuilderImpl builder) {
        this.timestampFormats = builder.timestampFormats;
    }

    /**
     * For responses, this returns true if the service returned a value for the TimestampFormats property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTimestampFormats() {
        return timestampFormats != null && !(timestampFormats instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates how you want Firehose to parse the date and timestamps that may be present in your input data JSON. To
     * specify these format strings, follow the pattern syntax of JodaTime's DateTimeFormat format strings. For more
     * information, see <a href="https://www.joda.org/joda-time/apidocs/org/joda/time/format/DateTimeFormat.html">Class
     * DateTimeFormat</a>. You can also use the special value <code>millis</code> to parse timestamps in epoch
     * milliseconds. If you don't specify a format, Firehose uses <code>java.sql.Timestamp::valueOf</code> by default.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTimestampFormats} method.
     * </p>
     * 
     * @return Indicates how you want Firehose to parse the date and timestamps that may be present in your input data
     *         JSON. To specify these format strings, follow the pattern syntax of JodaTime's DateTimeFormat format
     *         strings. For more information, see <a
     *         href="https://www.joda.org/joda-time/apidocs/org/joda/time/format/DateTimeFormat.html">Class
     *         DateTimeFormat</a>. You can also use the special value <code>millis</code> to parse timestamps in epoch
     *         milliseconds. If you don't specify a format, Firehose uses <code>java.sql.Timestamp::valueOf</code> by
     *         default.
     */
    public final List<String> timestampFormats() {
        return timestampFormats;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasTimestampFormats() ? timestampFormats() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HiveJsonSerDe)) {
            return false;
        }
        HiveJsonSerDe other = (HiveJsonSerDe) obj;
        return hasTimestampFormats() == other.hasTimestampFormats()
                && Objects.equals(timestampFormats(), other.timestampFormats());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HiveJsonSerDe").add("TimestampFormats", hasTimestampFormats() ? timestampFormats() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimestampFormats":
            return Optional.ofNullable(clazz.cast(timestampFormats()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TimestampFormats", TIMESTAMP_FORMATS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HiveJsonSerDe, T> g) {
        return obj -> g.apply((HiveJsonSerDe) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HiveJsonSerDe> {
        /**
         * <p>
         * Indicates how you want Firehose to parse the date and timestamps that may be present in your input data JSON.
         * To specify these format strings, follow the pattern syntax of JodaTime's DateTimeFormat format strings. For
         * more information, see <a
         * href="https://www.joda.org/joda-time/apidocs/org/joda/time/format/DateTimeFormat.html">Class
         * DateTimeFormat</a>. You can also use the special value <code>millis</code> to parse timestamps in epoch
         * milliseconds. If you don't specify a format, Firehose uses <code>java.sql.Timestamp::valueOf</code> by
         * default.
         * </p>
         * 
         * @param timestampFormats
         *        Indicates how you want Firehose to parse the date and timestamps that may be present in your input
         *        data JSON. To specify these format strings, follow the pattern syntax of JodaTime's DateTimeFormat
         *        format strings. For more information, see <a
         *        href="https://www.joda.org/joda-time/apidocs/org/joda/time/format/DateTimeFormat.html">Class
         *        DateTimeFormat</a>. You can also use the special value <code>millis</code> to parse timestamps in
         *        epoch milliseconds. If you don't specify a format, Firehose uses
         *        <code>java.sql.Timestamp::valueOf</code> by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampFormats(Collection<String> timestampFormats);

        /**
         * <p>
         * Indicates how you want Firehose to parse the date and timestamps that may be present in your input data JSON.
         * To specify these format strings, follow the pattern syntax of JodaTime's DateTimeFormat format strings. For
         * more information, see <a
         * href="https://www.joda.org/joda-time/apidocs/org/joda/time/format/DateTimeFormat.html">Class
         * DateTimeFormat</a>. You can also use the special value <code>millis</code> to parse timestamps in epoch
         * milliseconds. If you don't specify a format, Firehose uses <code>java.sql.Timestamp::valueOf</code> by
         * default.
         * </p>
         * 
         * @param timestampFormats
         *        Indicates how you want Firehose to parse the date and timestamps that may be present in your input
         *        data JSON. To specify these format strings, follow the pattern syntax of JodaTime's DateTimeFormat
         *        format strings. For more information, see <a
         *        href="https://www.joda.org/joda-time/apidocs/org/joda/time/format/DateTimeFormat.html">Class
         *        DateTimeFormat</a>. You can also use the special value <code>millis</code> to parse timestamps in
         *        epoch milliseconds. If you don't specify a format, Firehose uses
         *        <code>java.sql.Timestamp::valueOf</code> by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampFormats(String... timestampFormats);
    }

    static final class BuilderImpl implements Builder {
        private List<String> timestampFormats = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HiveJsonSerDe model) {
            timestampFormats(model.timestampFormats);
        }

        public final Collection<String> getTimestampFormats() {
            if (timestampFormats instanceof SdkAutoConstructList) {
                return null;
            }
            return timestampFormats;
        }

        public final void setTimestampFormats(Collection<String> timestampFormats) {
            this.timestampFormats = ListOfNonEmptyStringsCopier.copy(timestampFormats);
        }

        @Override
        public final Builder timestampFormats(Collection<String> timestampFormats) {
            this.timestampFormats = ListOfNonEmptyStringsCopier.copy(timestampFormats);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timestampFormats(String... timestampFormats) {
            timestampFormats(Arrays.asList(timestampFormats));
            return this;
        }

        @Override
        public HiveJsonSerDe build() {
            return new HiveJsonSerDe(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
