/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure that describes the snapshot information of a table in source database endpoint that Firehose reads.
 * </p>
 * <p>
 * Amazon Data Firehose is in preview release and is subject to change.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatabaseSnapshotInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<DatabaseSnapshotInfo.Builder, DatabaseSnapshotInfo> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(DatabaseSnapshotInfo::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> TABLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Table")
            .getter(getter(DatabaseSnapshotInfo::table)).setter(setter(Builder::table))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()).build();

    private static final SdkField<Instant> REQUEST_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("RequestTimestamp").getter(getter(DatabaseSnapshotInfo::requestTimestamp))
            .setter(setter(Builder::requestTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestTimestamp").build()).build();

    private static final SdkField<String> REQUESTED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestedBy").getter(getter(DatabaseSnapshotInfo::requestedByAsString))
            .setter(setter(Builder::requestedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedBy").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DatabaseSnapshotInfo::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<FailureDescription> FAILURE_DESCRIPTION_FIELD = SdkField
            .<FailureDescription> builder(MarshallingType.SDK_POJO).memberName("FailureDescription")
            .getter(getter(DatabaseSnapshotInfo::failureDescription)).setter(setter(Builder::failureDescription))
            .constructor(FailureDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TABLE_FIELD,
            REQUEST_TIMESTAMP_FIELD, REQUESTED_BY_FIELD, STATUS_FIELD, FAILURE_DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String table;

    private final Instant requestTimestamp;

    private final String requestedBy;

    private final String status;

    private final FailureDescription failureDescription;

    private DatabaseSnapshotInfo(BuilderImpl builder) {
        this.id = builder.id;
        this.table = builder.table;
        this.requestTimestamp = builder.requestTimestamp;
        this.requestedBy = builder.requestedBy;
        this.status = builder.status;
        this.failureDescription = builder.failureDescription;
    }

    /**
     * <p>
     * The identifier of the current snapshot of the table in source database endpoint.
     * </p>
     * <p>
     * Amazon Data Firehose is in preview release and is subject to change.
     * </p>
     * 
     * @return The identifier of the current snapshot of the table in source database endpoint. </p>
     *         <p>
     *         Amazon Data Firehose is in preview release and is subject to change.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The fully qualified name of the table in source database endpoint that Firehose reads.
     * </p>
     * <p>
     * Amazon Data Firehose is in preview release and is subject to change.
     * </p>
     * 
     * @return The fully qualified name of the table in source database endpoint that Firehose reads. </p>
     *         <p>
     *         Amazon Data Firehose is in preview release and is subject to change.
     */
    public final String table() {
        return table;
    }

    /**
     * <p>
     * The timestamp when the current snapshot is taken on the table.
     * </p>
     * <p>
     * Amazon Data Firehose is in preview release and is subject to change.
     * </p>
     * 
     * @return The timestamp when the current snapshot is taken on the table. </p>
     *         <p>
     *         Amazon Data Firehose is in preview release and is subject to change.
     */
    public final Instant requestTimestamp() {
        return requestTimestamp;
    }

    /**
     * <p>
     * The principal that sent the request to take the current snapshot on the table.
     * </p>
     * <p>
     * Amazon Data Firehose is in preview release and is subject to change.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #requestedBy} will
     * return {@link SnapshotRequestedBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #requestedByAsString}.
     * </p>
     * 
     * @return The principal that sent the request to take the current snapshot on the table. </p>
     *         <p>
     *         Amazon Data Firehose is in preview release and is subject to change.
     * @see SnapshotRequestedBy
     */
    public final SnapshotRequestedBy requestedBy() {
        return SnapshotRequestedBy.fromValue(requestedBy);
    }

    /**
     * <p>
     * The principal that sent the request to take the current snapshot on the table.
     * </p>
     * <p>
     * Amazon Data Firehose is in preview release and is subject to change.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #requestedBy} will
     * return {@link SnapshotRequestedBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #requestedByAsString}.
     * </p>
     * 
     * @return The principal that sent the request to take the current snapshot on the table. </p>
     *         <p>
     *         Amazon Data Firehose is in preview release and is subject to change.
     * @see SnapshotRequestedBy
     */
    public final String requestedByAsString() {
        return requestedBy;
    }

    /**
     * <p>
     * The status of the current snapshot of the table.
     * </p>
     * <p>
     * Amazon Data Firehose is in preview release and is subject to change.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SnapshotStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the current snapshot of the table. </p>
     *         <p>
     *         Amazon Data Firehose is in preview release and is subject to change.
     * @see SnapshotStatus
     */
    public final SnapshotStatus status() {
        return SnapshotStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the current snapshot of the table.
     * </p>
     * <p>
     * Amazon Data Firehose is in preview release and is subject to change.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SnapshotStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the current snapshot of the table. </p>
     *         <p>
     *         Amazon Data Firehose is in preview release and is subject to change.
     * @see SnapshotStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * Returns the value of the FailureDescription property for this object.
     * 
     * @return The value of the FailureDescription property for this object.
     */
    public final FailureDescription failureDescription() {
        return failureDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(table());
        hashCode = 31 * hashCode + Objects.hashCode(requestTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(requestedByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatabaseSnapshotInfo)) {
            return false;
        }
        DatabaseSnapshotInfo other = (DatabaseSnapshotInfo) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(table(), other.table())
                && Objects.equals(requestTimestamp(), other.requestTimestamp())
                && Objects.equals(requestedByAsString(), other.requestedByAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(failureDescription(), other.failureDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatabaseSnapshotInfo").add("Id", id()).add("Table", table())
                .add("RequestTimestamp", requestTimestamp()).add("RequestedBy", requestedByAsString())
                .add("Status", statusAsString()).add("FailureDescription", failureDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Table":
            return Optional.ofNullable(clazz.cast(table()));
        case "RequestTimestamp":
            return Optional.ofNullable(clazz.cast(requestTimestamp()));
        case "RequestedBy":
            return Optional.ofNullable(clazz.cast(requestedByAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "FailureDescription":
            return Optional.ofNullable(clazz.cast(failureDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Table", TABLE_FIELD);
        map.put("RequestTimestamp", REQUEST_TIMESTAMP_FIELD);
        map.put("RequestedBy", REQUESTED_BY_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("FailureDescription", FAILURE_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DatabaseSnapshotInfo, T> g) {
        return obj -> g.apply((DatabaseSnapshotInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatabaseSnapshotInfo> {
        /**
         * <p>
         * The identifier of the current snapshot of the table in source database endpoint.
         * </p>
         * <p>
         * Amazon Data Firehose is in preview release and is subject to change.
         * </p>
         * 
         * @param id
         *        The identifier of the current snapshot of the table in source database endpoint. </p>
         *        <p>
         *        Amazon Data Firehose is in preview release and is subject to change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The fully qualified name of the table in source database endpoint that Firehose reads.
         * </p>
         * <p>
         * Amazon Data Firehose is in preview release and is subject to change.
         * </p>
         * 
         * @param table
         *        The fully qualified name of the table in source database endpoint that Firehose reads. </p>
         *        <p>
         *        Amazon Data Firehose is in preview release and is subject to change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder table(String table);

        /**
         * <p>
         * The timestamp when the current snapshot is taken on the table.
         * </p>
         * <p>
         * Amazon Data Firehose is in preview release and is subject to change.
         * </p>
         * 
         * @param requestTimestamp
         *        The timestamp when the current snapshot is taken on the table. </p>
         *        <p>
         *        Amazon Data Firehose is in preview release and is subject to change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestTimestamp(Instant requestTimestamp);

        /**
         * <p>
         * The principal that sent the request to take the current snapshot on the table.
         * </p>
         * <p>
         * Amazon Data Firehose is in preview release and is subject to change.
         * </p>
         * 
         * @param requestedBy
         *        The principal that sent the request to take the current snapshot on the table. </p>
         *        <p>
         *        Amazon Data Firehose is in preview release and is subject to change.
         * @see SnapshotRequestedBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotRequestedBy
         */
        Builder requestedBy(String requestedBy);

        /**
         * <p>
         * The principal that sent the request to take the current snapshot on the table.
         * </p>
         * <p>
         * Amazon Data Firehose is in preview release and is subject to change.
         * </p>
         * 
         * @param requestedBy
         *        The principal that sent the request to take the current snapshot on the table. </p>
         *        <p>
         *        Amazon Data Firehose is in preview release and is subject to change.
         * @see SnapshotRequestedBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotRequestedBy
         */
        Builder requestedBy(SnapshotRequestedBy requestedBy);

        /**
         * <p>
         * The status of the current snapshot of the table.
         * </p>
         * <p>
         * Amazon Data Firehose is in preview release and is subject to change.
         * </p>
         * 
         * @param status
         *        The status of the current snapshot of the table. </p>
         *        <p>
         *        Amazon Data Firehose is in preview release and is subject to change.
         * @see SnapshotStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the current snapshot of the table.
         * </p>
         * <p>
         * Amazon Data Firehose is in preview release and is subject to change.
         * </p>
         * 
         * @param status
         *        The status of the current snapshot of the table. </p>
         *        <p>
         *        Amazon Data Firehose is in preview release and is subject to change.
         * @see SnapshotStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotStatus
         */
        Builder status(SnapshotStatus status);

        /**
         * Sets the value of the FailureDescription property for this object.
         *
         * @param failureDescription
         *        The new value for the FailureDescription property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureDescription(FailureDescription failureDescription);

        /**
         * Sets the value of the FailureDescription property for this object.
         *
         * This is a convenience method that creates an instance of the {@link FailureDescription.Builder} avoiding the
         * need to create one manually via {@link FailureDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FailureDescription.Builder#build()} is called immediately and its
         * result is passed to {@link #failureDescription(FailureDescription)}.
         * 
         * @param failureDescription
         *        a consumer that will call methods on {@link FailureDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failureDescription(FailureDescription)
         */
        default Builder failureDescription(Consumer<FailureDescription.Builder> failureDescription) {
            return failureDescription(FailureDescription.builder().applyMutation(failureDescription).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String table;

        private Instant requestTimestamp;

        private String requestedBy;

        private String status;

        private FailureDescription failureDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DatabaseSnapshotInfo model) {
            id(model.id);
            table(model.table);
            requestTimestamp(model.requestTimestamp);
            requestedBy(model.requestedBy);
            status(model.status);
            failureDescription(model.failureDescription);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getTable() {
            return table;
        }

        public final void setTable(String table) {
            this.table = table;
        }

        @Override
        public final Builder table(String table) {
            this.table = table;
            return this;
        }

        public final Instant getRequestTimestamp() {
            return requestTimestamp;
        }

        public final void setRequestTimestamp(Instant requestTimestamp) {
            this.requestTimestamp = requestTimestamp;
        }

        @Override
        public final Builder requestTimestamp(Instant requestTimestamp) {
            this.requestTimestamp = requestTimestamp;
            return this;
        }

        public final String getRequestedBy() {
            return requestedBy;
        }

        public final void setRequestedBy(String requestedBy) {
            this.requestedBy = requestedBy;
        }

        @Override
        public final Builder requestedBy(String requestedBy) {
            this.requestedBy = requestedBy;
            return this;
        }

        @Override
        public final Builder requestedBy(SnapshotRequestedBy requestedBy) {
            this.requestedBy(requestedBy == null ? null : requestedBy.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SnapshotStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final FailureDescription.Builder getFailureDescription() {
            return failureDescription != null ? failureDescription.toBuilder() : null;
        }

        public final void setFailureDescription(FailureDescription.BuilderImpl failureDescription) {
            this.failureDescription = failureDescription != null ? failureDescription.build() : null;
        }

        @Override
        public final Builder failureDescription(FailureDescription failureDescription) {
            this.failureDescription = failureDescription;
            return this;
        }

        @Override
        public DatabaseSnapshotInfo build() {
            return new DatabaseSnapshotInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
