/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DatabaseType {
    MY_SQL("MySQL"),
    POSTGRE_SQL("PostgreSQL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DatabaseType> VALUE_MAP;
    private final String value;

    private DatabaseType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DatabaseType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DatabaseType> knownValues() {
        EnumSet<DatabaseType> knownValues = EnumSet.allOf(DatabaseType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DatabaseType.class, DatabaseType::toString);
    }
}

