/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.firehose.model.AmazonOpenSearchServerlessBufferingHints;
import software.amazon.awssdk.services.firehose.model.AmazonOpenSearchServerlessRetryOptions;
import software.amazon.awssdk.services.firehose.model.CloudWatchLoggingOptions;
import software.amazon.awssdk.services.firehose.model.ProcessingConfiguration;
import software.amazon.awssdk.services.firehose.model.S3DestinationUpdate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AmazonOpenSearchServerlessDestinationUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AmazonOpenSearchServerlessDestinationUpdate> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleARN").getter(AmazonOpenSearchServerlessDestinationUpdate.getter(AmazonOpenSearchServerlessDestinationUpdate::roleARN)).setter(AmazonOpenSearchServerlessDestinationUpdate.setter(Builder::roleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()}).build();
    private static final SdkField<String> COLLECTION_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CollectionEndpoint").getter(AmazonOpenSearchServerlessDestinationUpdate.getter(AmazonOpenSearchServerlessDestinationUpdate::collectionEndpoint)).setter(AmazonOpenSearchServerlessDestinationUpdate.setter(Builder::collectionEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionEndpoint").build()}).build();
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexName").getter(AmazonOpenSearchServerlessDestinationUpdate.getter(AmazonOpenSearchServerlessDestinationUpdate::indexName)).setter(AmazonOpenSearchServerlessDestinationUpdate.setter(Builder::indexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()}).build();
    private static final SdkField<AmazonOpenSearchServerlessBufferingHints> BUFFERING_HINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BufferingHints").getter(AmazonOpenSearchServerlessDestinationUpdate.getter(AmazonOpenSearchServerlessDestinationUpdate::bufferingHints)).setter(AmazonOpenSearchServerlessDestinationUpdate.setter(Builder::bufferingHints)).constructor(AmazonOpenSearchServerlessBufferingHints::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BufferingHints").build()}).build();
    private static final SdkField<AmazonOpenSearchServerlessRetryOptions> RETRY_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RetryOptions").getter(AmazonOpenSearchServerlessDestinationUpdate.getter(AmazonOpenSearchServerlessDestinationUpdate::retryOptions)).setter(AmazonOpenSearchServerlessDestinationUpdate.setter(Builder::retryOptions)).constructor(AmazonOpenSearchServerlessRetryOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryOptions").build()}).build();
    private static final SdkField<S3DestinationUpdate> S3_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3Update").getter(AmazonOpenSearchServerlessDestinationUpdate.getter(AmazonOpenSearchServerlessDestinationUpdate::s3Update)).setter(AmazonOpenSearchServerlessDestinationUpdate.setter(Builder::s3Update)).constructor(S3DestinationUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Update").build()}).build();
    private static final SdkField<ProcessingConfiguration> PROCESSING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProcessingConfiguration").getter(AmazonOpenSearchServerlessDestinationUpdate.getter(AmazonOpenSearchServerlessDestinationUpdate::processingConfiguration)).setter(AmazonOpenSearchServerlessDestinationUpdate.setter(Builder::processingConfiguration)).constructor(ProcessingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingConfiguration").build()}).build();
    private static final SdkField<CloudWatchLoggingOptions> CLOUD_WATCH_LOGGING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudWatchLoggingOptions").getter(AmazonOpenSearchServerlessDestinationUpdate.getter(AmazonOpenSearchServerlessDestinationUpdate::cloudWatchLoggingOptions)).setter(AmazonOpenSearchServerlessDestinationUpdate.setter(Builder::cloudWatchLoggingOptions)).constructor(CloudWatchLoggingOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, COLLECTION_ENDPOINT_FIELD, INDEX_NAME_FIELD, BUFFERING_HINTS_FIELD, RETRY_OPTIONS_FIELD, S3_UPDATE_FIELD, PROCESSING_CONFIGURATION_FIELD, CLOUD_WATCH_LOGGING_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("RoleARN", ROLE_ARN_FIELD);
            this.put("CollectionEndpoint", COLLECTION_ENDPOINT_FIELD);
            this.put("IndexName", INDEX_NAME_FIELD);
            this.put("BufferingHints", BUFFERING_HINTS_FIELD);
            this.put("RetryOptions", RETRY_OPTIONS_FIELD);
            this.put("S3Update", S3_UPDATE_FIELD);
            this.put("ProcessingConfiguration", PROCESSING_CONFIGURATION_FIELD);
            this.put("CloudWatchLoggingOptions", CLOUD_WATCH_LOGGING_OPTIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String roleARN;
    private final String collectionEndpoint;
    private final String indexName;
    private final AmazonOpenSearchServerlessBufferingHints bufferingHints;
    private final AmazonOpenSearchServerlessRetryOptions retryOptions;
    private final S3DestinationUpdate s3Update;
    private final ProcessingConfiguration processingConfiguration;
    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;

    private AmazonOpenSearchServerlessDestinationUpdate(BuilderImpl builder) {
        this.roleARN = builder.roleARN;
        this.collectionEndpoint = builder.collectionEndpoint;
        this.indexName = builder.indexName;
        this.bufferingHints = builder.bufferingHints;
        this.retryOptions = builder.retryOptions;
        this.s3Update = builder.s3Update;
        this.processingConfiguration = builder.processingConfiguration;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
    }

    public final String roleARN() {
        return this.roleARN;
    }

    public final String collectionEndpoint() {
        return this.collectionEndpoint;
    }

    public final String indexName() {
        return this.indexName;
    }

    public final AmazonOpenSearchServerlessBufferingHints bufferingHints() {
        return this.bufferingHints;
    }

    public final AmazonOpenSearchServerlessRetryOptions retryOptions() {
        return this.retryOptions;
    }

    public final S3DestinationUpdate s3Update() {
        return this.s3Update;
    }

    public final ProcessingConfiguration processingConfiguration() {
        return this.processingConfiguration;
    }

    public final CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return this.cloudWatchLoggingOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.bufferingHints());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Update());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLoggingOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AmazonOpenSearchServerlessDestinationUpdate)) {
            return false;
        }
        AmazonOpenSearchServerlessDestinationUpdate other = (AmazonOpenSearchServerlessDestinationUpdate)obj;
        return Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.collectionEndpoint(), other.collectionEndpoint()) && Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.bufferingHints(), other.bufferingHints()) && Objects.equals(this.retryOptions(), other.retryOptions()) && Objects.equals(this.s3Update(), other.s3Update()) && Objects.equals(this.processingConfiguration(), other.processingConfiguration()) && Objects.equals(this.cloudWatchLoggingOptions(), other.cloudWatchLoggingOptions());
    }

    public final String toString() {
        return ToString.builder((String)"AmazonOpenSearchServerlessDestinationUpdate").add("RoleARN", (Object)this.roleARN()).add("CollectionEndpoint", (Object)this.collectionEndpoint()).add("IndexName", (Object)this.indexName()).add("BufferingHints", (Object)this.bufferingHints()).add("RetryOptions", (Object)this.retryOptions()).add("S3Update", (Object)this.s3Update()).add("ProcessingConfiguration", (Object)this.processingConfiguration()).add("CloudWatchLoggingOptions", (Object)this.cloudWatchLoggingOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
            case "CollectionEndpoint": {
                return Optional.ofNullable(clazz.cast(this.collectionEndpoint()));
            }
            case "IndexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "BufferingHints": {
                return Optional.ofNullable(clazz.cast(this.bufferingHints()));
            }
            case "RetryOptions": {
                return Optional.ofNullable(clazz.cast(this.retryOptions()));
            }
            case "S3Update": {
                return Optional.ofNullable(clazz.cast(this.s3Update()));
            }
            case "ProcessingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.processingConfiguration()));
            }
            case "CloudWatchLoggingOptions": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLoggingOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AmazonOpenSearchServerlessDestinationUpdate, T> g) {
        return obj -> g.apply((AmazonOpenSearchServerlessDestinationUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleARN;
        private String collectionEndpoint;
        private String indexName;
        private AmazonOpenSearchServerlessBufferingHints bufferingHints;
        private AmazonOpenSearchServerlessRetryOptions retryOptions;
        private S3DestinationUpdate s3Update;
        private ProcessingConfiguration processingConfiguration;
        private CloudWatchLoggingOptions cloudWatchLoggingOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(AmazonOpenSearchServerlessDestinationUpdate model) {
            this.roleARN(model.roleARN);
            this.collectionEndpoint(model.collectionEndpoint);
            this.indexName(model.indexName);
            this.bufferingHints(model.bufferingHints);
            this.retryOptions(model.retryOptions);
            this.s3Update(model.s3Update);
            this.processingConfiguration(model.processingConfiguration);
            this.cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final String getCollectionEndpoint() {
            return this.collectionEndpoint;
        }

        public final void setCollectionEndpoint(String collectionEndpoint) {
            this.collectionEndpoint = collectionEndpoint;
        }

        @Override
        public final Builder collectionEndpoint(String collectionEndpoint) {
            this.collectionEndpoint = collectionEndpoint;
            return this;
        }

        public final String getIndexName() {
            return this.indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final AmazonOpenSearchServerlessBufferingHints.Builder getBufferingHints() {
            return this.bufferingHints != null ? this.bufferingHints.toBuilder() : null;
        }

        public final void setBufferingHints(AmazonOpenSearchServerlessBufferingHints.BuilderImpl bufferingHints) {
            this.bufferingHints = bufferingHints != null ? bufferingHints.build() : null;
        }

        @Override
        public final Builder bufferingHints(AmazonOpenSearchServerlessBufferingHints bufferingHints) {
            this.bufferingHints = bufferingHints;
            return this;
        }

        public final AmazonOpenSearchServerlessRetryOptions.Builder getRetryOptions() {
            return this.retryOptions != null ? this.retryOptions.toBuilder() : null;
        }

        public final void setRetryOptions(AmazonOpenSearchServerlessRetryOptions.BuilderImpl retryOptions) {
            this.retryOptions = retryOptions != null ? retryOptions.build() : null;
        }

        @Override
        public final Builder retryOptions(AmazonOpenSearchServerlessRetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public final S3DestinationUpdate.Builder getS3Update() {
            return this.s3Update != null ? this.s3Update.toBuilder() : null;
        }

        public final void setS3Update(S3DestinationUpdate.BuilderImpl s3Update) {
            this.s3Update = s3Update != null ? s3Update.build() : null;
        }

        @Override
        public final Builder s3Update(S3DestinationUpdate s3Update) {
            this.s3Update = s3Update;
            return this;
        }

        public final ProcessingConfiguration.Builder getProcessingConfiguration() {
            return this.processingConfiguration != null ? this.processingConfiguration.toBuilder() : null;
        }

        public final void setProcessingConfiguration(ProcessingConfiguration.BuilderImpl processingConfiguration) {
            this.processingConfiguration = processingConfiguration != null ? processingConfiguration.build() : null;
        }

        @Override
        public final Builder processingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
            return this;
        }

        public final CloudWatchLoggingOptions.Builder getCloudWatchLoggingOptions() {
            return this.cloudWatchLoggingOptions != null ? this.cloudWatchLoggingOptions.toBuilder() : null;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions.BuilderImpl cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.build() : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public AmazonOpenSearchServerlessDestinationUpdate build() {
            return new AmazonOpenSearchServerlessDestinationUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AmazonOpenSearchServerlessDestinationUpdate> {
        public Builder roleARN(String var1);

        public Builder collectionEndpoint(String var1);

        public Builder indexName(String var1);

        public Builder bufferingHints(AmazonOpenSearchServerlessBufferingHints var1);

        default public Builder bufferingHints(Consumer<AmazonOpenSearchServerlessBufferingHints.Builder> bufferingHints) {
            return this.bufferingHints((AmazonOpenSearchServerlessBufferingHints)((AmazonOpenSearchServerlessBufferingHints.Builder)AmazonOpenSearchServerlessBufferingHints.builder().applyMutation(bufferingHints)).build());
        }

        public Builder retryOptions(AmazonOpenSearchServerlessRetryOptions var1);

        default public Builder retryOptions(Consumer<AmazonOpenSearchServerlessRetryOptions.Builder> retryOptions) {
            return this.retryOptions((AmazonOpenSearchServerlessRetryOptions)((AmazonOpenSearchServerlessRetryOptions.Builder)AmazonOpenSearchServerlessRetryOptions.builder().applyMutation(retryOptions)).build());
        }

        public Builder s3Update(S3DestinationUpdate var1);

        default public Builder s3Update(Consumer<S3DestinationUpdate.Builder> s3Update) {
            return this.s3Update((S3DestinationUpdate)((S3DestinationUpdate.Builder)S3DestinationUpdate.builder().applyMutation(s3Update)).build());
        }

        public Builder processingConfiguration(ProcessingConfiguration var1);

        default public Builder processingConfiguration(Consumer<ProcessingConfiguration.Builder> processingConfiguration) {
            return this.processingConfiguration((ProcessingConfiguration)((ProcessingConfiguration.Builder)ProcessingConfiguration.builder().applyMutation(processingConfiguration)).build());
        }

        public Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions var1);

        default public Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOptions.Builder> cloudWatchLoggingOptions) {
            return this.cloudWatchLoggingOptions((CloudWatchLoggingOptions)((CloudWatchLoggingOptions.Builder)CloudWatchLoggingOptions.builder().applyMutation(cloudWatchLoggingOptions)).build());
        }
    }
}

