/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.firehose.model.FirehoseRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTagsForDeliveryStreamRequest
extends FirehoseRequest
implements ToCopyableBuilder<Builder, ListTagsForDeliveryStreamRequest> {
    private static final SdkField<String> DELIVERY_STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeliveryStreamName").getter(ListTagsForDeliveryStreamRequest.getter(ListTagsForDeliveryStreamRequest::deliveryStreamName)).setter(ListTagsForDeliveryStreamRequest.setter(Builder::deliveryStreamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryStreamName").build()}).build();
    private static final SdkField<String> EXCLUSIVE_START_TAG_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExclusiveStartTagKey").getter(ListTagsForDeliveryStreamRequest.getter(ListTagsForDeliveryStreamRequest::exclusiveStartTagKey)).setter(ListTagsForDeliveryStreamRequest.setter(Builder::exclusiveStartTagKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusiveStartTagKey").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Limit").getter(ListTagsForDeliveryStreamRequest.getter(ListTagsForDeliveryStreamRequest::limit)).setter(ListTagsForDeliveryStreamRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_STREAM_NAME_FIELD, EXCLUSIVE_START_TAG_KEY_FIELD, LIMIT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DeliveryStreamName", DELIVERY_STREAM_NAME_FIELD);
            this.put("ExclusiveStartTagKey", EXCLUSIVE_START_TAG_KEY_FIELD);
            this.put("Limit", LIMIT_FIELD);
        }
    });
    private final String deliveryStreamName;
    private final String exclusiveStartTagKey;
    private final Integer limit;

    private ListTagsForDeliveryStreamRequest(BuilderImpl builder) {
        super(builder);
        this.deliveryStreamName = builder.deliveryStreamName;
        this.exclusiveStartTagKey = builder.exclusiveStartTagKey;
        this.limit = builder.limit;
    }

    public final String deliveryStreamName() {
        return this.deliveryStreamName;
    }

    public final String exclusiveStartTagKey() {
        return this.exclusiveStartTagKey;
    }

    public final Integer limit() {
        return this.limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.exclusiveStartTagKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForDeliveryStreamRequest)) {
            return false;
        }
        ListTagsForDeliveryStreamRequest other = (ListTagsForDeliveryStreamRequest)((Object)obj);
        return Objects.equals(this.deliveryStreamName(), other.deliveryStreamName()) && Objects.equals(this.exclusiveStartTagKey(), other.exclusiveStartTagKey()) && Objects.equals(this.limit(), other.limit());
    }

    public final String toString() {
        return ToString.builder((String)"ListTagsForDeliveryStreamRequest").add("DeliveryStreamName", (Object)this.deliveryStreamName()).add("ExclusiveStartTagKey", (Object)this.exclusiveStartTagKey()).add("Limit", (Object)this.limit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeliveryStreamName": {
                return Optional.ofNullable(clazz.cast(this.deliveryStreamName()));
            }
            case "ExclusiveStartTagKey": {
                return Optional.ofNullable(clazz.cast(this.exclusiveStartTagKey()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListTagsForDeliveryStreamRequest, T> g) {
        return obj -> g.apply((ListTagsForDeliveryStreamRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FirehoseRequest.BuilderImpl
    implements Builder {
        private String deliveryStreamName;
        private String exclusiveStartTagKey;
        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsForDeliveryStreamRequest model) {
            super(model);
            this.deliveryStreamName(model.deliveryStreamName);
            this.exclusiveStartTagKey(model.exclusiveStartTagKey);
            this.limit(model.limit);
        }

        public final String getDeliveryStreamName() {
            return this.deliveryStreamName;
        }

        public final void setDeliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
        }

        @Override
        public final Builder deliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        public final String getExclusiveStartTagKey() {
            return this.exclusiveStartTagKey;
        }

        public final void setExclusiveStartTagKey(String exclusiveStartTagKey) {
            this.exclusiveStartTagKey = exclusiveStartTagKey;
        }

        @Override
        public final Builder exclusiveStartTagKey(String exclusiveStartTagKey) {
            this.exclusiveStartTagKey = exclusiveStartTagKey;
            return this;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTagsForDeliveryStreamRequest build() {
            return new ListTagsForDeliveryStreamRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FirehoseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTagsForDeliveryStreamRequest> {
        public Builder deliveryStreamName(String var1);

        public Builder exclusiveStartTagKey(String var1);

        public Builder limit(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

