/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.firehose.model.Connectivity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthenticationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuthenticationConfiguration> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleARN").getter(AuthenticationConfiguration.getter(AuthenticationConfiguration::roleARN)).setter(AuthenticationConfiguration.setter(Builder::roleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()}).build();
    private static final SdkField<String> CONNECTIVITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Connectivity").getter(AuthenticationConfiguration.getter(AuthenticationConfiguration::connectivityAsString)).setter(AuthenticationConfiguration.setter(Builder::connectivity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Connectivity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, CONNECTIVITY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String roleARN;
    private final String connectivity;

    private AuthenticationConfiguration(BuilderImpl builder) {
        this.roleARN = builder.roleARN;
        this.connectivity = builder.connectivity;
    }

    public final String roleARN() {
        return this.roleARN;
    }

    public final Connectivity connectivity() {
        return Connectivity.fromValue(this.connectivity);
    }

    public final String connectivityAsString() {
        return this.connectivity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectivityAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationConfiguration)) {
            return false;
        }
        AuthenticationConfiguration other = (AuthenticationConfiguration)obj;
        return Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.connectivityAsString(), other.connectivityAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AuthenticationConfiguration").add("RoleARN", (Object)this.roleARN()).add("Connectivity", (Object)this.connectivityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
            case "Connectivity": {
                return Optional.ofNullable(clazz.cast(this.connectivityAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuthenticationConfiguration, T> g) {
        return obj -> g.apply((AuthenticationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleARN;
        private String connectivity;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthenticationConfiguration model) {
            this.roleARN(model.roleARN);
            this.connectivity(model.connectivity);
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final String getConnectivity() {
            return this.connectivity;
        }

        public final void setConnectivity(String connectivity) {
            this.connectivity = connectivity;
        }

        @Override
        public final Builder connectivity(String connectivity) {
            this.connectivity = connectivity;
            return this;
        }

        @Override
        public final Builder connectivity(Connectivity connectivity) {
            this.connectivity(connectivity == null ? null : connectivity.toString());
            return this;
        }

        public AuthenticationConfiguration build() {
            return new AuthenticationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuthenticationConfiguration> {
        public Builder roleARN(String var1);

        public Builder connectivity(String var1);

        public Builder connectivity(Connectivity var1);
    }
}

