/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.firehose.model.FirehoseResponse;
import software.amazon.awssdk.services.firehose.model.TagrisStatus;
import software.amazon.awssdk.services.firehose.model.TagrisSweepListResultCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VerifyResourcesExistForTagrisResponse
extends FirehoseResponse
implements ToCopyableBuilder<Builder, VerifyResourcesExistForTagrisResponse> {
    private static final SdkField<Map<String, String>> TAGRIS_SWEEP_LIST_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("TagrisSweepListResult").getter(VerifyResourcesExistForTagrisResponse.getter(VerifyResourcesExistForTagrisResponse::tagrisSweepListResultAsStrings)).setter(VerifyResourcesExistForTagrisResponse.setter(Builder::tagrisSweepListResultWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagrisSweepListResult").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAGRIS_SWEEP_LIST_RESULT_FIELD));
    private final Map<String, String> tagrisSweepListResult;

    private VerifyResourcesExistForTagrisResponse(BuilderImpl builder) {
        super(builder);
        this.tagrisSweepListResult = builder.tagrisSweepListResult;
    }

    public final Map<String, TagrisStatus> tagrisSweepListResult() {
        return TagrisSweepListResultCopier.copyStringToEnum(this.tagrisSweepListResult);
    }

    public final boolean hasTagrisSweepListResult() {
        return this.tagrisSweepListResult != null && !(this.tagrisSweepListResult instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tagrisSweepListResultAsStrings() {
        return this.tagrisSweepListResult;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagrisSweepListResult() ? this.tagrisSweepListResultAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifyResourcesExistForTagrisResponse)) {
            return false;
        }
        VerifyResourcesExistForTagrisResponse other = (VerifyResourcesExistForTagrisResponse)((Object)obj);
        return this.hasTagrisSweepListResult() == other.hasTagrisSweepListResult() && Objects.equals(this.tagrisSweepListResultAsStrings(), other.tagrisSweepListResultAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"VerifyResourcesExistForTagrisResponse").add("TagrisSweepListResult", this.hasTagrisSweepListResult() ? this.tagrisSweepListResultAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TagrisSweepListResult": {
                return Optional.ofNullable(clazz.cast(this.tagrisSweepListResultAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VerifyResourcesExistForTagrisResponse, T> g) {
        return obj -> g.apply((VerifyResourcesExistForTagrisResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FirehoseResponse.BuilderImpl
    implements Builder {
        private Map<String, String> tagrisSweepListResult = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VerifyResourcesExistForTagrisResponse model) {
            super(model);
            this.tagrisSweepListResultWithStrings(model.tagrisSweepListResult);
        }

        public final Map<String, String> getTagrisSweepListResult() {
            if (this.tagrisSweepListResult instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tagrisSweepListResult;
        }

        public final void setTagrisSweepListResult(Map<String, String> tagrisSweepListResult) {
            this.tagrisSweepListResult = TagrisSweepListResultCopier.copy(tagrisSweepListResult);
        }

        @Override
        public final Builder tagrisSweepListResultWithStrings(Map<String, String> tagrisSweepListResult) {
            this.tagrisSweepListResult = TagrisSweepListResultCopier.copy(tagrisSweepListResult);
            return this;
        }

        @Override
        public final Builder tagrisSweepListResult(Map<String, TagrisStatus> tagrisSweepListResult) {
            this.tagrisSweepListResult = TagrisSweepListResultCopier.copyEnumToString(tagrisSweepListResult);
            return this;
        }

        @Override
        public VerifyResourcesExistForTagrisResponse build() {
            return new VerifyResourcesExistForTagrisResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FirehoseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, VerifyResourcesExistForTagrisResponse> {
        public Builder tagrisSweepListResultWithStrings(Map<String, String> var1);

        public Builder tagrisSweepListResult(Map<String, TagrisStatus> var1);
    }
}

