/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.firehose.model.FirehoseRequest;
import software.amazon.awssdk.services.firehose.model.TagrisSweepListCopier;
import software.amazon.awssdk.services.firehose.model.TagrisSweepListItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VerifyResourcesExistForTagrisRequest
extends FirehoseRequest
implements ToCopyableBuilder<Builder, VerifyResourcesExistForTagrisRequest> {
    private static final SdkField<List<TagrisSweepListItem>> TAGRIS_SWEEP_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagrisSweepList").getter(VerifyResourcesExistForTagrisRequest.getter(VerifyResourcesExistForTagrisRequest::tagrisSweepList)).setter(VerifyResourcesExistForTagrisRequest.setter(Builder::tagrisSweepList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagrisSweepList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagrisSweepListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAGRIS_SWEEP_LIST_FIELD));
    private final List<TagrisSweepListItem> tagrisSweepList;

    private VerifyResourcesExistForTagrisRequest(BuilderImpl builder) {
        super(builder);
        this.tagrisSweepList = builder.tagrisSweepList;
    }

    public final boolean hasTagrisSweepList() {
        return this.tagrisSweepList != null && !(this.tagrisSweepList instanceof SdkAutoConstructList);
    }

    public final List<TagrisSweepListItem> tagrisSweepList() {
        return this.tagrisSweepList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagrisSweepList() ? this.tagrisSweepList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifyResourcesExistForTagrisRequest)) {
            return false;
        }
        VerifyResourcesExistForTagrisRequest other = (VerifyResourcesExistForTagrisRequest)((Object)obj);
        return this.hasTagrisSweepList() == other.hasTagrisSweepList() && Objects.equals(this.tagrisSweepList(), other.tagrisSweepList());
    }

    public final String toString() {
        return ToString.builder((String)"VerifyResourcesExistForTagrisRequest").add("TagrisSweepList", this.hasTagrisSweepList() ? this.tagrisSweepList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TagrisSweepList": {
                return Optional.ofNullable(clazz.cast(this.tagrisSweepList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VerifyResourcesExistForTagrisRequest, T> g) {
        return obj -> g.apply((VerifyResourcesExistForTagrisRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FirehoseRequest.BuilderImpl
    implements Builder {
        private List<TagrisSweepListItem> tagrisSweepList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VerifyResourcesExistForTagrisRequest model) {
            super(model);
            this.tagrisSweepList(model.tagrisSweepList);
        }

        public final List<TagrisSweepListItem.Builder> getTagrisSweepList() {
            List<TagrisSweepListItem.Builder> result = TagrisSweepListCopier.copyToBuilder(this.tagrisSweepList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagrisSweepList(Collection<TagrisSweepListItem.BuilderImpl> tagrisSweepList) {
            this.tagrisSweepList = TagrisSweepListCopier.copyFromBuilder(tagrisSweepList);
        }

        @Override
        public final Builder tagrisSweepList(Collection<TagrisSweepListItem> tagrisSweepList) {
            this.tagrisSweepList = TagrisSweepListCopier.copy(tagrisSweepList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagrisSweepList(TagrisSweepListItem ... tagrisSweepList) {
            this.tagrisSweepList(Arrays.asList(tagrisSweepList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagrisSweepList(Consumer<TagrisSweepListItem.Builder> ... tagrisSweepList) {
            this.tagrisSweepList(Stream.of(tagrisSweepList).map(c -> (TagrisSweepListItem)((TagrisSweepListItem.Builder)TagrisSweepListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public VerifyResourcesExistForTagrisRequest build() {
            return new VerifyResourcesExistForTagrisRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FirehoseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, VerifyResourcesExistForTagrisRequest> {
        public Builder tagrisSweepList(Collection<TagrisSweepListItem> var1);

        public Builder tagrisSweepList(TagrisSweepListItem ... var1);

        public Builder tagrisSweepList(Consumer<TagrisSweepListItem.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

