/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.firehose.model.FirehoseResponse;
import software.amazon.awssdk.services.firehose.model.SessionCredentials;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetKinesisStreamResponse
extends FirehoseResponse
implements ToCopyableBuilder<Builder, GetKinesisStreamResponse> {
    private static final SdkField<String> KINESIS_STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KinesisStreamARN").getter(GetKinesisStreamResponse.getter(GetKinesisStreamResponse::kinesisStreamARN)).setter(GetKinesisStreamResponse.setter(Builder::kinesisStreamARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisStreamARN").build()}).build();
    private static final SdkField<SessionCredentials> CREDENTIALS_FOR_READING_KINESIS_STREAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CredentialsForReadingKinesisStream").getter(GetKinesisStreamResponse.getter(GetKinesisStreamResponse::credentialsForReadingKinesisStream)).setter(GetKinesisStreamResponse.setter(Builder::credentialsForReadingKinesisStream)).constructor(SessionCredentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CredentialsForReadingKinesisStream").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KINESIS_STREAM_ARN_FIELD, CREDENTIALS_FOR_READING_KINESIS_STREAM_FIELD));
    private final String kinesisStreamARN;
    private final SessionCredentials credentialsForReadingKinesisStream;

    private GetKinesisStreamResponse(BuilderImpl builder) {
        super(builder);
        this.kinesisStreamARN = builder.kinesisStreamARN;
        this.credentialsForReadingKinesisStream = builder.credentialsForReadingKinesisStream;
    }

    public final String kinesisStreamARN() {
        return this.kinesisStreamARN;
    }

    public final SessionCredentials credentialsForReadingKinesisStream() {
        return this.credentialsForReadingKinesisStream;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisStreamARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentialsForReadingKinesisStream());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetKinesisStreamResponse)) {
            return false;
        }
        GetKinesisStreamResponse other = (GetKinesisStreamResponse)((Object)obj);
        return Objects.equals(this.kinesisStreamARN(), other.kinesisStreamARN()) && Objects.equals(this.credentialsForReadingKinesisStream(), other.credentialsForReadingKinesisStream());
    }

    public final String toString() {
        return ToString.builder((String)"GetKinesisStreamResponse").add("KinesisStreamARN", (Object)this.kinesisStreamARN()).add("CredentialsForReadingKinesisStream", (Object)(this.credentialsForReadingKinesisStream() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KinesisStreamARN": {
                return Optional.ofNullable(clazz.cast(this.kinesisStreamARN()));
            }
            case "CredentialsForReadingKinesisStream": {
                return Optional.ofNullable(clazz.cast(this.credentialsForReadingKinesisStream()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetKinesisStreamResponse, T> g) {
        return obj -> g.apply((GetKinesisStreamResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FirehoseResponse.BuilderImpl
    implements Builder {
        private String kinesisStreamARN;
        private SessionCredentials credentialsForReadingKinesisStream;

        private BuilderImpl() {
        }

        private BuilderImpl(GetKinesisStreamResponse model) {
            super(model);
            this.kinesisStreamARN(model.kinesisStreamARN);
            this.credentialsForReadingKinesisStream(model.credentialsForReadingKinesisStream);
        }

        public final String getKinesisStreamARN() {
            return this.kinesisStreamARN;
        }

        public final void setKinesisStreamARN(String kinesisStreamARN) {
            this.kinesisStreamARN = kinesisStreamARN;
        }

        @Override
        public final Builder kinesisStreamARN(String kinesisStreamARN) {
            this.kinesisStreamARN = kinesisStreamARN;
            return this;
        }

        public final SessionCredentials.Builder getCredentialsForReadingKinesisStream() {
            return this.credentialsForReadingKinesisStream != null ? this.credentialsForReadingKinesisStream.toBuilder() : null;
        }

        public final void setCredentialsForReadingKinesisStream(SessionCredentials.BuilderImpl credentialsForReadingKinesisStream) {
            this.credentialsForReadingKinesisStream = credentialsForReadingKinesisStream != null ? credentialsForReadingKinesisStream.build() : null;
        }

        @Override
        public final Builder credentialsForReadingKinesisStream(SessionCredentials credentialsForReadingKinesisStream) {
            this.credentialsForReadingKinesisStream = credentialsForReadingKinesisStream;
            return this;
        }

        @Override
        public GetKinesisStreamResponse build() {
            return new GetKinesisStreamResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FirehoseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetKinesisStreamResponse> {
        public Builder kinesisStreamARN(String var1);

        public Builder credentialsForReadingKinesisStream(SessionCredentials var1);

        default public Builder credentialsForReadingKinesisStream(Consumer<SessionCredentials.Builder> credentialsForReadingKinesisStream) {
            return this.credentialsForReadingKinesisStream((SessionCredentials)((SessionCredentials.Builder)SessionCredentials.builder().applyMutation(credentialsForReadingKinesisStream)).build());
        }
    }
}

