/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.firehose.DefaultFirehoseAsyncClient;
import software.amazon.awssdk.services.firehose.DefaultFirehoseBaseClientBuilder;
import software.amazon.awssdk.services.firehose.FirehoseAsyncClient;
import software.amazon.awssdk.services.firehose.FirehoseAsyncClientBuilder;
import software.amazon.awssdk.services.firehose.FirehoseServiceClientConfiguration;
import software.amazon.awssdk.services.firehose.endpoints.FirehoseEndpointProvider;

@SdkInternalApi
final class DefaultFirehoseAsyncClientBuilder
extends DefaultFirehoseBaseClientBuilder<FirehoseAsyncClientBuilder, FirehoseAsyncClient>
implements FirehoseAsyncClientBuilder {
    DefaultFirehoseAsyncClientBuilder() {
    }

    @Override
    public DefaultFirehoseAsyncClientBuilder endpointProvider(FirehoseEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final FirehoseAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultFirehoseAsyncClientBuilder.validateClientOptions(clientConfiguration);
        FirehoseServiceClientConfiguration serviceClientConfiguration = FirehoseServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultFirehoseAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

