/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.firehose.model.KeyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeliveryStreamEncryptionConfigurationInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeliveryStreamEncryptionConfigurationInput> {
    private static final SdkField<String> KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyARN").getter(DeliveryStreamEncryptionConfigurationInput.getter(DeliveryStreamEncryptionConfigurationInput::keyARN)).setter(DeliveryStreamEncryptionConfigurationInput.setter(Builder::keyARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyARN").build()}).build();
    private static final SdkField<String> KEY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyType").getter(DeliveryStreamEncryptionConfigurationInput.getter(DeliveryStreamEncryptionConfigurationInput::keyTypeAsString)).setter(DeliveryStreamEncryptionConfigurationInput.setter(Builder::keyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ARN_FIELD, KEY_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String keyARN;
    private final String keyType;

    private DeliveryStreamEncryptionConfigurationInput(BuilderImpl builder) {
        this.keyARN = builder.keyARN;
        this.keyType = builder.keyType;
    }

    public final String keyARN() {
        return this.keyARN;
    }

    public final KeyType keyType() {
        return KeyType.fromValue(this.keyType);
    }

    public final String keyTypeAsString() {
        return this.keyType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeliveryStreamEncryptionConfigurationInput)) {
            return false;
        }
        DeliveryStreamEncryptionConfigurationInput other = (DeliveryStreamEncryptionConfigurationInput)obj;
        return Objects.equals(this.keyARN(), other.keyARN()) && Objects.equals(this.keyTypeAsString(), other.keyTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DeliveryStreamEncryptionConfigurationInput").add("KeyARN", (Object)this.keyARN()).add("KeyType", (Object)this.keyTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyARN": {
                return Optional.ofNullable(clazz.cast(this.keyARN()));
            }
            case "KeyType": {
                return Optional.ofNullable(clazz.cast(this.keyTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeliveryStreamEncryptionConfigurationInput, T> g) {
        return obj -> g.apply((DeliveryStreamEncryptionConfigurationInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String keyARN;
        private String keyType;

        private BuilderImpl() {
        }

        private BuilderImpl(DeliveryStreamEncryptionConfigurationInput model) {
            this.keyARN(model.keyARN);
            this.keyType(model.keyType);
        }

        public final String getKeyARN() {
            return this.keyARN;
        }

        public final void setKeyARN(String keyARN) {
            this.keyARN = keyARN;
        }

        @Override
        @Transient
        public final Builder keyARN(String keyARN) {
            this.keyARN = keyARN;
            return this;
        }

        public final String getKeyType() {
            return this.keyType;
        }

        public final void setKeyType(String keyType) {
            this.keyType = keyType;
        }

        @Override
        @Transient
        public final Builder keyType(String keyType) {
            this.keyType = keyType;
            return this;
        }

        @Override
        @Transient
        public final Builder keyType(KeyType keyType) {
            this.keyType(keyType == null ? null : keyType.toString());
            return this;
        }

        public DeliveryStreamEncryptionConfigurationInput build() {
            return new DeliveryStreamEncryptionConfigurationInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeliveryStreamEncryptionConfigurationInput> {
        public Builder keyARN(String var1);

        public Builder keyType(String var1);

        public Builder keyType(KeyType var1);
    }
}

