/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.firehose.model.AmazonopensearchserviceDestinationConfiguration;
import software.amazon.awssdk.services.firehose.model.DeliveryStreamEncryptionConfigurationInput;
import software.amazon.awssdk.services.firehose.model.DeliveryStreamType;
import software.amazon.awssdk.services.firehose.model.ElasticsearchDestinationConfiguration;
import software.amazon.awssdk.services.firehose.model.ExtendedS3DestinationConfiguration;
import software.amazon.awssdk.services.firehose.model.FirehoseRequest;
import software.amazon.awssdk.services.firehose.model.HttpEndpointDestinationConfiguration;
import software.amazon.awssdk.services.firehose.model.KinesisStreamSourceConfiguration;
import software.amazon.awssdk.services.firehose.model.RedshiftDestinationConfiguration;
import software.amazon.awssdk.services.firehose.model.S3DestinationConfiguration;
import software.amazon.awssdk.services.firehose.model.SplunkDestinationConfiguration;
import software.amazon.awssdk.services.firehose.model.Tag;
import software.amazon.awssdk.services.firehose.model.TagDeliveryStreamInputTagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDeliveryStreamRequest
extends FirehoseRequest
implements ToCopyableBuilder<Builder, CreateDeliveryStreamRequest> {
    private static final SdkField<String> DELIVERY_STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeliveryStreamName").getter(CreateDeliveryStreamRequest.getter(CreateDeliveryStreamRequest::deliveryStreamName)).setter(CreateDeliveryStreamRequest.setter(Builder::deliveryStreamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryStreamName").build()}).build();
    private static final SdkField<String> DELIVERY_STREAM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeliveryStreamType").getter(CreateDeliveryStreamRequest.getter(CreateDeliveryStreamRequest::deliveryStreamTypeAsString)).setter(CreateDeliveryStreamRequest.setter(Builder::deliveryStreamType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryStreamType").build()}).build();
    private static final SdkField<KinesisStreamSourceConfiguration> KINESIS_STREAM_SOURCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KinesisStreamSourceConfiguration").getter(CreateDeliveryStreamRequest.getter(CreateDeliveryStreamRequest::kinesisStreamSourceConfiguration)).setter(CreateDeliveryStreamRequest.setter(Builder::kinesisStreamSourceConfiguration)).constructor(KinesisStreamSourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisStreamSourceConfiguration").build()}).build();
    private static final SdkField<DeliveryStreamEncryptionConfigurationInput> DELIVERY_STREAM_ENCRYPTION_CONFIGURATION_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeliveryStreamEncryptionConfigurationInput").getter(CreateDeliveryStreamRequest.getter(CreateDeliveryStreamRequest::deliveryStreamEncryptionConfigurationInput)).setter(CreateDeliveryStreamRequest.setter(Builder::deliveryStreamEncryptionConfigurationInput)).constructor(DeliveryStreamEncryptionConfigurationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryStreamEncryptionConfigurationInput").build()}).build();
    private static final SdkField<S3DestinationConfiguration> S3_DESTINATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3DestinationConfiguration").getter(CreateDeliveryStreamRequest.getter(CreateDeliveryStreamRequest::s3DestinationConfiguration)).setter(CreateDeliveryStreamRequest.setter(Builder::s3DestinationConfiguration)).constructor(S3DestinationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DestinationConfiguration").build()}).build();
    private static final SdkField<ExtendedS3DestinationConfiguration> EXTENDED_S3_DESTINATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExtendedS3DestinationConfiguration").getter(CreateDeliveryStreamRequest.getter(CreateDeliveryStreamRequest::extendedS3DestinationConfiguration)).setter(CreateDeliveryStreamRequest.setter(Builder::extendedS3DestinationConfiguration)).constructor(ExtendedS3DestinationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtendedS3DestinationConfiguration").build()}).build();
    private static final SdkField<RedshiftDestinationConfiguration> REDSHIFT_DESTINATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RedshiftDestinationConfiguration").getter(CreateDeliveryStreamRequest.getter(CreateDeliveryStreamRequest::redshiftDestinationConfiguration)).setter(CreateDeliveryStreamRequest.setter(Builder::redshiftDestinationConfiguration)).constructor(RedshiftDestinationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftDestinationConfiguration").build()}).build();
    private static final SdkField<ElasticsearchDestinationConfiguration> ELASTICSEARCH_DESTINATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ElasticsearchDestinationConfiguration").getter(CreateDeliveryStreamRequest.getter(CreateDeliveryStreamRequest::elasticsearchDestinationConfiguration)).setter(CreateDeliveryStreamRequest.setter(Builder::elasticsearchDestinationConfiguration)).constructor(ElasticsearchDestinationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticsearchDestinationConfiguration").build()}).build();
    private static final SdkField<AmazonopensearchserviceDestinationConfiguration> AMAZONOPENSEARCHSERVICE_DESTINATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AmazonopensearchserviceDestinationConfiguration").getter(CreateDeliveryStreamRequest.getter(CreateDeliveryStreamRequest::amazonopensearchserviceDestinationConfiguration)).setter(CreateDeliveryStreamRequest.setter(Builder::amazonopensearchserviceDestinationConfiguration)).constructor(AmazonopensearchserviceDestinationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonopensearchserviceDestinationConfiguration").build()}).build();
    private static final SdkField<SplunkDestinationConfiguration> SPLUNK_DESTINATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SplunkDestinationConfiguration").getter(CreateDeliveryStreamRequest.getter(CreateDeliveryStreamRequest::splunkDestinationConfiguration)).setter(CreateDeliveryStreamRequest.setter(Builder::splunkDestinationConfiguration)).constructor(SplunkDestinationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SplunkDestinationConfiguration").build()}).build();
    private static final SdkField<HttpEndpointDestinationConfiguration> HTTP_ENDPOINT_DESTINATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HttpEndpointDestinationConfiguration").getter(CreateDeliveryStreamRequest.getter(CreateDeliveryStreamRequest::httpEndpointDestinationConfiguration)).setter(CreateDeliveryStreamRequest.setter(Builder::httpEndpointDestinationConfiguration)).constructor(HttpEndpointDestinationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpEndpointDestinationConfiguration").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateDeliveryStreamRequest.getter(CreateDeliveryStreamRequest::tags)).setter(CreateDeliveryStreamRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_STREAM_NAME_FIELD, DELIVERY_STREAM_TYPE_FIELD, KINESIS_STREAM_SOURCE_CONFIGURATION_FIELD, DELIVERY_STREAM_ENCRYPTION_CONFIGURATION_INPUT_FIELD, S3_DESTINATION_CONFIGURATION_FIELD, EXTENDED_S3_DESTINATION_CONFIGURATION_FIELD, REDSHIFT_DESTINATION_CONFIGURATION_FIELD, ELASTICSEARCH_DESTINATION_CONFIGURATION_FIELD, AMAZONOPENSEARCHSERVICE_DESTINATION_CONFIGURATION_FIELD, SPLUNK_DESTINATION_CONFIGURATION_FIELD, HTTP_ENDPOINT_DESTINATION_CONFIGURATION_FIELD, TAGS_FIELD));
    private final String deliveryStreamName;
    private final String deliveryStreamType;
    private final KinesisStreamSourceConfiguration kinesisStreamSourceConfiguration;
    private final DeliveryStreamEncryptionConfigurationInput deliveryStreamEncryptionConfigurationInput;
    private final S3DestinationConfiguration s3DestinationConfiguration;
    private final ExtendedS3DestinationConfiguration extendedS3DestinationConfiguration;
    private final RedshiftDestinationConfiguration redshiftDestinationConfiguration;
    private final ElasticsearchDestinationConfiguration elasticsearchDestinationConfiguration;
    private final AmazonopensearchserviceDestinationConfiguration amazonopensearchserviceDestinationConfiguration;
    private final SplunkDestinationConfiguration splunkDestinationConfiguration;
    private final HttpEndpointDestinationConfiguration httpEndpointDestinationConfiguration;
    private final List<Tag> tags;

    private CreateDeliveryStreamRequest(BuilderImpl builder) {
        super(builder);
        this.deliveryStreamName = builder.deliveryStreamName;
        this.deliveryStreamType = builder.deliveryStreamType;
        this.kinesisStreamSourceConfiguration = builder.kinesisStreamSourceConfiguration;
        this.deliveryStreamEncryptionConfigurationInput = builder.deliveryStreamEncryptionConfigurationInput;
        this.s3DestinationConfiguration = builder.s3DestinationConfiguration;
        this.extendedS3DestinationConfiguration = builder.extendedS3DestinationConfiguration;
        this.redshiftDestinationConfiguration = builder.redshiftDestinationConfiguration;
        this.elasticsearchDestinationConfiguration = builder.elasticsearchDestinationConfiguration;
        this.amazonopensearchserviceDestinationConfiguration = builder.amazonopensearchserviceDestinationConfiguration;
        this.splunkDestinationConfiguration = builder.splunkDestinationConfiguration;
        this.httpEndpointDestinationConfiguration = builder.httpEndpointDestinationConfiguration;
        this.tags = builder.tags;
    }

    public final String deliveryStreamName() {
        return this.deliveryStreamName;
    }

    public final DeliveryStreamType deliveryStreamType() {
        return DeliveryStreamType.fromValue(this.deliveryStreamType);
    }

    public final String deliveryStreamTypeAsString() {
        return this.deliveryStreamType;
    }

    public final KinesisStreamSourceConfiguration kinesisStreamSourceConfiguration() {
        return this.kinesisStreamSourceConfiguration;
    }

    public final DeliveryStreamEncryptionConfigurationInput deliveryStreamEncryptionConfigurationInput() {
        return this.deliveryStreamEncryptionConfigurationInput;
    }

    @Deprecated
    public final S3DestinationConfiguration s3DestinationConfiguration() {
        return this.s3DestinationConfiguration;
    }

    public final ExtendedS3DestinationConfiguration extendedS3DestinationConfiguration() {
        return this.extendedS3DestinationConfiguration;
    }

    public final RedshiftDestinationConfiguration redshiftDestinationConfiguration() {
        return this.redshiftDestinationConfiguration;
    }

    public final ElasticsearchDestinationConfiguration elasticsearchDestinationConfiguration() {
        return this.elasticsearchDestinationConfiguration;
    }

    public final AmazonopensearchserviceDestinationConfiguration amazonopensearchserviceDestinationConfiguration() {
        return this.amazonopensearchserviceDestinationConfiguration;
    }

    public final SplunkDestinationConfiguration splunkDestinationConfiguration() {
        return this.splunkDestinationConfiguration;
    }

    public final HttpEndpointDestinationConfiguration httpEndpointDestinationConfiguration() {
        return this.httpEndpointDestinationConfiguration;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryStreamTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisStreamSourceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryStreamEncryptionConfigurationInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3DestinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.extendedS3DestinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.redshiftDestinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticsearchDestinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.amazonopensearchserviceDestinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.splunkDestinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpEndpointDestinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeliveryStreamRequest)) {
            return false;
        }
        CreateDeliveryStreamRequest other = (CreateDeliveryStreamRequest)((Object)obj);
        return Objects.equals(this.deliveryStreamName(), other.deliveryStreamName()) && Objects.equals(this.deliveryStreamTypeAsString(), other.deliveryStreamTypeAsString()) && Objects.equals(this.kinesisStreamSourceConfiguration(), other.kinesisStreamSourceConfiguration()) && Objects.equals(this.deliveryStreamEncryptionConfigurationInput(), other.deliveryStreamEncryptionConfigurationInput()) && Objects.equals(this.s3DestinationConfiguration(), other.s3DestinationConfiguration()) && Objects.equals(this.extendedS3DestinationConfiguration(), other.extendedS3DestinationConfiguration()) && Objects.equals(this.redshiftDestinationConfiguration(), other.redshiftDestinationConfiguration()) && Objects.equals(this.elasticsearchDestinationConfiguration(), other.elasticsearchDestinationConfiguration()) && Objects.equals(this.amazonopensearchserviceDestinationConfiguration(), other.amazonopensearchserviceDestinationConfiguration()) && Objects.equals(this.splunkDestinationConfiguration(), other.splunkDestinationConfiguration()) && Objects.equals(this.httpEndpointDestinationConfiguration(), other.httpEndpointDestinationConfiguration()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDeliveryStreamRequest").add("DeliveryStreamName", (Object)this.deliveryStreamName()).add("DeliveryStreamType", (Object)this.deliveryStreamTypeAsString()).add("KinesisStreamSourceConfiguration", (Object)this.kinesisStreamSourceConfiguration()).add("DeliveryStreamEncryptionConfigurationInput", (Object)this.deliveryStreamEncryptionConfigurationInput()).add("S3DestinationConfiguration", (Object)this.s3DestinationConfiguration()).add("ExtendedS3DestinationConfiguration", (Object)this.extendedS3DestinationConfiguration()).add("RedshiftDestinationConfiguration", (Object)this.redshiftDestinationConfiguration()).add("ElasticsearchDestinationConfiguration", (Object)this.elasticsearchDestinationConfiguration()).add("AmazonopensearchserviceDestinationConfiguration", (Object)this.amazonopensearchserviceDestinationConfiguration()).add("SplunkDestinationConfiguration", (Object)this.splunkDestinationConfiguration()).add("HttpEndpointDestinationConfiguration", (Object)this.httpEndpointDestinationConfiguration()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeliveryStreamName": {
                return Optional.ofNullable(clazz.cast(this.deliveryStreamName()));
            }
            case "DeliveryStreamType": {
                return Optional.ofNullable(clazz.cast(this.deliveryStreamTypeAsString()));
            }
            case "KinesisStreamSourceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.kinesisStreamSourceConfiguration()));
            }
            case "DeliveryStreamEncryptionConfigurationInput": {
                return Optional.ofNullable(clazz.cast(this.deliveryStreamEncryptionConfigurationInput()));
            }
            case "S3DestinationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.s3DestinationConfiguration()));
            }
            case "ExtendedS3DestinationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.extendedS3DestinationConfiguration()));
            }
            case "RedshiftDestinationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.redshiftDestinationConfiguration()));
            }
            case "ElasticsearchDestinationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.elasticsearchDestinationConfiguration()));
            }
            case "AmazonopensearchserviceDestinationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.amazonopensearchserviceDestinationConfiguration()));
            }
            case "SplunkDestinationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.splunkDestinationConfiguration()));
            }
            case "HttpEndpointDestinationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.httpEndpointDestinationConfiguration()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDeliveryStreamRequest, T> g) {
        return obj -> g.apply((CreateDeliveryStreamRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FirehoseRequest.BuilderImpl
    implements Builder {
        private String deliveryStreamName;
        private String deliveryStreamType;
        private KinesisStreamSourceConfiguration kinesisStreamSourceConfiguration;
        private DeliveryStreamEncryptionConfigurationInput deliveryStreamEncryptionConfigurationInput;
        private S3DestinationConfiguration s3DestinationConfiguration;
        private ExtendedS3DestinationConfiguration extendedS3DestinationConfiguration;
        private RedshiftDestinationConfiguration redshiftDestinationConfiguration;
        private ElasticsearchDestinationConfiguration elasticsearchDestinationConfiguration;
        private AmazonopensearchserviceDestinationConfiguration amazonopensearchserviceDestinationConfiguration;
        private SplunkDestinationConfiguration splunkDestinationConfiguration;
        private HttpEndpointDestinationConfiguration httpEndpointDestinationConfiguration;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeliveryStreamRequest model) {
            super(model);
            this.deliveryStreamName(model.deliveryStreamName);
            this.deliveryStreamType(model.deliveryStreamType);
            this.kinesisStreamSourceConfiguration(model.kinesisStreamSourceConfiguration);
            this.deliveryStreamEncryptionConfigurationInput(model.deliveryStreamEncryptionConfigurationInput);
            this.s3DestinationConfiguration(model.s3DestinationConfiguration);
            this.extendedS3DestinationConfiguration(model.extendedS3DestinationConfiguration);
            this.redshiftDestinationConfiguration(model.redshiftDestinationConfiguration);
            this.elasticsearchDestinationConfiguration(model.elasticsearchDestinationConfiguration);
            this.amazonopensearchserviceDestinationConfiguration(model.amazonopensearchserviceDestinationConfiguration);
            this.splunkDestinationConfiguration(model.splunkDestinationConfiguration);
            this.httpEndpointDestinationConfiguration(model.httpEndpointDestinationConfiguration);
            this.tags(model.tags);
        }

        public final String getDeliveryStreamName() {
            return this.deliveryStreamName;
        }

        public final void setDeliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
        }

        @Override
        public final Builder deliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        public final String getDeliveryStreamType() {
            return this.deliveryStreamType;
        }

        public final void setDeliveryStreamType(String deliveryStreamType) {
            this.deliveryStreamType = deliveryStreamType;
        }

        @Override
        public final Builder deliveryStreamType(String deliveryStreamType) {
            this.deliveryStreamType = deliveryStreamType;
            return this;
        }

        @Override
        public final Builder deliveryStreamType(DeliveryStreamType deliveryStreamType) {
            this.deliveryStreamType(deliveryStreamType == null ? null : deliveryStreamType.toString());
            return this;
        }

        public final KinesisStreamSourceConfiguration.Builder getKinesisStreamSourceConfiguration() {
            return this.kinesisStreamSourceConfiguration != null ? this.kinesisStreamSourceConfiguration.toBuilder() : null;
        }

        public final void setKinesisStreamSourceConfiguration(KinesisStreamSourceConfiguration.BuilderImpl kinesisStreamSourceConfiguration) {
            this.kinesisStreamSourceConfiguration = kinesisStreamSourceConfiguration != null ? kinesisStreamSourceConfiguration.build() : null;
        }

        @Override
        public final Builder kinesisStreamSourceConfiguration(KinesisStreamSourceConfiguration kinesisStreamSourceConfiguration) {
            this.kinesisStreamSourceConfiguration = kinesisStreamSourceConfiguration;
            return this;
        }

        public final DeliveryStreamEncryptionConfigurationInput.Builder getDeliveryStreamEncryptionConfigurationInput() {
            return this.deliveryStreamEncryptionConfigurationInput != null ? this.deliveryStreamEncryptionConfigurationInput.toBuilder() : null;
        }

        public final void setDeliveryStreamEncryptionConfigurationInput(DeliveryStreamEncryptionConfigurationInput.BuilderImpl deliveryStreamEncryptionConfigurationInput) {
            this.deliveryStreamEncryptionConfigurationInput = deliveryStreamEncryptionConfigurationInput != null ? deliveryStreamEncryptionConfigurationInput.build() : null;
        }

        @Override
        public final Builder deliveryStreamEncryptionConfigurationInput(DeliveryStreamEncryptionConfigurationInput deliveryStreamEncryptionConfigurationInput) {
            this.deliveryStreamEncryptionConfigurationInput = deliveryStreamEncryptionConfigurationInput;
            return this;
        }

        @Deprecated
        public final S3DestinationConfiguration.Builder getS3DestinationConfiguration() {
            return this.s3DestinationConfiguration != null ? this.s3DestinationConfiguration.toBuilder() : null;
        }

        @Deprecated
        public final void setS3DestinationConfiguration(S3DestinationConfiguration.BuilderImpl s3DestinationConfiguration) {
            this.s3DestinationConfiguration = s3DestinationConfiguration != null ? s3DestinationConfiguration.build() : null;
        }

        @Override
        @Deprecated
        public final Builder s3DestinationConfiguration(S3DestinationConfiguration s3DestinationConfiguration) {
            this.s3DestinationConfiguration = s3DestinationConfiguration;
            return this;
        }

        public final ExtendedS3DestinationConfiguration.Builder getExtendedS3DestinationConfiguration() {
            return this.extendedS3DestinationConfiguration != null ? this.extendedS3DestinationConfiguration.toBuilder() : null;
        }

        public final void setExtendedS3DestinationConfiguration(ExtendedS3DestinationConfiguration.BuilderImpl extendedS3DestinationConfiguration) {
            this.extendedS3DestinationConfiguration = extendedS3DestinationConfiguration != null ? extendedS3DestinationConfiguration.build() : null;
        }

        @Override
        public final Builder extendedS3DestinationConfiguration(ExtendedS3DestinationConfiguration extendedS3DestinationConfiguration) {
            this.extendedS3DestinationConfiguration = extendedS3DestinationConfiguration;
            return this;
        }

        public final RedshiftDestinationConfiguration.Builder getRedshiftDestinationConfiguration() {
            return this.redshiftDestinationConfiguration != null ? this.redshiftDestinationConfiguration.toBuilder() : null;
        }

        public final void setRedshiftDestinationConfiguration(RedshiftDestinationConfiguration.BuilderImpl redshiftDestinationConfiguration) {
            this.redshiftDestinationConfiguration = redshiftDestinationConfiguration != null ? redshiftDestinationConfiguration.build() : null;
        }

        @Override
        public final Builder redshiftDestinationConfiguration(RedshiftDestinationConfiguration redshiftDestinationConfiguration) {
            this.redshiftDestinationConfiguration = redshiftDestinationConfiguration;
            return this;
        }

        public final ElasticsearchDestinationConfiguration.Builder getElasticsearchDestinationConfiguration() {
            return this.elasticsearchDestinationConfiguration != null ? this.elasticsearchDestinationConfiguration.toBuilder() : null;
        }

        public final void setElasticsearchDestinationConfiguration(ElasticsearchDestinationConfiguration.BuilderImpl elasticsearchDestinationConfiguration) {
            this.elasticsearchDestinationConfiguration = elasticsearchDestinationConfiguration != null ? elasticsearchDestinationConfiguration.build() : null;
        }

        @Override
        public final Builder elasticsearchDestinationConfiguration(ElasticsearchDestinationConfiguration elasticsearchDestinationConfiguration) {
            this.elasticsearchDestinationConfiguration = elasticsearchDestinationConfiguration;
            return this;
        }

        public final AmazonopensearchserviceDestinationConfiguration.Builder getAmazonopensearchserviceDestinationConfiguration() {
            return this.amazonopensearchserviceDestinationConfiguration != null ? this.amazonopensearchserviceDestinationConfiguration.toBuilder() : null;
        }

        public final void setAmazonopensearchserviceDestinationConfiguration(AmazonopensearchserviceDestinationConfiguration.BuilderImpl amazonopensearchserviceDestinationConfiguration) {
            this.amazonopensearchserviceDestinationConfiguration = amazonopensearchserviceDestinationConfiguration != null ? amazonopensearchserviceDestinationConfiguration.build() : null;
        }

        @Override
        public final Builder amazonopensearchserviceDestinationConfiguration(AmazonopensearchserviceDestinationConfiguration amazonopensearchserviceDestinationConfiguration) {
            this.amazonopensearchserviceDestinationConfiguration = amazonopensearchserviceDestinationConfiguration;
            return this;
        }

        public final SplunkDestinationConfiguration.Builder getSplunkDestinationConfiguration() {
            return this.splunkDestinationConfiguration != null ? this.splunkDestinationConfiguration.toBuilder() : null;
        }

        public final void setSplunkDestinationConfiguration(SplunkDestinationConfiguration.BuilderImpl splunkDestinationConfiguration) {
            this.splunkDestinationConfiguration = splunkDestinationConfiguration != null ? splunkDestinationConfiguration.build() : null;
        }

        @Override
        public final Builder splunkDestinationConfiguration(SplunkDestinationConfiguration splunkDestinationConfiguration) {
            this.splunkDestinationConfiguration = splunkDestinationConfiguration;
            return this;
        }

        public final HttpEndpointDestinationConfiguration.Builder getHttpEndpointDestinationConfiguration() {
            return this.httpEndpointDestinationConfiguration != null ? this.httpEndpointDestinationConfiguration.toBuilder() : null;
        }

        public final void setHttpEndpointDestinationConfiguration(HttpEndpointDestinationConfiguration.BuilderImpl httpEndpointDestinationConfiguration) {
            this.httpEndpointDestinationConfiguration = httpEndpointDestinationConfiguration != null ? httpEndpointDestinationConfiguration.build() : null;
        }

        @Override
        public final Builder httpEndpointDestinationConfiguration(HttpEndpointDestinationConfiguration httpEndpointDestinationConfiguration) {
            this.httpEndpointDestinationConfiguration = httpEndpointDestinationConfiguration;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagDeliveryStreamInputTagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagDeliveryStreamInputTagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagDeliveryStreamInputTagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDeliveryStreamRequest build() {
            return new CreateDeliveryStreamRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FirehoseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDeliveryStreamRequest> {
        public Builder deliveryStreamName(String var1);

        public Builder deliveryStreamType(String var1);

        public Builder deliveryStreamType(DeliveryStreamType var1);

        public Builder kinesisStreamSourceConfiguration(KinesisStreamSourceConfiguration var1);

        default public Builder kinesisStreamSourceConfiguration(Consumer<KinesisStreamSourceConfiguration.Builder> kinesisStreamSourceConfiguration) {
            return this.kinesisStreamSourceConfiguration((KinesisStreamSourceConfiguration)((KinesisStreamSourceConfiguration.Builder)KinesisStreamSourceConfiguration.builder().applyMutation(kinesisStreamSourceConfiguration)).build());
        }

        public Builder deliveryStreamEncryptionConfigurationInput(DeliveryStreamEncryptionConfigurationInput var1);

        default public Builder deliveryStreamEncryptionConfigurationInput(Consumer<DeliveryStreamEncryptionConfigurationInput.Builder> deliveryStreamEncryptionConfigurationInput) {
            return this.deliveryStreamEncryptionConfigurationInput((DeliveryStreamEncryptionConfigurationInput)((DeliveryStreamEncryptionConfigurationInput.Builder)DeliveryStreamEncryptionConfigurationInput.builder().applyMutation(deliveryStreamEncryptionConfigurationInput)).build());
        }

        @Deprecated
        public Builder s3DestinationConfiguration(S3DestinationConfiguration var1);

        @Deprecated
        default public Builder s3DestinationConfiguration(Consumer<S3DestinationConfiguration.Builder> s3DestinationConfiguration) {
            return this.s3DestinationConfiguration((S3DestinationConfiguration)((S3DestinationConfiguration.Builder)S3DestinationConfiguration.builder().applyMutation(s3DestinationConfiguration)).build());
        }

        public Builder extendedS3DestinationConfiguration(ExtendedS3DestinationConfiguration var1);

        default public Builder extendedS3DestinationConfiguration(Consumer<ExtendedS3DestinationConfiguration.Builder> extendedS3DestinationConfiguration) {
            return this.extendedS3DestinationConfiguration((ExtendedS3DestinationConfiguration)((ExtendedS3DestinationConfiguration.Builder)ExtendedS3DestinationConfiguration.builder().applyMutation(extendedS3DestinationConfiguration)).build());
        }

        public Builder redshiftDestinationConfiguration(RedshiftDestinationConfiguration var1);

        default public Builder redshiftDestinationConfiguration(Consumer<RedshiftDestinationConfiguration.Builder> redshiftDestinationConfiguration) {
            return this.redshiftDestinationConfiguration((RedshiftDestinationConfiguration)((RedshiftDestinationConfiguration.Builder)RedshiftDestinationConfiguration.builder().applyMutation(redshiftDestinationConfiguration)).build());
        }

        public Builder elasticsearchDestinationConfiguration(ElasticsearchDestinationConfiguration var1);

        default public Builder elasticsearchDestinationConfiguration(Consumer<ElasticsearchDestinationConfiguration.Builder> elasticsearchDestinationConfiguration) {
            return this.elasticsearchDestinationConfiguration((ElasticsearchDestinationConfiguration)((ElasticsearchDestinationConfiguration.Builder)ElasticsearchDestinationConfiguration.builder().applyMutation(elasticsearchDestinationConfiguration)).build());
        }

        public Builder amazonopensearchserviceDestinationConfiguration(AmazonopensearchserviceDestinationConfiguration var1);

        default public Builder amazonopensearchserviceDestinationConfiguration(Consumer<AmazonopensearchserviceDestinationConfiguration.Builder> amazonopensearchserviceDestinationConfiguration) {
            return this.amazonopensearchserviceDestinationConfiguration((AmazonopensearchserviceDestinationConfiguration)((AmazonopensearchserviceDestinationConfiguration.Builder)AmazonopensearchserviceDestinationConfiguration.builder().applyMutation(amazonopensearchserviceDestinationConfiguration)).build());
        }

        public Builder splunkDestinationConfiguration(SplunkDestinationConfiguration var1);

        default public Builder splunkDestinationConfiguration(Consumer<SplunkDestinationConfiguration.Builder> splunkDestinationConfiguration) {
            return this.splunkDestinationConfiguration((SplunkDestinationConfiguration)((SplunkDestinationConfiguration.Builder)SplunkDestinationConfiguration.builder().applyMutation(splunkDestinationConfiguration)).build());
        }

        public Builder httpEndpointDestinationConfiguration(HttpEndpointDestinationConfiguration var1);

        default public Builder httpEndpointDestinationConfiguration(Consumer<HttpEndpointDestinationConfiguration.Builder> httpEndpointDestinationConfiguration) {
            return this.httpEndpointDestinationConfiguration((HttpEndpointDestinationConfiguration)((HttpEndpointDestinationConfiguration.Builder)HttpEndpointDestinationConfiguration.builder().applyMutation(httpEndpointDestinationConfiguration)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

