/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose;

import java.util.function.Consumer;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.firehose.DefaultFirehoseClientBuilder;
import software.amazon.awssdk.services.firehose.FirehoseClientBuilder;
import software.amazon.awssdk.services.firehose.model.ConcurrentModificationException;
import software.amazon.awssdk.services.firehose.model.CreateDeliveryStreamRequest;
import software.amazon.awssdk.services.firehose.model.CreateDeliveryStreamResponse;
import software.amazon.awssdk.services.firehose.model.DeleteDeliveryStreamRequest;
import software.amazon.awssdk.services.firehose.model.DeleteDeliveryStreamResponse;
import software.amazon.awssdk.services.firehose.model.DescribeDeliveryStreamRequest;
import software.amazon.awssdk.services.firehose.model.DescribeDeliveryStreamResponse;
import software.amazon.awssdk.services.firehose.model.FirehoseException;
import software.amazon.awssdk.services.firehose.model.InvalidArgumentException;
import software.amazon.awssdk.services.firehose.model.InvalidKmsResourceException;
import software.amazon.awssdk.services.firehose.model.LimitExceededException;
import software.amazon.awssdk.services.firehose.model.ListDeliveryStreamsRequest;
import software.amazon.awssdk.services.firehose.model.ListDeliveryStreamsResponse;
import software.amazon.awssdk.services.firehose.model.ListTagsForDeliveryStreamRequest;
import software.amazon.awssdk.services.firehose.model.ListTagsForDeliveryStreamResponse;
import software.amazon.awssdk.services.firehose.model.PutRecordBatchRequest;
import software.amazon.awssdk.services.firehose.model.PutRecordBatchResponse;
import software.amazon.awssdk.services.firehose.model.PutRecordRequest;
import software.amazon.awssdk.services.firehose.model.PutRecordResponse;
import software.amazon.awssdk.services.firehose.model.ResourceInUseException;
import software.amazon.awssdk.services.firehose.model.ResourceNotFoundException;
import software.amazon.awssdk.services.firehose.model.ServiceUnavailableException;
import software.amazon.awssdk.services.firehose.model.StartDeliveryStreamEncryptionRequest;
import software.amazon.awssdk.services.firehose.model.StartDeliveryStreamEncryptionResponse;
import software.amazon.awssdk.services.firehose.model.StopDeliveryStreamEncryptionRequest;
import software.amazon.awssdk.services.firehose.model.StopDeliveryStreamEncryptionResponse;
import software.amazon.awssdk.services.firehose.model.TagDeliveryStreamRequest;
import software.amazon.awssdk.services.firehose.model.TagDeliveryStreamResponse;
import software.amazon.awssdk.services.firehose.model.UntagDeliveryStreamRequest;
import software.amazon.awssdk.services.firehose.model.UntagDeliveryStreamResponse;
import software.amazon.awssdk.services.firehose.model.UpdateDestinationRequest;
import software.amazon.awssdk.services.firehose.model.UpdateDestinationResponse;

public interface FirehoseClient
extends SdkClient {
    public static final String SERVICE_NAME = "firehose";
    public static final String SERVICE_METADATA_ID = "firehose";

    public static FirehoseClient create() {
        return (FirehoseClient)FirehoseClient.builder().build();
    }

    public static FirehoseClientBuilder builder() {
        return new DefaultFirehoseClientBuilder();
    }

    default public CreateDeliveryStreamResponse createDeliveryStream(CreateDeliveryStreamRequest createDeliveryStreamRequest) throws InvalidArgumentException, LimitExceededException, ResourceInUseException, InvalidKmsResourceException, AwsServiceException, SdkClientException, FirehoseException {
        throw new UnsupportedOperationException();
    }

    default public CreateDeliveryStreamResponse createDeliveryStream(Consumer<CreateDeliveryStreamRequest.Builder> createDeliveryStreamRequest) throws InvalidArgumentException, LimitExceededException, ResourceInUseException, InvalidKmsResourceException, AwsServiceException, SdkClientException, FirehoseException {
        return this.createDeliveryStream((CreateDeliveryStreamRequest)((Object)((CreateDeliveryStreamRequest.Builder)CreateDeliveryStreamRequest.builder().applyMutation(createDeliveryStreamRequest)).build()));
    }

    default public DeleteDeliveryStreamResponse deleteDeliveryStream(DeleteDeliveryStreamRequest deleteDeliveryStreamRequest) throws ResourceInUseException, ResourceNotFoundException, AwsServiceException, SdkClientException, FirehoseException {
        throw new UnsupportedOperationException();
    }

    default public DeleteDeliveryStreamResponse deleteDeliveryStream(Consumer<DeleteDeliveryStreamRequest.Builder> deleteDeliveryStreamRequest) throws ResourceInUseException, ResourceNotFoundException, AwsServiceException, SdkClientException, FirehoseException {
        return this.deleteDeliveryStream((DeleteDeliveryStreamRequest)((Object)((DeleteDeliveryStreamRequest.Builder)DeleteDeliveryStreamRequest.builder().applyMutation(deleteDeliveryStreamRequest)).build()));
    }

    default public DescribeDeliveryStreamResponse describeDeliveryStream(DescribeDeliveryStreamRequest describeDeliveryStreamRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, FirehoseException {
        throw new UnsupportedOperationException();
    }

    default public DescribeDeliveryStreamResponse describeDeliveryStream(Consumer<DescribeDeliveryStreamRequest.Builder> describeDeliveryStreamRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, FirehoseException {
        return this.describeDeliveryStream((DescribeDeliveryStreamRequest)((Object)((DescribeDeliveryStreamRequest.Builder)DescribeDeliveryStreamRequest.builder().applyMutation(describeDeliveryStreamRequest)).build()));
    }

    default public ListDeliveryStreamsResponse listDeliveryStreams() throws AwsServiceException, SdkClientException, FirehoseException {
        return this.listDeliveryStreams((ListDeliveryStreamsRequest)((Object)ListDeliveryStreamsRequest.builder().build()));
    }

    default public ListDeliveryStreamsResponse listDeliveryStreams(ListDeliveryStreamsRequest listDeliveryStreamsRequest) throws AwsServiceException, SdkClientException, FirehoseException {
        throw new UnsupportedOperationException();
    }

    default public ListDeliveryStreamsResponse listDeliveryStreams(Consumer<ListDeliveryStreamsRequest.Builder> listDeliveryStreamsRequest) throws AwsServiceException, SdkClientException, FirehoseException {
        return this.listDeliveryStreams((ListDeliveryStreamsRequest)((Object)((ListDeliveryStreamsRequest.Builder)ListDeliveryStreamsRequest.builder().applyMutation(listDeliveryStreamsRequest)).build()));
    }

    default public ListTagsForDeliveryStreamResponse listTagsForDeliveryStream(ListTagsForDeliveryStreamRequest listTagsForDeliveryStreamRequest) throws ResourceNotFoundException, InvalidArgumentException, LimitExceededException, AwsServiceException, SdkClientException, FirehoseException {
        throw new UnsupportedOperationException();
    }

    default public ListTagsForDeliveryStreamResponse listTagsForDeliveryStream(Consumer<ListTagsForDeliveryStreamRequest.Builder> listTagsForDeliveryStreamRequest) throws ResourceNotFoundException, InvalidArgumentException, LimitExceededException, AwsServiceException, SdkClientException, FirehoseException {
        return this.listTagsForDeliveryStream((ListTagsForDeliveryStreamRequest)((Object)((ListTagsForDeliveryStreamRequest.Builder)ListTagsForDeliveryStreamRequest.builder().applyMutation(listTagsForDeliveryStreamRequest)).build()));
    }

    default public PutRecordResponse putRecord(PutRecordRequest putRecordRequest) throws ResourceNotFoundException, InvalidArgumentException, InvalidKmsResourceException, ServiceUnavailableException, AwsServiceException, SdkClientException, FirehoseException {
        throw new UnsupportedOperationException();
    }

    default public PutRecordResponse putRecord(Consumer<PutRecordRequest.Builder> putRecordRequest) throws ResourceNotFoundException, InvalidArgumentException, InvalidKmsResourceException, ServiceUnavailableException, AwsServiceException, SdkClientException, FirehoseException {
        return this.putRecord((PutRecordRequest)((Object)((PutRecordRequest.Builder)PutRecordRequest.builder().applyMutation(putRecordRequest)).build()));
    }

    default public PutRecordBatchResponse putRecordBatch(PutRecordBatchRequest putRecordBatchRequest) throws ResourceNotFoundException, InvalidArgumentException, InvalidKmsResourceException, ServiceUnavailableException, AwsServiceException, SdkClientException, FirehoseException {
        throw new UnsupportedOperationException();
    }

    default public PutRecordBatchResponse putRecordBatch(Consumer<PutRecordBatchRequest.Builder> putRecordBatchRequest) throws ResourceNotFoundException, InvalidArgumentException, InvalidKmsResourceException, ServiceUnavailableException, AwsServiceException, SdkClientException, FirehoseException {
        return this.putRecordBatch((PutRecordBatchRequest)((Object)((PutRecordBatchRequest.Builder)PutRecordBatchRequest.builder().applyMutation(putRecordBatchRequest)).build()));
    }

    default public StartDeliveryStreamEncryptionResponse startDeliveryStreamEncryption(StartDeliveryStreamEncryptionRequest startDeliveryStreamEncryptionRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, LimitExceededException, InvalidKmsResourceException, AwsServiceException, SdkClientException, FirehoseException {
        throw new UnsupportedOperationException();
    }

    default public StartDeliveryStreamEncryptionResponse startDeliveryStreamEncryption(Consumer<StartDeliveryStreamEncryptionRequest.Builder> startDeliveryStreamEncryptionRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, LimitExceededException, InvalidKmsResourceException, AwsServiceException, SdkClientException, FirehoseException {
        return this.startDeliveryStreamEncryption((StartDeliveryStreamEncryptionRequest)((Object)((StartDeliveryStreamEncryptionRequest.Builder)StartDeliveryStreamEncryptionRequest.builder().applyMutation(startDeliveryStreamEncryptionRequest)).build()));
    }

    default public StopDeliveryStreamEncryptionResponse stopDeliveryStreamEncryption(StopDeliveryStreamEncryptionRequest stopDeliveryStreamEncryptionRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, LimitExceededException, AwsServiceException, SdkClientException, FirehoseException {
        throw new UnsupportedOperationException();
    }

    default public StopDeliveryStreamEncryptionResponse stopDeliveryStreamEncryption(Consumer<StopDeliveryStreamEncryptionRequest.Builder> stopDeliveryStreamEncryptionRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, LimitExceededException, AwsServiceException, SdkClientException, FirehoseException {
        return this.stopDeliveryStreamEncryption((StopDeliveryStreamEncryptionRequest)((Object)((StopDeliveryStreamEncryptionRequest.Builder)StopDeliveryStreamEncryptionRequest.builder().applyMutation(stopDeliveryStreamEncryptionRequest)).build()));
    }

    default public TagDeliveryStreamResponse tagDeliveryStream(TagDeliveryStreamRequest tagDeliveryStreamRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, LimitExceededException, AwsServiceException, SdkClientException, FirehoseException {
        throw new UnsupportedOperationException();
    }

    default public TagDeliveryStreamResponse tagDeliveryStream(Consumer<TagDeliveryStreamRequest.Builder> tagDeliveryStreamRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, LimitExceededException, AwsServiceException, SdkClientException, FirehoseException {
        return this.tagDeliveryStream((TagDeliveryStreamRequest)((Object)((TagDeliveryStreamRequest.Builder)TagDeliveryStreamRequest.builder().applyMutation(tagDeliveryStreamRequest)).build()));
    }

    default public UntagDeliveryStreamResponse untagDeliveryStream(UntagDeliveryStreamRequest untagDeliveryStreamRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, LimitExceededException, AwsServiceException, SdkClientException, FirehoseException {
        throw new UnsupportedOperationException();
    }

    default public UntagDeliveryStreamResponse untagDeliveryStream(Consumer<UntagDeliveryStreamRequest.Builder> untagDeliveryStreamRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, LimitExceededException, AwsServiceException, SdkClientException, FirehoseException {
        return this.untagDeliveryStream((UntagDeliveryStreamRequest)((Object)((UntagDeliveryStreamRequest.Builder)UntagDeliveryStreamRequest.builder().applyMutation(untagDeliveryStreamRequest)).build()));
    }

    default public UpdateDestinationResponse updateDestination(UpdateDestinationRequest updateDestinationRequest) throws InvalidArgumentException, ResourceInUseException, ResourceNotFoundException, ConcurrentModificationException, AwsServiceException, SdkClientException, FirehoseException {
        throw new UnsupportedOperationException();
    }

    default public UpdateDestinationResponse updateDestination(Consumer<UpdateDestinationRequest.Builder> updateDestinationRequest) throws InvalidArgumentException, ResourceInUseException, ResourceNotFoundException, ConcurrentModificationException, AwsServiceException, SdkClientException, FirehoseException {
        return this.updateDestination((UpdateDestinationRequest)((Object)((UpdateDestinationRequest.Builder)UpdateDestinationRequest.builder().applyMutation(updateDestinationRequest)).build()));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"firehose");
    }
}

