/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.firehose.model.SecurityGroupIdListCopier;
import software.amazon.awssdk.services.firehose.model.SubnetIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VpcConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VpcConfiguration> {
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetIds").getter(VpcConfiguration.getter(VpcConfiguration::subnetIds)).setter(VpcConfiguration.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleARN").getter(VpcConfiguration.getter(VpcConfiguration::roleARN)).setter(VpcConfiguration.setter(Builder::roleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(VpcConfiguration.getter(VpcConfiguration::securityGroupIds)).setter(VpcConfiguration.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_IDS_FIELD, ROLE_ARN_FIELD, SECURITY_GROUP_IDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> subnetIds;
    private final String roleARN;
    private final List<String> securityGroupIds;

    private VpcConfiguration(BuilderImpl builder) {
        this.subnetIds = builder.subnetIds;
        this.roleARN = builder.roleARN;
        this.securityGroupIds = builder.securityGroupIds;
    }

    public boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public List<String> subnetIds() {
        return this.subnetIds;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcConfiguration)) {
            return false;
        }
        VpcConfiguration other = (VpcConfiguration)obj;
        return Objects.equals(this.subnetIds(), other.subnetIds()) && Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.securityGroupIds(), other.securityGroupIds());
    }

    public String toString() {
        return ToString.builder((String)"VpcConfiguration").add("SubnetIds", this.subnetIds()).add("RoleARN", (Object)this.roleARN()).add("SecurityGroupIds", this.securityGroupIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VpcConfiguration, T> g) {
        return obj -> g.apply((VpcConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private String roleARN;
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VpcConfiguration model) {
            this.subnetIds(model.subnetIds);
            this.roleARN(model.roleARN);
            this.securityGroupIds(model.securityGroupIds);
        }

        public final Collection<String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final Collection<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdListCopier.copy(securityGroupIds);
        }

        public VpcConfiguration build() {
            return new VpcConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VpcConfiguration> {
        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder roleARN(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);
    }
}

