/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.firehose.model.ContentEncoding;
import software.amazon.awssdk.services.firehose.model.HttpEndpointCommonAttribute;
import software.amazon.awssdk.services.firehose.model.HttpEndpointCommonAttributesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HttpEndpointRequestConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HttpEndpointRequestConfiguration> {
    private static final SdkField<String> CONTENT_ENCODING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HttpEndpointRequestConfiguration.getter(HttpEndpointRequestConfiguration::contentEncodingAsString)).setter(HttpEndpointRequestConfiguration.setter(Builder::contentEncoding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentEncoding").build()}).build();
    private static final SdkField<List<HttpEndpointCommonAttribute>> COMMON_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(HttpEndpointRequestConfiguration.getter(HttpEndpointRequestConfiguration::commonAttributes)).setter(HttpEndpointRequestConfiguration.setter(Builder::commonAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommonAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HttpEndpointCommonAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_ENCODING_FIELD, COMMON_ATTRIBUTES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String contentEncoding;
    private final List<HttpEndpointCommonAttribute> commonAttributes;

    private HttpEndpointRequestConfiguration(BuilderImpl builder) {
        this.contentEncoding = builder.contentEncoding;
        this.commonAttributes = builder.commonAttributes;
    }

    public ContentEncoding contentEncoding() {
        return ContentEncoding.fromValue(this.contentEncoding);
    }

    public String contentEncodingAsString() {
        return this.contentEncoding;
    }

    public boolean hasCommonAttributes() {
        return this.commonAttributes != null && !(this.commonAttributes instanceof SdkAutoConstructList);
    }

    public List<HttpEndpointCommonAttribute> commonAttributes() {
        return this.commonAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.contentEncodingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.commonAttributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpEndpointRequestConfiguration)) {
            return false;
        }
        HttpEndpointRequestConfiguration other = (HttpEndpointRequestConfiguration)obj;
        return Objects.equals(this.contentEncodingAsString(), other.contentEncodingAsString()) && Objects.equals(this.commonAttributes(), other.commonAttributes());
    }

    public String toString() {
        return ToString.builder((String)"HttpEndpointRequestConfiguration").add("ContentEncoding", (Object)this.contentEncodingAsString()).add("CommonAttributes", this.commonAttributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContentEncoding": {
                return Optional.ofNullable(clazz.cast(this.contentEncodingAsString()));
            }
            case "CommonAttributes": {
                return Optional.ofNullable(clazz.cast(this.commonAttributes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HttpEndpointRequestConfiguration, T> g) {
        return obj -> g.apply((HttpEndpointRequestConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String contentEncoding;
        private List<HttpEndpointCommonAttribute> commonAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HttpEndpointRequestConfiguration model) {
            this.contentEncoding(model.contentEncoding);
            this.commonAttributes(model.commonAttributes);
        }

        public final String getContentEncoding() {
            return this.contentEncoding;
        }

        @Override
        public final Builder contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        @Override
        public final Builder contentEncoding(ContentEncoding contentEncoding) {
            this.contentEncoding(contentEncoding == null ? null : contentEncoding.toString());
            return this;
        }

        public final void setContentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
        }

        public final Collection<HttpEndpointCommonAttribute.Builder> getCommonAttributes() {
            return this.commonAttributes != null ? (Collection)this.commonAttributes.stream().map(HttpEndpointCommonAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder commonAttributes(Collection<HttpEndpointCommonAttribute> commonAttributes) {
            this.commonAttributes = HttpEndpointCommonAttributesListCopier.copy(commonAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commonAttributes(HttpEndpointCommonAttribute ... commonAttributes) {
            this.commonAttributes(Arrays.asList(commonAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commonAttributes(Consumer<HttpEndpointCommonAttribute.Builder> ... commonAttributes) {
            this.commonAttributes(Stream.of(commonAttributes).map(c -> (HttpEndpointCommonAttribute)((HttpEndpointCommonAttribute.Builder)HttpEndpointCommonAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCommonAttributes(Collection<HttpEndpointCommonAttribute.BuilderImpl> commonAttributes) {
            this.commonAttributes = HttpEndpointCommonAttributesListCopier.copyFromBuilder(commonAttributes);
        }

        public HttpEndpointRequestConfiguration build() {
            return new HttpEndpointRequestConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HttpEndpointRequestConfiguration> {
        public Builder contentEncoding(String var1);

        public Builder contentEncoding(ContentEncoding var1);

        public Builder commonAttributes(Collection<HttpEndpointCommonAttribute> var1);

        public Builder commonAttributes(HttpEndpointCommonAttribute ... var1);

        public Builder commonAttributes(Consumer<HttpEndpointCommonAttribute.Builder> ... var1);
    }
}

