/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.firehose.model.SplunkRetryOptions;

public class SplunkRetryOptionsUnmarshaller
implements Unmarshaller<SplunkRetryOptions, JsonUnmarshallerContext> {
    private static final SplunkRetryOptionsUnmarshaller INSTANCE = new SplunkRetryOptionsUnmarshaller();

    public SplunkRetryOptions unmarshall(JsonUnmarshallerContext context) throws Exception {
        SplunkRetryOptions.Builder splunkRetryOptionsBuilder = SplunkRetryOptions.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("DurationInSeconds", targetDepth)) {
                    context.nextToken();
                    splunkRetryOptionsBuilder.durationInSeconds((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (SplunkRetryOptions)splunkRetryOptionsBuilder.build();
    }

    public static SplunkRetryOptionsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

