/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.Serializer;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SerializerMarshaller {
    private static final MarshallingInfo<StructuredPojo> PARQUETSERDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParquetSerDe").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ORCSERDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OrcSerDe").isBinary(false).build();
    private static final SerializerMarshaller INSTANCE = new SerializerMarshaller();

    private SerializerMarshaller() {
    }

    public static SerializerMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Serializer serializer, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)serializer, (String)"serializer");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)serializer.parquetSerDe(), PARQUETSERDE_BINDING);
            protocolMarshaller.marshall((Object)serializer.orcSerDe(), ORCSERDE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

