/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.RedshiftDestinationUpdate;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RedshiftDestinationUpdateMarshaller {
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleARN").isBinary(false).build();
    private static final MarshallingInfo<String> CLUSTERJDBCURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterJDBCURL").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> COPYCOMMAND_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CopyCommand").isBinary(false).build();
    private static final MarshallingInfo<String> USERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Username").isBinary(false).build();
    private static final MarshallingInfo<String> PASSWORD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Password").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> RETRYOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RetryOptions").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> S3UPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Update").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> PROCESSINGCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProcessingConfiguration").isBinary(false).build();
    private static final MarshallingInfo<String> S3BACKUPMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3BackupMode").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> S3BACKUPUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3BackupUpdate").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CLOUDWATCHLOGGINGOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CloudWatchLoggingOptions").isBinary(false).build();
    private static final RedshiftDestinationUpdateMarshaller INSTANCE = new RedshiftDestinationUpdateMarshaller();

    private RedshiftDestinationUpdateMarshaller() {
    }

    public static RedshiftDestinationUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RedshiftDestinationUpdate redshiftDestinationUpdate, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)redshiftDestinationUpdate, (String)"redshiftDestinationUpdate");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)redshiftDestinationUpdate.roleARN(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)redshiftDestinationUpdate.clusterJDBCURL(), CLUSTERJDBCURL_BINDING);
            protocolMarshaller.marshall((Object)redshiftDestinationUpdate.copyCommand(), COPYCOMMAND_BINDING);
            protocolMarshaller.marshall((Object)redshiftDestinationUpdate.username(), USERNAME_BINDING);
            protocolMarshaller.marshall((Object)redshiftDestinationUpdate.password(), PASSWORD_BINDING);
            protocolMarshaller.marshall((Object)redshiftDestinationUpdate.retryOptions(), RETRYOPTIONS_BINDING);
            protocolMarshaller.marshall((Object)redshiftDestinationUpdate.s3Update(), S3UPDATE_BINDING);
            protocolMarshaller.marshall((Object)redshiftDestinationUpdate.processingConfiguration(), PROCESSINGCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)redshiftDestinationUpdate.s3BackupModeAsString(), S3BACKUPMODE_BINDING);
            protocolMarshaller.marshall((Object)redshiftDestinationUpdate.s3BackupUpdate(), S3BACKUPUPDATE_BINDING);
            protocolMarshaller.marshall((Object)redshiftDestinationUpdate.cloudWatchLoggingOptions(), CLOUDWATCHLOGGINGOPTIONS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

