/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.firehose.model.ProcessorParameter;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ProcessorParameterMarshaller {
    private static final MarshallingInfo<String> PARAMETERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParameterName").isBinary(false).build();
    private static final MarshallingInfo<String> PARAMETERVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParameterValue").isBinary(false).build();
    private static final ProcessorParameterMarshaller INSTANCE = new ProcessorParameterMarshaller();

    private ProcessorParameterMarshaller() {
    }

    public static ProcessorParameterMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ProcessorParameter processorParameter, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)processorParameter, (String)"processorParameter");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)processorParameter.parameterNameAsString(), PARAMETERNAME_BINDING);
            protocolMarshaller.marshall((Object)processorParameter.parameterValue(), PARAMETERVALUE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

