/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.firehose.model.ParquetSerDe;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ParquetSerDeMarshaller {
    private static final MarshallingInfo<Integer> BLOCKSIZEBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BlockSizeBytes").isBinary(false).build();
    private static final MarshallingInfo<Integer> PAGESIZEBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PageSizeBytes").isBinary(false).build();
    private static final MarshallingInfo<String> COMPRESSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Compression").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ENABLEDICTIONARYCOMPRESSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EnableDictionaryCompression").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXPADDINGBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxPaddingBytes").isBinary(false).build();
    private static final MarshallingInfo<String> WRITERVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WriterVersion").isBinary(false).build();
    private static final ParquetSerDeMarshaller INSTANCE = new ParquetSerDeMarshaller();

    private ParquetSerDeMarshaller() {
    }

    public static ParquetSerDeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ParquetSerDe parquetSerDe, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)parquetSerDe, (String)"parquetSerDe");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)parquetSerDe.blockSizeBytes(), BLOCKSIZEBYTES_BINDING);
            protocolMarshaller.marshall((Object)parquetSerDe.pageSizeBytes(), PAGESIZEBYTES_BINDING);
            protocolMarshaller.marshall((Object)parquetSerDe.compressionAsString(), COMPRESSION_BINDING);
            protocolMarshaller.marshall((Object)parquetSerDe.enableDictionaryCompression(), ENABLEDICTIONARYCOMPRESSION_BINDING);
            protocolMarshaller.marshall((Object)parquetSerDe.maxPaddingBytes(), MAXPADDINGBYTES_BINDING);
            protocolMarshaller.marshall((Object)parquetSerDe.writerVersionAsString(), WRITERVERSION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

