/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.DataFormatConversionConfiguration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DataFormatConversionConfigurationMarshaller {
    private static final MarshallingInfo<StructuredPojo> SCHEMACONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SchemaConfiguration").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> INPUTFORMATCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputFormatConfiguration").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> OUTPUTFORMATCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputFormatConfiguration").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Enabled").isBinary(false).build();
    private static final DataFormatConversionConfigurationMarshaller INSTANCE = new DataFormatConversionConfigurationMarshaller();

    private DataFormatConversionConfigurationMarshaller() {
    }

    public static DataFormatConversionConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DataFormatConversionConfiguration dataFormatConversionConfiguration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)dataFormatConversionConfiguration, (String)"dataFormatConversionConfiguration");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)dataFormatConversionConfiguration.schemaConfiguration(), SCHEMACONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)dataFormatConversionConfiguration.inputFormatConfiguration(), INPUTFORMATCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)dataFormatConversionConfiguration.outputFormatConfiguration(), OUTPUTFORMATCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)dataFormatConversionConfiguration.enabled(), ENABLED_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

