/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.CreateDeliveryStreamRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateDeliveryStreamRequestModelMarshaller {
    private static final MarshallingInfo<String> DELIVERYSTREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeliveryStreamName").isBinary(false).build();
    private static final MarshallingInfo<String> DELIVERYSTREAMTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeliveryStreamType").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> KINESISSTREAMSOURCECONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KinesisStreamSourceConfiguration").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> S3DESTINATIONCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3DestinationConfiguration").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> EXTENDEDS3DESTINATIONCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExtendedS3DestinationConfiguration").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> REDSHIFTDESTINATIONCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RedshiftDestinationConfiguration").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ELASTICSEARCHDESTINATIONCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ElasticsearchDestinationConfiguration").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SPLUNKDESTINATIONCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SplunkDestinationConfiguration").isBinary(false).build();
    private static final CreateDeliveryStreamRequestModelMarshaller INSTANCE = new CreateDeliveryStreamRequestModelMarshaller();

    private CreateDeliveryStreamRequestModelMarshaller() {
    }

    public static CreateDeliveryStreamRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateDeliveryStreamRequest createDeliveryStreamRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createDeliveryStreamRequest), (String)"createDeliveryStreamRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createDeliveryStreamRequest.deliveryStreamName(), DELIVERYSTREAMNAME_BINDING);
            protocolMarshaller.marshall((Object)createDeliveryStreamRequest.deliveryStreamTypeAsString(), DELIVERYSTREAMTYPE_BINDING);
            protocolMarshaller.marshall((Object)createDeliveryStreamRequest.kinesisStreamSourceConfiguration(), KINESISSTREAMSOURCECONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)createDeliveryStreamRequest.s3DestinationConfiguration(), S3DESTINATIONCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)createDeliveryStreamRequest.extendedS3DestinationConfiguration(), EXTENDEDS3DESTINATIONCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)createDeliveryStreamRequest.redshiftDestinationConfiguration(), REDSHIFTDESTINATIONCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)createDeliveryStreamRequest.elasticsearchDestinationConfiguration(), ELASTICSEARCHDESTINATIONCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)createDeliveryStreamRequest.splunkDestinationConfiguration(), SPLUNKDESTINATIONCONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

