/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.Serializer;
import software.amazon.awssdk.services.firehose.transform.OutputFormatConfigurationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OutputFormatConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, OutputFormatConfiguration> {
    private final Serializer serializer;

    private OutputFormatConfiguration(BuilderImpl builder) {
        this.serializer = builder.serializer;
    }

    public Serializer serializer() {
        return this.serializer;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serializer());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputFormatConfiguration)) {
            return false;
        }
        OutputFormatConfiguration other = (OutputFormatConfiguration)obj;
        return Objects.equals(this.serializer(), other.serializer());
    }

    public String toString() {
        return ToString.builder((String)"OutputFormatConfiguration").add("Serializer", (Object)this.serializer()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Serializer": {
                return Optional.ofNullable(clazz.cast(this.serializer()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OutputFormatConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Serializer serializer;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputFormatConfiguration model) {
            this.serializer(model.serializer);
        }

        public final Serializer.Builder getSerializer() {
            return this.serializer != null ? this.serializer.toBuilder() : null;
        }

        @Override
        public final Builder serializer(Serializer serializer) {
            this.serializer = serializer;
            return this;
        }

        public final void setSerializer(Serializer.BuilderImpl serializer) {
            this.serializer = serializer != null ? serializer.build() : null;
        }

        public OutputFormatConfiguration build() {
            return new OutputFormatConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, OutputFormatConfiguration> {
        public Builder serializer(Serializer var1);

        default public Builder serializer(Consumer<Serializer.Builder> serializer) {
            return this.serializer((Serializer)((Serializer.Builder)Serializer.builder().applyMutation(serializer)).build());
        }
    }
}

