/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.firehose.model.ListOfNonEmptyStringsWithoutWhitespaceCopier;
import software.amazon.awssdk.services.firehose.model.OrcCompression;
import software.amazon.awssdk.services.firehose.model.OrcFormatVersion;
import software.amazon.awssdk.services.firehose.transform.OrcSerDeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OrcSerDe
implements StructuredPojo,
ToCopyableBuilder<Builder, OrcSerDe> {
    private final Integer stripeSizeBytes;
    private final Integer blockSizeBytes;
    private final Integer rowIndexStride;
    private final Boolean enablePadding;
    private final Double paddingTolerance;
    private final String compression;
    private final List<String> bloomFilterColumns;
    private final Double bloomFilterFalsePositiveProbability;
    private final Double dictionaryKeyThreshold;
    private final String formatVersion;

    private OrcSerDe(BuilderImpl builder) {
        this.stripeSizeBytes = builder.stripeSizeBytes;
        this.blockSizeBytes = builder.blockSizeBytes;
        this.rowIndexStride = builder.rowIndexStride;
        this.enablePadding = builder.enablePadding;
        this.paddingTolerance = builder.paddingTolerance;
        this.compression = builder.compression;
        this.bloomFilterColumns = builder.bloomFilterColumns;
        this.bloomFilterFalsePositiveProbability = builder.bloomFilterFalsePositiveProbability;
        this.dictionaryKeyThreshold = builder.dictionaryKeyThreshold;
        this.formatVersion = builder.formatVersion;
    }

    public Integer stripeSizeBytes() {
        return this.stripeSizeBytes;
    }

    public Integer blockSizeBytes() {
        return this.blockSizeBytes;
    }

    public Integer rowIndexStride() {
        return this.rowIndexStride;
    }

    public Boolean enablePadding() {
        return this.enablePadding;
    }

    public Double paddingTolerance() {
        return this.paddingTolerance;
    }

    public OrcCompression compression() {
        return OrcCompression.fromValue(this.compression);
    }

    public String compressionAsString() {
        return this.compression;
    }

    public List<String> bloomFilterColumns() {
        return this.bloomFilterColumns;
    }

    public Double bloomFilterFalsePositiveProbability() {
        return this.bloomFilterFalsePositiveProbability;
    }

    public Double dictionaryKeyThreshold() {
        return this.dictionaryKeyThreshold;
    }

    public OrcFormatVersion formatVersion() {
        return OrcFormatVersion.fromValue(this.formatVersion);
    }

    public String formatVersionAsString() {
        return this.formatVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stripeSizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockSizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.rowIndexStride());
        hashCode = 31 * hashCode + Objects.hashCode(this.enablePadding());
        hashCode = 31 * hashCode + Objects.hashCode(this.paddingTolerance());
        hashCode = 31 * hashCode + Objects.hashCode(this.compressionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bloomFilterColumns());
        hashCode = 31 * hashCode + Objects.hashCode(this.bloomFilterFalsePositiveProbability());
        hashCode = 31 * hashCode + Objects.hashCode(this.dictionaryKeyThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatVersionAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrcSerDe)) {
            return false;
        }
        OrcSerDe other = (OrcSerDe)obj;
        return Objects.equals(this.stripeSizeBytes(), other.stripeSizeBytes()) && Objects.equals(this.blockSizeBytes(), other.blockSizeBytes()) && Objects.equals(this.rowIndexStride(), other.rowIndexStride()) && Objects.equals(this.enablePadding(), other.enablePadding()) && Objects.equals(this.paddingTolerance(), other.paddingTolerance()) && Objects.equals(this.compressionAsString(), other.compressionAsString()) && Objects.equals(this.bloomFilterColumns(), other.bloomFilterColumns()) && Objects.equals(this.bloomFilterFalsePositiveProbability(), other.bloomFilterFalsePositiveProbability()) && Objects.equals(this.dictionaryKeyThreshold(), other.dictionaryKeyThreshold()) && Objects.equals(this.formatVersionAsString(), other.formatVersionAsString());
    }

    public String toString() {
        return ToString.builder((String)"OrcSerDe").add("StripeSizeBytes", (Object)this.stripeSizeBytes()).add("BlockSizeBytes", (Object)this.blockSizeBytes()).add("RowIndexStride", (Object)this.rowIndexStride()).add("EnablePadding", (Object)this.enablePadding()).add("PaddingTolerance", (Object)this.paddingTolerance()).add("Compression", (Object)this.compressionAsString()).add("BloomFilterColumns", this.bloomFilterColumns()).add("BloomFilterFalsePositiveProbability", (Object)this.bloomFilterFalsePositiveProbability()).add("DictionaryKeyThreshold", (Object)this.dictionaryKeyThreshold()).add("FormatVersion", (Object)this.formatVersionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StripeSizeBytes": {
                return Optional.ofNullable(clazz.cast(this.stripeSizeBytes()));
            }
            case "BlockSizeBytes": {
                return Optional.ofNullable(clazz.cast(this.blockSizeBytes()));
            }
            case "RowIndexStride": {
                return Optional.ofNullable(clazz.cast(this.rowIndexStride()));
            }
            case "EnablePadding": {
                return Optional.ofNullable(clazz.cast(this.enablePadding()));
            }
            case "PaddingTolerance": {
                return Optional.ofNullable(clazz.cast(this.paddingTolerance()));
            }
            case "Compression": {
                return Optional.ofNullable(clazz.cast(this.compressionAsString()));
            }
            case "BloomFilterColumns": {
                return Optional.ofNullable(clazz.cast(this.bloomFilterColumns()));
            }
            case "BloomFilterFalsePositiveProbability": {
                return Optional.ofNullable(clazz.cast(this.bloomFilterFalsePositiveProbability()));
            }
            case "DictionaryKeyThreshold": {
                return Optional.ofNullable(clazz.cast(this.dictionaryKeyThreshold()));
            }
            case "FormatVersion": {
                return Optional.ofNullable(clazz.cast(this.formatVersionAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OrcSerDeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer stripeSizeBytes;
        private Integer blockSizeBytes;
        private Integer rowIndexStride;
        private Boolean enablePadding;
        private Double paddingTolerance;
        private String compression;
        private List<String> bloomFilterColumns = DefaultSdkAutoConstructList.getInstance();
        private Double bloomFilterFalsePositiveProbability;
        private Double dictionaryKeyThreshold;
        private String formatVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(OrcSerDe model) {
            this.stripeSizeBytes(model.stripeSizeBytes);
            this.blockSizeBytes(model.blockSizeBytes);
            this.rowIndexStride(model.rowIndexStride);
            this.enablePadding(model.enablePadding);
            this.paddingTolerance(model.paddingTolerance);
            this.compression(model.compression);
            this.bloomFilterColumns(model.bloomFilterColumns);
            this.bloomFilterFalsePositiveProbability(model.bloomFilterFalsePositiveProbability);
            this.dictionaryKeyThreshold(model.dictionaryKeyThreshold);
            this.formatVersion(model.formatVersion);
        }

        public final Integer getStripeSizeBytes() {
            return this.stripeSizeBytes;
        }

        @Override
        public final Builder stripeSizeBytes(Integer stripeSizeBytes) {
            this.stripeSizeBytes = stripeSizeBytes;
            return this;
        }

        public final void setStripeSizeBytes(Integer stripeSizeBytes) {
            this.stripeSizeBytes = stripeSizeBytes;
        }

        public final Integer getBlockSizeBytes() {
            return this.blockSizeBytes;
        }

        @Override
        public final Builder blockSizeBytes(Integer blockSizeBytes) {
            this.blockSizeBytes = blockSizeBytes;
            return this;
        }

        public final void setBlockSizeBytes(Integer blockSizeBytes) {
            this.blockSizeBytes = blockSizeBytes;
        }

        public final Integer getRowIndexStride() {
            return this.rowIndexStride;
        }

        @Override
        public final Builder rowIndexStride(Integer rowIndexStride) {
            this.rowIndexStride = rowIndexStride;
            return this;
        }

        public final void setRowIndexStride(Integer rowIndexStride) {
            this.rowIndexStride = rowIndexStride;
        }

        public final Boolean getEnablePadding() {
            return this.enablePadding;
        }

        @Override
        public final Builder enablePadding(Boolean enablePadding) {
            this.enablePadding = enablePadding;
            return this;
        }

        public final void setEnablePadding(Boolean enablePadding) {
            this.enablePadding = enablePadding;
        }

        public final Double getPaddingTolerance() {
            return this.paddingTolerance;
        }

        @Override
        public final Builder paddingTolerance(Double paddingTolerance) {
            this.paddingTolerance = paddingTolerance;
            return this;
        }

        public final void setPaddingTolerance(Double paddingTolerance) {
            this.paddingTolerance = paddingTolerance;
        }

        public final String getCompression() {
            return this.compression;
        }

        @Override
        public final Builder compression(String compression) {
            this.compression = compression;
            return this;
        }

        @Override
        public final Builder compression(OrcCompression compression) {
            this.compression(compression.toString());
            return this;
        }

        public final void setCompression(String compression) {
            this.compression = compression;
        }

        public final Collection<String> getBloomFilterColumns() {
            return this.bloomFilterColumns;
        }

        @Override
        public final Builder bloomFilterColumns(Collection<String> bloomFilterColumns) {
            this.bloomFilterColumns = ListOfNonEmptyStringsWithoutWhitespaceCopier.copy(bloomFilterColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bloomFilterColumns(String ... bloomFilterColumns) {
            this.bloomFilterColumns(Arrays.asList(bloomFilterColumns));
            return this;
        }

        public final void setBloomFilterColumns(Collection<String> bloomFilterColumns) {
            this.bloomFilterColumns = ListOfNonEmptyStringsWithoutWhitespaceCopier.copy(bloomFilterColumns);
        }

        public final Double getBloomFilterFalsePositiveProbability() {
            return this.bloomFilterFalsePositiveProbability;
        }

        @Override
        public final Builder bloomFilterFalsePositiveProbability(Double bloomFilterFalsePositiveProbability) {
            this.bloomFilterFalsePositiveProbability = bloomFilterFalsePositiveProbability;
            return this;
        }

        public final void setBloomFilterFalsePositiveProbability(Double bloomFilterFalsePositiveProbability) {
            this.bloomFilterFalsePositiveProbability = bloomFilterFalsePositiveProbability;
        }

        public final Double getDictionaryKeyThreshold() {
            return this.dictionaryKeyThreshold;
        }

        @Override
        public final Builder dictionaryKeyThreshold(Double dictionaryKeyThreshold) {
            this.dictionaryKeyThreshold = dictionaryKeyThreshold;
            return this;
        }

        public final void setDictionaryKeyThreshold(Double dictionaryKeyThreshold) {
            this.dictionaryKeyThreshold = dictionaryKeyThreshold;
        }

        public final String getFormatVersion() {
            return this.formatVersion;
        }

        @Override
        public final Builder formatVersion(String formatVersion) {
            this.formatVersion = formatVersion;
            return this;
        }

        @Override
        public final Builder formatVersion(OrcFormatVersion formatVersion) {
            this.formatVersion(formatVersion.toString());
            return this;
        }

        public final void setFormatVersion(String formatVersion) {
            this.formatVersion = formatVersion;
        }

        public OrcSerDe build() {
            return new OrcSerDe(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, OrcSerDe> {
        public Builder stripeSizeBytes(Integer var1);

        public Builder blockSizeBytes(Integer var1);

        public Builder rowIndexStride(Integer var1);

        public Builder enablePadding(Boolean var1);

        public Builder paddingTolerance(Double var1);

        public Builder compression(String var1);

        public Builder compression(OrcCompression var1);

        public Builder bloomFilterColumns(Collection<String> var1);

        public Builder bloomFilterColumns(String ... var1);

        public Builder bloomFilterFalsePositiveProbability(Double var1);

        public Builder dictionaryKeyThreshold(Double var1);

        public Builder formatVersion(String var1);

        public Builder formatVersion(OrcFormatVersion var1);
    }
}

