/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.firehose.model.ColumnToJsonKeyMappingsCopier;
import software.amazon.awssdk.services.firehose.transform.OpenXJsonSerDeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OpenXJsonSerDe
implements StructuredPojo,
ToCopyableBuilder<Builder, OpenXJsonSerDe> {
    private final Boolean convertDotsInJsonKeysToUnderscores;
    private final Boolean caseInsensitive;
    private final Map<String, String> columnToJsonKeyMappings;

    private OpenXJsonSerDe(BuilderImpl builder) {
        this.convertDotsInJsonKeysToUnderscores = builder.convertDotsInJsonKeysToUnderscores;
        this.caseInsensitive = builder.caseInsensitive;
        this.columnToJsonKeyMappings = builder.columnToJsonKeyMappings;
    }

    public Boolean convertDotsInJsonKeysToUnderscores() {
        return this.convertDotsInJsonKeysToUnderscores;
    }

    public Boolean caseInsensitive() {
        return this.caseInsensitive;
    }

    public Map<String, String> columnToJsonKeyMappings() {
        return this.columnToJsonKeyMappings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.convertDotsInJsonKeysToUnderscores());
        hashCode = 31 * hashCode + Objects.hashCode(this.caseInsensitive());
        hashCode = 31 * hashCode + Objects.hashCode(this.columnToJsonKeyMappings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenXJsonSerDe)) {
            return false;
        }
        OpenXJsonSerDe other = (OpenXJsonSerDe)obj;
        return Objects.equals(this.convertDotsInJsonKeysToUnderscores(), other.convertDotsInJsonKeysToUnderscores()) && Objects.equals(this.caseInsensitive(), other.caseInsensitive()) && Objects.equals(this.columnToJsonKeyMappings(), other.columnToJsonKeyMappings());
    }

    public String toString() {
        return ToString.builder((String)"OpenXJsonSerDe").add("ConvertDotsInJsonKeysToUnderscores", (Object)this.convertDotsInJsonKeysToUnderscores()).add("CaseInsensitive", (Object)this.caseInsensitive()).add("ColumnToJsonKeyMappings", this.columnToJsonKeyMappings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConvertDotsInJsonKeysToUnderscores": {
                return Optional.ofNullable(clazz.cast(this.convertDotsInJsonKeysToUnderscores()));
            }
            case "CaseInsensitive": {
                return Optional.ofNullable(clazz.cast(this.caseInsensitive()));
            }
            case "ColumnToJsonKeyMappings": {
                return Optional.ofNullable(clazz.cast(this.columnToJsonKeyMappings()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OpenXJsonSerDeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean convertDotsInJsonKeysToUnderscores;
        private Boolean caseInsensitive;
        private Map<String, String> columnToJsonKeyMappings = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OpenXJsonSerDe model) {
            this.convertDotsInJsonKeysToUnderscores(model.convertDotsInJsonKeysToUnderscores);
            this.caseInsensitive(model.caseInsensitive);
            this.columnToJsonKeyMappings(model.columnToJsonKeyMappings);
        }

        public final Boolean getConvertDotsInJsonKeysToUnderscores() {
            return this.convertDotsInJsonKeysToUnderscores;
        }

        @Override
        public final Builder convertDotsInJsonKeysToUnderscores(Boolean convertDotsInJsonKeysToUnderscores) {
            this.convertDotsInJsonKeysToUnderscores = convertDotsInJsonKeysToUnderscores;
            return this;
        }

        public final void setConvertDotsInJsonKeysToUnderscores(Boolean convertDotsInJsonKeysToUnderscores) {
            this.convertDotsInJsonKeysToUnderscores = convertDotsInJsonKeysToUnderscores;
        }

        public final Boolean getCaseInsensitive() {
            return this.caseInsensitive;
        }

        @Override
        public final Builder caseInsensitive(Boolean caseInsensitive) {
            this.caseInsensitive = caseInsensitive;
            return this;
        }

        public final void setCaseInsensitive(Boolean caseInsensitive) {
            this.caseInsensitive = caseInsensitive;
        }

        public final Map<String, String> getColumnToJsonKeyMappings() {
            return this.columnToJsonKeyMappings;
        }

        @Override
        public final Builder columnToJsonKeyMappings(Map<String, String> columnToJsonKeyMappings) {
            this.columnToJsonKeyMappings = ColumnToJsonKeyMappingsCopier.copy(columnToJsonKeyMappings);
            return this;
        }

        public final void setColumnToJsonKeyMappings(Map<String, String> columnToJsonKeyMappings) {
            this.columnToJsonKeyMappings = ColumnToJsonKeyMappingsCopier.copy(columnToJsonKeyMappings);
        }

        public OpenXJsonSerDe build() {
            return new OpenXJsonSerDe(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, OpenXJsonSerDe> {
        public Builder convertDotsInJsonKeysToUnderscores(Boolean var1);

        public Builder caseInsensitive(Boolean var1);

        public Builder columnToJsonKeyMappings(Map<String, String> var1);
    }
}

