/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.Deserializer;
import software.amazon.awssdk.services.firehose.transform.InputFormatConfigurationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputFormatConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, InputFormatConfiguration> {
    private final Deserializer deserializer;

    private InputFormatConfiguration(BuilderImpl builder) {
        this.deserializer = builder.deserializer;
    }

    public Deserializer deserializer() {
        return this.deserializer;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deserializer());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputFormatConfiguration)) {
            return false;
        }
        InputFormatConfiguration other = (InputFormatConfiguration)obj;
        return Objects.equals(this.deserializer(), other.deserializer());
    }

    public String toString() {
        return ToString.builder((String)"InputFormatConfiguration").add("Deserializer", (Object)this.deserializer()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Deserializer": {
                return Optional.ofNullable(clazz.cast(this.deserializer()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputFormatConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Deserializer deserializer;

        private BuilderImpl() {
        }

        private BuilderImpl(InputFormatConfiguration model) {
            this.deserializer(model.deserializer);
        }

        public final Deserializer.Builder getDeserializer() {
            return this.deserializer != null ? this.deserializer.toBuilder() : null;
        }

        @Override
        public final Builder deserializer(Deserializer deserializer) {
            this.deserializer = deserializer;
            return this;
        }

        public final void setDeserializer(Deserializer.BuilderImpl deserializer) {
            this.deserializer = deserializer != null ? deserializer.build() : null;
        }

        public InputFormatConfiguration build() {
            return new InputFormatConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InputFormatConfiguration> {
        public Builder deserializer(Deserializer var1);

        default public Builder deserializer(Consumer<Deserializer.Builder> deserializer) {
            return this.deserializer((Deserializer)((Deserializer.Builder)Deserializer.builder().applyMutation(deserializer)).build());
        }
    }
}

