/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.transform.ElasticsearchBufferingHintsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ElasticsearchBufferingHints
implements StructuredPojo,
ToCopyableBuilder<Builder, ElasticsearchBufferingHints> {
    private final Integer intervalInSeconds;
    private final Integer sizeInMBs;

    private ElasticsearchBufferingHints(BuilderImpl builder) {
        this.intervalInSeconds = builder.intervalInSeconds;
        this.sizeInMBs = builder.sizeInMBs;
    }

    public Integer intervalInSeconds() {
        return this.intervalInSeconds;
    }

    public Integer sizeInMBs() {
        return this.sizeInMBs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.intervalInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeInMBs());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticsearchBufferingHints)) {
            return false;
        }
        ElasticsearchBufferingHints other = (ElasticsearchBufferingHints)obj;
        return Objects.equals(this.intervalInSeconds(), other.intervalInSeconds()) && Objects.equals(this.sizeInMBs(), other.sizeInMBs());
    }

    public String toString() {
        return ToString.builder((String)"ElasticsearchBufferingHints").add("IntervalInSeconds", (Object)this.intervalInSeconds()).add("SizeInMBs", (Object)this.sizeInMBs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IntervalInSeconds": {
                return Optional.ofNullable(clazz.cast(this.intervalInSeconds()));
            }
            case "SizeInMBs": {
                return Optional.ofNullable(clazz.cast(this.sizeInMBs()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ElasticsearchBufferingHintsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer intervalInSeconds;
        private Integer sizeInMBs;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticsearchBufferingHints model) {
            this.intervalInSeconds(model.intervalInSeconds);
            this.sizeInMBs(model.sizeInMBs);
        }

        public final Integer getIntervalInSeconds() {
            return this.intervalInSeconds;
        }

        @Override
        public final Builder intervalInSeconds(Integer intervalInSeconds) {
            this.intervalInSeconds = intervalInSeconds;
            return this;
        }

        public final void setIntervalInSeconds(Integer intervalInSeconds) {
            this.intervalInSeconds = intervalInSeconds;
        }

        public final Integer getSizeInMBs() {
            return this.sizeInMBs;
        }

        @Override
        public final Builder sizeInMBs(Integer sizeInMBs) {
            this.sizeInMBs = sizeInMBs;
            return this;
        }

        public final void setSizeInMBs(Integer sizeInMBs) {
            this.sizeInMBs = sizeInMBs;
        }

        public ElasticsearchBufferingHints build() {
            return new ElasticsearchBufferingHints(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ElasticsearchBufferingHints> {
        public Builder intervalInSeconds(Integer var1);

        public Builder sizeInMBs(Integer var1);
    }
}

