/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.ElasticsearchDestinationDescription;
import software.amazon.awssdk.services.firehose.model.ExtendedS3DestinationDescription;
import software.amazon.awssdk.services.firehose.model.RedshiftDestinationDescription;
import software.amazon.awssdk.services.firehose.model.S3DestinationDescription;
import software.amazon.awssdk.services.firehose.model.SplunkDestinationDescription;
import software.amazon.awssdk.services.firehose.transform.DestinationDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DestinationDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, DestinationDescription> {
    private final String destinationId;
    private final S3DestinationDescription s3DestinationDescription;
    private final ExtendedS3DestinationDescription extendedS3DestinationDescription;
    private final RedshiftDestinationDescription redshiftDestinationDescription;
    private final ElasticsearchDestinationDescription elasticsearchDestinationDescription;
    private final SplunkDestinationDescription splunkDestinationDescription;

    private DestinationDescription(BuilderImpl builder) {
        this.destinationId = builder.destinationId;
        this.s3DestinationDescription = builder.s3DestinationDescription;
        this.extendedS3DestinationDescription = builder.extendedS3DestinationDescription;
        this.redshiftDestinationDescription = builder.redshiftDestinationDescription;
        this.elasticsearchDestinationDescription = builder.elasticsearchDestinationDescription;
        this.splunkDestinationDescription = builder.splunkDestinationDescription;
    }

    public String destinationId() {
        return this.destinationId;
    }

    public S3DestinationDescription s3DestinationDescription() {
        return this.s3DestinationDescription;
    }

    public ExtendedS3DestinationDescription extendedS3DestinationDescription() {
        return this.extendedS3DestinationDescription;
    }

    public RedshiftDestinationDescription redshiftDestinationDescription() {
        return this.redshiftDestinationDescription;
    }

    public ElasticsearchDestinationDescription elasticsearchDestinationDescription() {
        return this.elasticsearchDestinationDescription;
    }

    public SplunkDestinationDescription splunkDestinationDescription() {
        return this.splunkDestinationDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3DestinationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.extendedS3DestinationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.redshiftDestinationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticsearchDestinationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.splunkDestinationDescription());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationDescription)) {
            return false;
        }
        DestinationDescription other = (DestinationDescription)obj;
        return Objects.equals(this.destinationId(), other.destinationId()) && Objects.equals(this.s3DestinationDescription(), other.s3DestinationDescription()) && Objects.equals(this.extendedS3DestinationDescription(), other.extendedS3DestinationDescription()) && Objects.equals(this.redshiftDestinationDescription(), other.redshiftDestinationDescription()) && Objects.equals(this.elasticsearchDestinationDescription(), other.elasticsearchDestinationDescription()) && Objects.equals(this.splunkDestinationDescription(), other.splunkDestinationDescription());
    }

    public String toString() {
        return ToString.builder((String)"DestinationDescription").add("DestinationId", (Object)this.destinationId()).add("S3DestinationDescription", (Object)this.s3DestinationDescription()).add("ExtendedS3DestinationDescription", (Object)this.extendedS3DestinationDescription()).add("RedshiftDestinationDescription", (Object)this.redshiftDestinationDescription()).add("ElasticsearchDestinationDescription", (Object)this.elasticsearchDestinationDescription()).add("SplunkDestinationDescription", (Object)this.splunkDestinationDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationId": {
                return Optional.ofNullable(clazz.cast(this.destinationId()));
            }
            case "S3DestinationDescription": {
                return Optional.ofNullable(clazz.cast(this.s3DestinationDescription()));
            }
            case "ExtendedS3DestinationDescription": {
                return Optional.ofNullable(clazz.cast(this.extendedS3DestinationDescription()));
            }
            case "RedshiftDestinationDescription": {
                return Optional.ofNullable(clazz.cast(this.redshiftDestinationDescription()));
            }
            case "ElasticsearchDestinationDescription": {
                return Optional.ofNullable(clazz.cast(this.elasticsearchDestinationDescription()));
            }
            case "SplunkDestinationDescription": {
                return Optional.ofNullable(clazz.cast(this.splunkDestinationDescription()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DestinationDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String destinationId;
        private S3DestinationDescription s3DestinationDescription;
        private ExtendedS3DestinationDescription extendedS3DestinationDescription;
        private RedshiftDestinationDescription redshiftDestinationDescription;
        private ElasticsearchDestinationDescription elasticsearchDestinationDescription;
        private SplunkDestinationDescription splunkDestinationDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationDescription model) {
            this.destinationId(model.destinationId);
            this.s3DestinationDescription(model.s3DestinationDescription);
            this.extendedS3DestinationDescription(model.extendedS3DestinationDescription);
            this.redshiftDestinationDescription(model.redshiftDestinationDescription);
            this.elasticsearchDestinationDescription(model.elasticsearchDestinationDescription);
            this.splunkDestinationDescription(model.splunkDestinationDescription);
        }

        public final String getDestinationId() {
            return this.destinationId;
        }

        @Override
        public final Builder destinationId(String destinationId) {
            this.destinationId = destinationId;
            return this;
        }

        public final void setDestinationId(String destinationId) {
            this.destinationId = destinationId;
        }

        public final S3DestinationDescription.Builder getS3DestinationDescription() {
            return this.s3DestinationDescription != null ? this.s3DestinationDescription.toBuilder() : null;
        }

        @Override
        public final Builder s3DestinationDescription(S3DestinationDescription s3DestinationDescription) {
            this.s3DestinationDescription = s3DestinationDescription;
            return this;
        }

        public final void setS3DestinationDescription(S3DestinationDescription.BuilderImpl s3DestinationDescription) {
            this.s3DestinationDescription = s3DestinationDescription != null ? s3DestinationDescription.build() : null;
        }

        public final ExtendedS3DestinationDescription.Builder getExtendedS3DestinationDescription() {
            return this.extendedS3DestinationDescription != null ? this.extendedS3DestinationDescription.toBuilder() : null;
        }

        @Override
        public final Builder extendedS3DestinationDescription(ExtendedS3DestinationDescription extendedS3DestinationDescription) {
            this.extendedS3DestinationDescription = extendedS3DestinationDescription;
            return this;
        }

        public final void setExtendedS3DestinationDescription(ExtendedS3DestinationDescription.BuilderImpl extendedS3DestinationDescription) {
            this.extendedS3DestinationDescription = extendedS3DestinationDescription != null ? extendedS3DestinationDescription.build() : null;
        }

        public final RedshiftDestinationDescription.Builder getRedshiftDestinationDescription() {
            return this.redshiftDestinationDescription != null ? this.redshiftDestinationDescription.toBuilder() : null;
        }

        @Override
        public final Builder redshiftDestinationDescription(RedshiftDestinationDescription redshiftDestinationDescription) {
            this.redshiftDestinationDescription = redshiftDestinationDescription;
            return this;
        }

        public final void setRedshiftDestinationDescription(RedshiftDestinationDescription.BuilderImpl redshiftDestinationDescription) {
            this.redshiftDestinationDescription = redshiftDestinationDescription != null ? redshiftDestinationDescription.build() : null;
        }

        public final ElasticsearchDestinationDescription.Builder getElasticsearchDestinationDescription() {
            return this.elasticsearchDestinationDescription != null ? this.elasticsearchDestinationDescription.toBuilder() : null;
        }

        @Override
        public final Builder elasticsearchDestinationDescription(ElasticsearchDestinationDescription elasticsearchDestinationDescription) {
            this.elasticsearchDestinationDescription = elasticsearchDestinationDescription;
            return this;
        }

        public final void setElasticsearchDestinationDescription(ElasticsearchDestinationDescription.BuilderImpl elasticsearchDestinationDescription) {
            this.elasticsearchDestinationDescription = elasticsearchDestinationDescription != null ? elasticsearchDestinationDescription.build() : null;
        }

        public final SplunkDestinationDescription.Builder getSplunkDestinationDescription() {
            return this.splunkDestinationDescription != null ? this.splunkDestinationDescription.toBuilder() : null;
        }

        @Override
        public final Builder splunkDestinationDescription(SplunkDestinationDescription splunkDestinationDescription) {
            this.splunkDestinationDescription = splunkDestinationDescription;
            return this;
        }

        public final void setSplunkDestinationDescription(SplunkDestinationDescription.BuilderImpl splunkDestinationDescription) {
            this.splunkDestinationDescription = splunkDestinationDescription != null ? splunkDestinationDescription.build() : null;
        }

        public DestinationDescription build() {
            return new DestinationDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DestinationDescription> {
        public Builder destinationId(String var1);

        public Builder s3DestinationDescription(S3DestinationDescription var1);

        default public Builder s3DestinationDescription(Consumer<S3DestinationDescription.Builder> s3DestinationDescription) {
            return this.s3DestinationDescription((S3DestinationDescription)((S3DestinationDescription.Builder)S3DestinationDescription.builder().applyMutation(s3DestinationDescription)).build());
        }

        public Builder extendedS3DestinationDescription(ExtendedS3DestinationDescription var1);

        default public Builder extendedS3DestinationDescription(Consumer<ExtendedS3DestinationDescription.Builder> extendedS3DestinationDescription) {
            return this.extendedS3DestinationDescription((ExtendedS3DestinationDescription)((ExtendedS3DestinationDescription.Builder)ExtendedS3DestinationDescription.builder().applyMutation(extendedS3DestinationDescription)).build());
        }

        public Builder redshiftDestinationDescription(RedshiftDestinationDescription var1);

        default public Builder redshiftDestinationDescription(Consumer<RedshiftDestinationDescription.Builder> redshiftDestinationDescription) {
            return this.redshiftDestinationDescription((RedshiftDestinationDescription)((RedshiftDestinationDescription.Builder)RedshiftDestinationDescription.builder().applyMutation(redshiftDestinationDescription)).build());
        }

        public Builder elasticsearchDestinationDescription(ElasticsearchDestinationDescription var1);

        default public Builder elasticsearchDestinationDescription(Consumer<ElasticsearchDestinationDescription.Builder> elasticsearchDestinationDescription) {
            return this.elasticsearchDestinationDescription((ElasticsearchDestinationDescription)((ElasticsearchDestinationDescription.Builder)ElasticsearchDestinationDescription.builder().applyMutation(elasticsearchDestinationDescription)).build());
        }

        public Builder splunkDestinationDescription(SplunkDestinationDescription var1);

        default public Builder splunkDestinationDescription(Consumer<SplunkDestinationDescription.Builder> splunkDestinationDescription) {
            return this.splunkDestinationDescription((SplunkDestinationDescription)((SplunkDestinationDescription.Builder)SplunkDestinationDescription.builder().applyMutation(splunkDestinationDescription)).build());
        }
    }
}

