/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.HiveJsonSerDe;
import software.amazon.awssdk.services.firehose.model.OpenXJsonSerDe;
import software.amazon.awssdk.services.firehose.transform.DeserializerMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Deserializer
implements StructuredPojo,
ToCopyableBuilder<Builder, Deserializer> {
    private final OpenXJsonSerDe openXJsonSerDe;
    private final HiveJsonSerDe hiveJsonSerDe;

    private Deserializer(BuilderImpl builder) {
        this.openXJsonSerDe = builder.openXJsonSerDe;
        this.hiveJsonSerDe = builder.hiveJsonSerDe;
    }

    public OpenXJsonSerDe openXJsonSerDe() {
        return this.openXJsonSerDe;
    }

    public HiveJsonSerDe hiveJsonSerDe() {
        return this.hiveJsonSerDe;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.openXJsonSerDe());
        hashCode = 31 * hashCode + Objects.hashCode(this.hiveJsonSerDe());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Deserializer)) {
            return false;
        }
        Deserializer other = (Deserializer)obj;
        return Objects.equals(this.openXJsonSerDe(), other.openXJsonSerDe()) && Objects.equals(this.hiveJsonSerDe(), other.hiveJsonSerDe());
    }

    public String toString() {
        return ToString.builder((String)"Deserializer").add("OpenXJsonSerDe", (Object)this.openXJsonSerDe()).add("HiveJsonSerDe", (Object)this.hiveJsonSerDe()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OpenXJsonSerDe": {
                return Optional.ofNullable(clazz.cast(this.openXJsonSerDe()));
            }
            case "HiveJsonSerDe": {
                return Optional.ofNullable(clazz.cast(this.hiveJsonSerDe()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeserializerMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private OpenXJsonSerDe openXJsonSerDe;
        private HiveJsonSerDe hiveJsonSerDe;

        private BuilderImpl() {
        }

        private BuilderImpl(Deserializer model) {
            this.openXJsonSerDe(model.openXJsonSerDe);
            this.hiveJsonSerDe(model.hiveJsonSerDe);
        }

        public final OpenXJsonSerDe.Builder getOpenXJsonSerDe() {
            return this.openXJsonSerDe != null ? this.openXJsonSerDe.toBuilder() : null;
        }

        @Override
        public final Builder openXJsonSerDe(OpenXJsonSerDe openXJsonSerDe) {
            this.openXJsonSerDe = openXJsonSerDe;
            return this;
        }

        public final void setOpenXJsonSerDe(OpenXJsonSerDe.BuilderImpl openXJsonSerDe) {
            this.openXJsonSerDe = openXJsonSerDe != null ? openXJsonSerDe.build() : null;
        }

        public final HiveJsonSerDe.Builder getHiveJsonSerDe() {
            return this.hiveJsonSerDe != null ? this.hiveJsonSerDe.toBuilder() : null;
        }

        @Override
        public final Builder hiveJsonSerDe(HiveJsonSerDe hiveJsonSerDe) {
            this.hiveJsonSerDe = hiveJsonSerDe;
            return this;
        }

        public final void setHiveJsonSerDe(HiveJsonSerDe.BuilderImpl hiveJsonSerDe) {
            this.hiveJsonSerDe = hiveJsonSerDe != null ? hiveJsonSerDe.build() : null;
        }

        public Deserializer build() {
            return new Deserializer(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Deserializer> {
        public Builder openXJsonSerDe(OpenXJsonSerDe var1);

        default public Builder openXJsonSerDe(Consumer<OpenXJsonSerDe.Builder> openXJsonSerDe) {
            return this.openXJsonSerDe((OpenXJsonSerDe)((OpenXJsonSerDe.Builder)OpenXJsonSerDe.builder().applyMutation(openXJsonSerDe)).build());
        }

        public Builder hiveJsonSerDe(HiveJsonSerDe var1);

        default public Builder hiveJsonSerDe(Consumer<HiveJsonSerDe.Builder> hiveJsonSerDe) {
            return this.hiveJsonSerDe((HiveJsonSerDe)((HiveJsonSerDe.Builder)HiveJsonSerDe.builder().applyMutation(hiveJsonSerDe)).build());
        }
    }
}

