/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.protocol.json.AwsJsonProtocol;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.http.JsonResponseHandler;
import software.amazon.awssdk.core.internal.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.firehose.FirehoseClient;
import software.amazon.awssdk.services.firehose.model.ConcurrentModificationException;
import software.amazon.awssdk.services.firehose.model.CreateDeliveryStreamRequest;
import software.amazon.awssdk.services.firehose.model.CreateDeliveryStreamResponse;
import software.amazon.awssdk.services.firehose.model.DeleteDeliveryStreamRequest;
import software.amazon.awssdk.services.firehose.model.DeleteDeliveryStreamResponse;
import software.amazon.awssdk.services.firehose.model.DescribeDeliveryStreamRequest;
import software.amazon.awssdk.services.firehose.model.DescribeDeliveryStreamResponse;
import software.amazon.awssdk.services.firehose.model.FirehoseException;
import software.amazon.awssdk.services.firehose.model.InvalidArgumentException;
import software.amazon.awssdk.services.firehose.model.LimitExceededException;
import software.amazon.awssdk.services.firehose.model.ListDeliveryStreamsRequest;
import software.amazon.awssdk.services.firehose.model.ListDeliveryStreamsResponse;
import software.amazon.awssdk.services.firehose.model.ListTagsForDeliveryStreamRequest;
import software.amazon.awssdk.services.firehose.model.ListTagsForDeliveryStreamResponse;
import software.amazon.awssdk.services.firehose.model.PutRecordBatchRequest;
import software.amazon.awssdk.services.firehose.model.PutRecordBatchResponse;
import software.amazon.awssdk.services.firehose.model.PutRecordRequest;
import software.amazon.awssdk.services.firehose.model.PutRecordResponse;
import software.amazon.awssdk.services.firehose.model.ResourceInUseException;
import software.amazon.awssdk.services.firehose.model.ResourceNotFoundException;
import software.amazon.awssdk.services.firehose.model.ServiceUnavailableException;
import software.amazon.awssdk.services.firehose.model.TagDeliveryStreamRequest;
import software.amazon.awssdk.services.firehose.model.TagDeliveryStreamResponse;
import software.amazon.awssdk.services.firehose.model.UntagDeliveryStreamRequest;
import software.amazon.awssdk.services.firehose.model.UntagDeliveryStreamResponse;
import software.amazon.awssdk.services.firehose.model.UpdateDestinationRequest;
import software.amazon.awssdk.services.firehose.model.UpdateDestinationResponse;
import software.amazon.awssdk.services.firehose.transform.CreateDeliveryStreamRequestMarshaller;
import software.amazon.awssdk.services.firehose.transform.CreateDeliveryStreamResponseUnmarshaller;
import software.amazon.awssdk.services.firehose.transform.DeleteDeliveryStreamRequestMarshaller;
import software.amazon.awssdk.services.firehose.transform.DeleteDeliveryStreamResponseUnmarshaller;
import software.amazon.awssdk.services.firehose.transform.DescribeDeliveryStreamRequestMarshaller;
import software.amazon.awssdk.services.firehose.transform.DescribeDeliveryStreamResponseUnmarshaller;
import software.amazon.awssdk.services.firehose.transform.ListDeliveryStreamsRequestMarshaller;
import software.amazon.awssdk.services.firehose.transform.ListDeliveryStreamsResponseUnmarshaller;
import software.amazon.awssdk.services.firehose.transform.ListTagsForDeliveryStreamRequestMarshaller;
import software.amazon.awssdk.services.firehose.transform.ListTagsForDeliveryStreamResponseUnmarshaller;
import software.amazon.awssdk.services.firehose.transform.PutRecordBatchRequestMarshaller;
import software.amazon.awssdk.services.firehose.transform.PutRecordBatchResponseUnmarshaller;
import software.amazon.awssdk.services.firehose.transform.PutRecordRequestMarshaller;
import software.amazon.awssdk.services.firehose.transform.PutRecordResponseUnmarshaller;
import software.amazon.awssdk.services.firehose.transform.TagDeliveryStreamRequestMarshaller;
import software.amazon.awssdk.services.firehose.transform.TagDeliveryStreamResponseUnmarshaller;
import software.amazon.awssdk.services.firehose.transform.UntagDeliveryStreamRequestMarshaller;
import software.amazon.awssdk.services.firehose.transform.UntagDeliveryStreamResponseUnmarshaller;
import software.amazon.awssdk.services.firehose.transform.UpdateDestinationRequestMarshaller;
import software.amazon.awssdk.services.firehose.transform.UpdateDestinationResponseUnmarshaller;

@SdkInternalApi
final class DefaultFirehoseClient
implements FirehoseClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultFirehoseClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(false);
    }

    public final String serviceName() {
        return "firehose";
    }

    @Override
    public CreateDeliveryStreamResponse createDeliveryStream(CreateDeliveryStreamRequest createDeliveryStreamRequest) throws InvalidArgumentException, LimitExceededException, ResourceInUseException, AwsServiceException, SdkClientException, FirehoseException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateDeliveryStreamResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (CreateDeliveryStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDeliveryStreamRequest).withMarshaller((Marshaller)new CreateDeliveryStreamRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteDeliveryStreamResponse deleteDeliveryStream(DeleteDeliveryStreamRequest deleteDeliveryStreamRequest) throws ResourceInUseException, ResourceNotFoundException, AwsServiceException, SdkClientException, FirehoseException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteDeliveryStreamResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DeleteDeliveryStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDeliveryStreamRequest).withMarshaller((Marshaller)new DeleteDeliveryStreamRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeDeliveryStreamResponse describeDeliveryStream(DescribeDeliveryStreamRequest describeDeliveryStreamRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, FirehoseException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeDeliveryStreamResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DescribeDeliveryStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDeliveryStreamRequest).withMarshaller((Marshaller)new DescribeDeliveryStreamRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListDeliveryStreamsResponse listDeliveryStreams(ListDeliveryStreamsRequest listDeliveryStreamsRequest) throws AwsServiceException, SdkClientException, FirehoseException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListDeliveryStreamsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ListDeliveryStreamsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDeliveryStreamsRequest).withMarshaller((Marshaller)new ListDeliveryStreamsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListTagsForDeliveryStreamResponse listTagsForDeliveryStream(ListTagsForDeliveryStreamRequest listTagsForDeliveryStreamRequest) throws ResourceNotFoundException, InvalidArgumentException, LimitExceededException, AwsServiceException, SdkClientException, FirehoseException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForDeliveryStreamResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ListTagsForDeliveryStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForDeliveryStreamRequest).withMarshaller((Marshaller)new ListTagsForDeliveryStreamRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public PutRecordResponse putRecord(PutRecordRequest putRecordRequest) throws ResourceNotFoundException, InvalidArgumentException, ServiceUnavailableException, AwsServiceException, SdkClientException, FirehoseException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutRecordResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (PutRecordResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putRecordRequest).withMarshaller((Marshaller)new PutRecordRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public PutRecordBatchResponse putRecordBatch(PutRecordBatchRequest putRecordBatchRequest) throws ResourceNotFoundException, InvalidArgumentException, ServiceUnavailableException, AwsServiceException, SdkClientException, FirehoseException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutRecordBatchResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (PutRecordBatchResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putRecordBatchRequest).withMarshaller((Marshaller)new PutRecordBatchRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public TagDeliveryStreamResponse tagDeliveryStream(TagDeliveryStreamRequest tagDeliveryStreamRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, LimitExceededException, AwsServiceException, SdkClientException, FirehoseException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagDeliveryStreamResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (TagDeliveryStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagDeliveryStreamRequest).withMarshaller((Marshaller)new TagDeliveryStreamRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UntagDeliveryStreamResponse untagDeliveryStream(UntagDeliveryStreamRequest untagDeliveryStreamRequest) throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, LimitExceededException, AwsServiceException, SdkClientException, FirehoseException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagDeliveryStreamResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (UntagDeliveryStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagDeliveryStreamRequest).withMarshaller((Marshaller)new UntagDeliveryStreamRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateDestinationResponse updateDestination(UpdateDestinationRequest updateDestinationRequest) throws InvalidArgumentException, ResourceInUseException, ResourceNotFoundException, ConcurrentModificationException, AwsServiceException, SdkClientException, FirehoseException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateDestinationResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (UpdateDestinationResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateDestinationRequest).withMarshaller((Marshaller)new UpdateDestinationRequestMarshaller(this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(AwsJsonProtocolFactory protocolFactory) {
        return protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private AwsJsonProtocolFactory init(boolean supportsCbor) {
        return new AwsJsonProtocolFactory(new JsonClientMetadata().withSupportsCbor(supportsCbor).withSupportsIon(false).withBaseServiceExceptionClass(FirehoseException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConcurrentModificationException").withModeledClass(ConcurrentModificationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidArgumentException").withModeledClass(InvalidArgumentException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceInUseException").withModeledClass(ResourceInUseException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceUnavailableException").withModeledClass(ServiceUnavailableException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)), AwsJsonProtocolMetadata.builder().protocolVersion("1.1").protocol(AwsJsonProtocol.AWS_JSON).build());
    }

    public void close() {
        this.clientHandler.close();
    }
}

