/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.finspacedata.model.Credentials;
import software.amazon.awssdk.services.finspacedata.model.FinspaceDataResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetProgrammaticAccessCredentialsResponse
extends FinspaceDataResponse
implements ToCopyableBuilder<Builder, GetProgrammaticAccessCredentialsResponse> {
    private static final SdkField<Credentials> CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("credentials").getter(GetProgrammaticAccessCredentialsResponse.getter(GetProgrammaticAccessCredentialsResponse::credentials)).setter(GetProgrammaticAccessCredentialsResponse.setter(Builder::credentials)).constructor(Credentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentials").build()}).build();
    private static final SdkField<Long> DURATION_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("durationInMinutes").getter(GetProgrammaticAccessCredentialsResponse.getter(GetProgrammaticAccessCredentialsResponse::durationInMinutes)).setter(GetProgrammaticAccessCredentialsResponse.setter(Builder::durationInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durationInMinutes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREDENTIALS_FIELD, DURATION_IN_MINUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetProgrammaticAccessCredentialsResponse.memberNameToFieldInitializer();
    private final Credentials credentials;
    private final Long durationInMinutes;

    private GetProgrammaticAccessCredentialsResponse(BuilderImpl builder) {
        super(builder);
        this.credentials = builder.credentials;
        this.durationInMinutes = builder.durationInMinutes;
    }

    public final Credentials credentials() {
        return this.credentials;
    }

    public final Long durationInMinutes() {
        return this.durationInMinutes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.credentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationInMinutes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProgrammaticAccessCredentialsResponse)) {
            return false;
        }
        GetProgrammaticAccessCredentialsResponse other = (GetProgrammaticAccessCredentialsResponse)((Object)obj);
        return Objects.equals(this.credentials(), other.credentials()) && Objects.equals(this.durationInMinutes(), other.durationInMinutes());
    }

    public final String toString() {
        return ToString.builder((String)"GetProgrammaticAccessCredentialsResponse").add("Credentials", (Object)(this.credentials() == null ? null : "*** Sensitive Data Redacted ***")).add("DurationInMinutes", (Object)this.durationInMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "credentials": {
                return Optional.ofNullable(clazz.cast(this.credentials()));
            }
            case "durationInMinutes": {
                return Optional.ofNullable(clazz.cast(this.durationInMinutes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("credentials", CREDENTIALS_FIELD);
        map.put("durationInMinutes", DURATION_IN_MINUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetProgrammaticAccessCredentialsResponse, T> g) {
        return obj -> g.apply((GetProgrammaticAccessCredentialsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceDataResponse.BuilderImpl
    implements Builder {
        private Credentials credentials;
        private Long durationInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(GetProgrammaticAccessCredentialsResponse model) {
            super(model);
            this.credentials(model.credentials);
            this.durationInMinutes(model.durationInMinutes);
        }

        public final Credentials.Builder getCredentials() {
            return this.credentials != null ? this.credentials.toBuilder() : null;
        }

        public final void setCredentials(Credentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public final Builder credentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final Long getDurationInMinutes() {
            return this.durationInMinutes;
        }

        public final void setDurationInMinutes(Long durationInMinutes) {
            this.durationInMinutes = durationInMinutes;
        }

        @Override
        public final Builder durationInMinutes(Long durationInMinutes) {
            this.durationInMinutes = durationInMinutes;
            return this;
        }

        @Override
        public GetProgrammaticAccessCredentialsResponse build() {
            return new GetProgrammaticAccessCredentialsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends FinspaceDataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetProgrammaticAccessCredentialsResponse> {
        public Builder credentials(Credentials var1);

        default public Builder credentials(Consumer<Credentials.Builder> credentials) {
            return this.credentials((Credentials)((Credentials.Builder)Credentials.builder().applyMutation(credentials)).build());
        }

        public Builder durationInMinutes(Long var1);
    }
}

