/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.finspacedata.model.FinspaceDataResponse;
import software.amazon.awssdk.services.finspacedata.model.UserByPermissionGroup;
import software.amazon.awssdk.services.finspacedata.model.UserByPermissionGroupListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListUsersByPermissionGroupResponse
extends FinspaceDataResponse
implements ToCopyableBuilder<Builder, ListUsersByPermissionGroupResponse> {
    private static final SdkField<List<UserByPermissionGroup>> USERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("users").getter(ListUsersByPermissionGroupResponse.getter(ListUsersByPermissionGroupResponse::users)).setter(ListUsersByPermissionGroupResponse.setter(Builder::users)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("users").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserByPermissionGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListUsersByPermissionGroupResponse.getter(ListUsersByPermissionGroupResponse::nextToken)).setter(ListUsersByPermissionGroupResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USERS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListUsersByPermissionGroupResponse.memberNameToFieldInitializer();
    private final List<UserByPermissionGroup> users;
    private final String nextToken;

    private ListUsersByPermissionGroupResponse(BuilderImpl builder) {
        super(builder);
        this.users = builder.users;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasUsers() {
        return this.users != null && !(this.users instanceof SdkAutoConstructList);
    }

    public final List<UserByPermissionGroup> users() {
        return this.users;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUsers() ? this.users() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUsersByPermissionGroupResponse)) {
            return false;
        }
        ListUsersByPermissionGroupResponse other = (ListUsersByPermissionGroupResponse)((Object)obj);
        return this.hasUsers() == other.hasUsers() && Objects.equals(this.users(), other.users()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListUsersByPermissionGroupResponse").add("Users", this.hasUsers() ? this.users() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "users": {
                return Optional.ofNullable(clazz.cast(this.users()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("users", USERS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListUsersByPermissionGroupResponse, T> g) {
        return obj -> g.apply((ListUsersByPermissionGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceDataResponse.BuilderImpl
    implements Builder {
        private List<UserByPermissionGroup> users = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUsersByPermissionGroupResponse model) {
            super(model);
            this.users(model.users);
            this.nextToken(model.nextToken);
        }

        public final List<UserByPermissionGroup.Builder> getUsers() {
            List<UserByPermissionGroup.Builder> result = UserByPermissionGroupListCopier.copyToBuilder(this.users);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUsers(Collection<UserByPermissionGroup.BuilderImpl> users) {
            this.users = UserByPermissionGroupListCopier.copyFromBuilder(users);
        }

        @Override
        public final Builder users(Collection<UserByPermissionGroup> users) {
            this.users = UserByPermissionGroupListCopier.copy(users);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(UserByPermissionGroup ... users) {
            this.users(Arrays.asList(users));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(Consumer<UserByPermissionGroup.Builder> ... users) {
            this.users(Stream.of(users).map(c -> (UserByPermissionGroup)((UserByPermissionGroup.Builder)UserByPermissionGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListUsersByPermissionGroupResponse build() {
            return new ListUsersByPermissionGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FinspaceDataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListUsersByPermissionGroupResponse> {
        public Builder users(Collection<UserByPermissionGroup> var1);

        public Builder users(UserByPermissionGroup ... var1);

        public Builder users(Consumer<UserByPermissionGroup.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

