/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.finspacedata.model.ChangeType;
import software.amazon.awssdk.services.finspacedata.model.FinspaceDataRequest;
import software.amazon.awssdk.services.finspacedata.model.FormatParamsCopier;
import software.amazon.awssdk.services.finspacedata.model.SourceParamsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateChangesetRequest
extends FinspaceDataRequest
implements ToCopyableBuilder<Builder, CreateChangesetRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateChangesetRequest.getter(CreateChangesetRequest::clientToken)).setter(CreateChangesetRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DATASET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetId").getter(CreateChangesetRequest.getter(CreateChangesetRequest::datasetId)).setter(CreateChangesetRequest.setter(Builder::datasetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("datasetId").build()}).build();
    private static final SdkField<String> CHANGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("changeType").getter(CreateChangesetRequest.getter(CreateChangesetRequest::changeTypeAsString)).setter(CreateChangesetRequest.setter(Builder::changeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changeType").build()}).build();
    private static final SdkField<Map<String, String>> SOURCE_PARAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("sourceParams").getter(CreateChangesetRequest.getter(CreateChangesetRequest::sourceParams)).setter(CreateChangesetRequest.setter(Builder::sourceParams)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceParams").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> FORMAT_PARAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("formatParams").getter(CreateChangesetRequest.getter(CreateChangesetRequest::formatParams)).setter(CreateChangesetRequest.setter(Builder::formatParams)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formatParams").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DATASET_ID_FIELD, CHANGE_TYPE_FIELD, SOURCE_PARAMS_FIELD, FORMAT_PARAMS_FIELD));
    private final String clientToken;
    private final String datasetId;
    private final String changeType;
    private final Map<String, String> sourceParams;
    private final Map<String, String> formatParams;

    private CreateChangesetRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.datasetId = builder.datasetId;
        this.changeType = builder.changeType;
        this.sourceParams = builder.sourceParams;
        this.formatParams = builder.formatParams;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String datasetId() {
        return this.datasetId;
    }

    public final ChangeType changeType() {
        return ChangeType.fromValue(this.changeType);
    }

    public final String changeTypeAsString() {
        return this.changeType;
    }

    public final boolean hasSourceParams() {
        return this.sourceParams != null && !(this.sourceParams instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> sourceParams() {
        return this.sourceParams;
    }

    public final boolean hasFormatParams() {
        return this.formatParams != null && !(this.formatParams instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> formatParams() {
        return this.formatParams;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceParams() ? this.sourceParams() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFormatParams() ? this.formatParams() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChangesetRequest)) {
            return false;
        }
        CreateChangesetRequest other = (CreateChangesetRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.datasetId(), other.datasetId()) && Objects.equals(this.changeTypeAsString(), other.changeTypeAsString()) && this.hasSourceParams() == other.hasSourceParams() && Objects.equals(this.sourceParams(), other.sourceParams()) && this.hasFormatParams() == other.hasFormatParams() && Objects.equals(this.formatParams(), other.formatParams());
    }

    public final String toString() {
        return ToString.builder((String)"CreateChangesetRequest").add("ClientToken", (Object)this.clientToken()).add("DatasetId", (Object)this.datasetId()).add("ChangeType", (Object)this.changeTypeAsString()).add("SourceParams", this.hasSourceParams() ? this.sourceParams() : null).add("FormatParams", this.hasFormatParams() ? this.formatParams() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "datasetId": {
                return Optional.ofNullable(clazz.cast(this.datasetId()));
            }
            case "changeType": {
                return Optional.ofNullable(clazz.cast(this.changeTypeAsString()));
            }
            case "sourceParams": {
                return Optional.ofNullable(clazz.cast(this.sourceParams()));
            }
            case "formatParams": {
                return Optional.ofNullable(clazz.cast(this.formatParams()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateChangesetRequest, T> g) {
        return obj -> g.apply((CreateChangesetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceDataRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String datasetId;
        private String changeType;
        private Map<String, String> sourceParams = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> formatParams = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChangesetRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.datasetId(model.datasetId);
            this.changeType(model.changeType);
            this.sourceParams(model.sourceParams);
            this.formatParams(model.formatParams);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDatasetId() {
            return this.datasetId;
        }

        public final void setDatasetId(String datasetId) {
            this.datasetId = datasetId;
        }

        @Override
        public final Builder datasetId(String datasetId) {
            this.datasetId = datasetId;
            return this;
        }

        public final String getChangeType() {
            return this.changeType;
        }

        public final void setChangeType(String changeType) {
            this.changeType = changeType;
        }

        @Override
        public final Builder changeType(String changeType) {
            this.changeType = changeType;
            return this;
        }

        @Override
        public final Builder changeType(ChangeType changeType) {
            this.changeType(changeType == null ? null : changeType.toString());
            return this;
        }

        public final Map<String, String> getSourceParams() {
            if (this.sourceParams instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.sourceParams;
        }

        public final void setSourceParams(Map<String, String> sourceParams) {
            this.sourceParams = SourceParamsCopier.copy(sourceParams);
        }

        @Override
        public final Builder sourceParams(Map<String, String> sourceParams) {
            this.sourceParams = SourceParamsCopier.copy(sourceParams);
            return this;
        }

        public final Map<String, String> getFormatParams() {
            if (this.formatParams instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.formatParams;
        }

        public final void setFormatParams(Map<String, String> formatParams) {
            this.formatParams = FormatParamsCopier.copy(formatParams);
        }

        @Override
        public final Builder formatParams(Map<String, String> formatParams) {
            this.formatParams = FormatParamsCopier.copy(formatParams);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateChangesetRequest build() {
            return new CreateChangesetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FinspaceDataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateChangesetRequest> {
        public Builder clientToken(String var1);

        public Builder datasetId(String var1);

        public Builder changeType(String var1);

        public Builder changeType(ChangeType var1);

        public Builder sourceParams(Map<String, String> var1);

        public Builder formatParams(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

