/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ChangeType {
    REPLACE("REPLACE"),
    APPEND("APPEND"),
    MODIFY("MODIFY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ChangeType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ChangeType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ChangeType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ChangeType> knownValues() {
        return Stream.of(ChangeType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

