/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.finspacedata.model.FinspaceDataResponse;
import software.amazon.awssdk.services.finspacedata.model.PermissionGroup;
import software.amazon.awssdk.services.finspacedata.model.PermissionGroupListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPermissionGroupsResponse
extends FinspaceDataResponse
implements ToCopyableBuilder<Builder, ListPermissionGroupsResponse> {
    private static final SdkField<List<PermissionGroup>> PERMISSION_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("permissionGroups").getter(ListPermissionGroupsResponse.getter(ListPermissionGroupsResponse::permissionGroups)).setter(ListPermissionGroupsResponse.setter(Builder::permissionGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PermissionGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListPermissionGroupsResponse.getter(ListPermissionGroupsResponse::nextToken)).setter(ListPermissionGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERMISSION_GROUPS_FIELD, NEXT_TOKEN_FIELD));
    private final List<PermissionGroup> permissionGroups;
    private final String nextToken;

    private ListPermissionGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.permissionGroups = builder.permissionGroups;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPermissionGroups() {
        return this.permissionGroups != null && !(this.permissionGroups instanceof SdkAutoConstructList);
    }

    public final List<PermissionGroup> permissionGroups() {
        return this.permissionGroups;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPermissionGroups() ? this.permissionGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPermissionGroupsResponse)) {
            return false;
        }
        ListPermissionGroupsResponse other = (ListPermissionGroupsResponse)((Object)obj);
        return this.hasPermissionGroups() == other.hasPermissionGroups() && Objects.equals(this.permissionGroups(), other.permissionGroups()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPermissionGroupsResponse").add("PermissionGroups", this.hasPermissionGroups() ? this.permissionGroups() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "permissionGroups": {
                return Optional.ofNullable(clazz.cast(this.permissionGroups()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPermissionGroupsResponse, T> g) {
        return obj -> g.apply((ListPermissionGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceDataResponse.BuilderImpl
    implements Builder {
        private List<PermissionGroup> permissionGroups = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPermissionGroupsResponse model) {
            super(model);
            this.permissionGroups(model.permissionGroups);
            this.nextToken(model.nextToken);
        }

        public final List<PermissionGroup.Builder> getPermissionGroups() {
            List<PermissionGroup.Builder> result = PermissionGroupListCopier.copyToBuilder(this.permissionGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPermissionGroups(Collection<PermissionGroup.BuilderImpl> permissionGroups) {
            this.permissionGroups = PermissionGroupListCopier.copyFromBuilder(permissionGroups);
        }

        @Override
        @Transient
        public final Builder permissionGroups(Collection<PermissionGroup> permissionGroups) {
            this.permissionGroups = PermissionGroupListCopier.copy(permissionGroups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder permissionGroups(PermissionGroup ... permissionGroups) {
            this.permissionGroups(Arrays.asList(permissionGroups));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder permissionGroups(Consumer<PermissionGroup.Builder> ... permissionGroups) {
            this.permissionGroups(Stream.of(permissionGroups).map(c -> (PermissionGroup)((PermissionGroup.Builder)PermissionGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPermissionGroupsResponse build() {
            return new ListPermissionGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FinspaceDataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPermissionGroupsResponse> {
        public Builder permissionGroups(Collection<PermissionGroup> var1);

        public Builder permissionGroups(PermissionGroup ... var1);

        public Builder permissionGroups(Consumer<PermissionGroup.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

