/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.finspacedata.model.ColumnDefinition;
import software.amazon.awssdk.services.finspacedata.model.ColumnListCopier;
import software.amazon.awssdk.services.finspacedata.model.ColumnNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SchemaDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SchemaDefinition> {
    private static final SdkField<List<ColumnDefinition>> COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("columns").getter(SchemaDefinition.getter(SchemaDefinition::columns)).setter(SchemaDefinition.setter(Builder::columns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColumnDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PRIMARY_KEY_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("primaryKeyColumns").getter(SchemaDefinition.getter(SchemaDefinition::primaryKeyColumns)).setter(SchemaDefinition.setter(Builder::primaryKeyColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("primaryKeyColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMNS_FIELD, PRIMARY_KEY_COLUMNS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<ColumnDefinition> columns;
    private final List<String> primaryKeyColumns;

    private SchemaDefinition(BuilderImpl builder) {
        this.columns = builder.columns;
        this.primaryKeyColumns = builder.primaryKeyColumns;
    }

    public final boolean hasColumns() {
        return this.columns != null && !(this.columns instanceof SdkAutoConstructList);
    }

    public final List<ColumnDefinition> columns() {
        return this.columns;
    }

    public final boolean hasPrimaryKeyColumns() {
        return this.primaryKeyColumns != null && !(this.primaryKeyColumns instanceof SdkAutoConstructList);
    }

    public final List<String> primaryKeyColumns() {
        return this.primaryKeyColumns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumns() ? this.columns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrimaryKeyColumns() ? this.primaryKeyColumns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaDefinition)) {
            return false;
        }
        SchemaDefinition other = (SchemaDefinition)obj;
        return this.hasColumns() == other.hasColumns() && Objects.equals(this.columns(), other.columns()) && this.hasPrimaryKeyColumns() == other.hasPrimaryKeyColumns() && Objects.equals(this.primaryKeyColumns(), other.primaryKeyColumns());
    }

    public final String toString() {
        return ToString.builder((String)"SchemaDefinition").add("Columns", this.hasColumns() ? this.columns() : null).add("PrimaryKeyColumns", this.hasPrimaryKeyColumns() ? this.primaryKeyColumns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "columns": {
                return Optional.ofNullable(clazz.cast(this.columns()));
            }
            case "primaryKeyColumns": {
                return Optional.ofNullable(clazz.cast(this.primaryKeyColumns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SchemaDefinition, T> g) {
        return obj -> g.apply((SchemaDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ColumnDefinition> columns = DefaultSdkAutoConstructList.getInstance();
        private List<String> primaryKeyColumns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SchemaDefinition model) {
            this.columns(model.columns);
            this.primaryKeyColumns(model.primaryKeyColumns);
        }

        public final List<ColumnDefinition.Builder> getColumns() {
            List<ColumnDefinition.Builder> result = ColumnListCopier.copyToBuilder(this.columns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumns(Collection<ColumnDefinition.BuilderImpl> columns) {
            this.columns = ColumnListCopier.copyFromBuilder(columns);
        }

        @Override
        @Transient
        public final Builder columns(Collection<ColumnDefinition> columns) {
            this.columns = ColumnListCopier.copy(columns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder columns(ColumnDefinition ... columns) {
            this.columns(Arrays.asList(columns));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder columns(Consumer<ColumnDefinition.Builder> ... columns) {
            this.columns(Stream.of(columns).map(c -> (ColumnDefinition)((ColumnDefinition.Builder)ColumnDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getPrimaryKeyColumns() {
            if (this.primaryKeyColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.primaryKeyColumns;
        }

        public final void setPrimaryKeyColumns(Collection<String> primaryKeyColumns) {
            this.primaryKeyColumns = ColumnNameListCopier.copy(primaryKeyColumns);
        }

        @Override
        @Transient
        public final Builder primaryKeyColumns(Collection<String> primaryKeyColumns) {
            this.primaryKeyColumns = ColumnNameListCopier.copy(primaryKeyColumns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder primaryKeyColumns(String ... primaryKeyColumns) {
            this.primaryKeyColumns(Arrays.asList(primaryKeyColumns));
            return this;
        }

        public SchemaDefinition build() {
            return new SchemaDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SchemaDefinition> {
        public Builder columns(Collection<ColumnDefinition> var1);

        public Builder columns(ColumnDefinition ... var1);

        public Builder columns(Consumer<ColumnDefinition.Builder> ... var1);

        public Builder primaryKeyColumns(Collection<String> var1);

        public Builder primaryKeyColumns(String ... var1);
    }
}

