/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.finspacedata.DefaultFinspaceDataAsyncClientBuilder;
import software.amazon.awssdk.services.finspacedata.FinspaceDataAsyncClientBuilder;
import software.amazon.awssdk.services.finspacedata.model.CreateChangesetRequest;
import software.amazon.awssdk.services.finspacedata.model.CreateChangesetResponse;
import software.amazon.awssdk.services.finspacedata.model.GetProgrammaticAccessCredentialsRequest;
import software.amazon.awssdk.services.finspacedata.model.GetProgrammaticAccessCredentialsResponse;
import software.amazon.awssdk.services.finspacedata.model.GetWorkingLocationRequest;
import software.amazon.awssdk.services.finspacedata.model.GetWorkingLocationResponse;

@SdkPublicApi
@ThreadSafe
public interface FinspaceDataAsyncClient
extends SdkClient {
    public static final String SERVICE_NAME = "finspace-api";
    public static final String SERVICE_METADATA_ID = "finspace-api";

    public static FinspaceDataAsyncClient create() {
        return (FinspaceDataAsyncClient)FinspaceDataAsyncClient.builder().build();
    }

    public static FinspaceDataAsyncClientBuilder builder() {
        return new DefaultFinspaceDataAsyncClientBuilder();
    }

    default public CompletableFuture<CreateChangesetResponse> createChangeset(CreateChangesetRequest createChangesetRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<CreateChangesetResponse> createChangeset(Consumer<CreateChangesetRequest.Builder> createChangesetRequest) {
        return this.createChangeset((CreateChangesetRequest)((Object)((CreateChangesetRequest.Builder)CreateChangesetRequest.builder().applyMutation(createChangesetRequest)).build()));
    }

    default public CompletableFuture<GetProgrammaticAccessCredentialsResponse> getProgrammaticAccessCredentials(GetProgrammaticAccessCredentialsRequest getProgrammaticAccessCredentialsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetProgrammaticAccessCredentialsResponse> getProgrammaticAccessCredentials(Consumer<GetProgrammaticAccessCredentialsRequest.Builder> getProgrammaticAccessCredentialsRequest) {
        return this.getProgrammaticAccessCredentials((GetProgrammaticAccessCredentialsRequest)((Object)((GetProgrammaticAccessCredentialsRequest.Builder)GetProgrammaticAccessCredentialsRequest.builder().applyMutation(getProgrammaticAccessCredentialsRequest)).build()));
    }

    default public CompletableFuture<GetWorkingLocationResponse> getWorkingLocation(GetWorkingLocationRequest getWorkingLocationRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetWorkingLocationResponse> getWorkingLocation(Consumer<GetWorkingLocationRequest.Builder> getWorkingLocationRequest) {
        return this.getWorkingLocation((GetWorkingLocationRequest)((Object)((GetWorkingLocationRequest.Builder)GetWorkingLocationRequest.builder().applyMutation(getWorkingLocationRequest)).build()));
    }
}

