/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.finspace.model.EnvironmentStatus;
import software.amazon.awssdk.services.finspace.model.FinspaceResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateKxEnvironmentResponse
extends FinspaceResponse
implements ToCopyableBuilder<Builder, CreateKxEnvironmentResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateKxEnvironmentResponse.getter(CreateKxEnvironmentResponse::name)).setter(CreateKxEnvironmentResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CreateKxEnvironmentResponse.getter(CreateKxEnvironmentResponse::statusAsString)).setter(CreateKxEnvironmentResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentId").getter(CreateKxEnvironmentResponse.getter(CreateKxEnvironmentResponse::environmentId)).setter(CreateKxEnvironmentResponse.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateKxEnvironmentResponse.getter(CreateKxEnvironmentResponse::description)).setter(CreateKxEnvironmentResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentArn").getter(CreateKxEnvironmentResponse.getter(CreateKxEnvironmentResponse::environmentArn)).setter(CreateKxEnvironmentResponse.setter(Builder::environmentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentArn").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyId").getter(CreateKxEnvironmentResponse.getter(CreateKxEnvironmentResponse::kmsKeyId)).setter(CreateKxEnvironmentResponse.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()}).build();
    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTimestamp").getter(CreateKxEnvironmentResponse.getter(CreateKxEnvironmentResponse::creationTimestamp)).setter(CreateKxEnvironmentResponse.setter(Builder::creationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATUS_FIELD, ENVIRONMENT_ID_FIELD, DESCRIPTION_FIELD, ENVIRONMENT_ARN_FIELD, KMS_KEY_ID_FIELD, CREATION_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateKxEnvironmentResponse.memberNameToFieldInitializer();
    private final String name;
    private final String status;
    private final String environmentId;
    private final String description;
    private final String environmentArn;
    private final String kmsKeyId;
    private final Instant creationTimestamp;

    private CreateKxEnvironmentResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.status = builder.status;
        this.environmentId = builder.environmentId;
        this.description = builder.description;
        this.environmentArn = builder.environmentArn;
        this.kmsKeyId = builder.kmsKeyId;
        this.creationTimestamp = builder.creationTimestamp;
    }

    public final String name() {
        return this.name;
    }

    public final EnvironmentStatus status() {
        return EnvironmentStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final String description() {
        return this.description;
    }

    public final String environmentArn() {
        return this.environmentArn;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final Instant creationTimestamp() {
        return this.creationTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKxEnvironmentResponse)) {
            return false;
        }
        CreateKxEnvironmentResponse other = (CreateKxEnvironmentResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.environmentArn(), other.environmentArn()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.creationTimestamp(), other.creationTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"CreateKxEnvironmentResponse").add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("EnvironmentId", (Object)this.environmentId()).add("Description", (Object)this.description()).add("EnvironmentArn", (Object)this.environmentArn()).add("KmsKeyId", (Object)this.kmsKeyId()).add("CreationTimestamp", (Object)this.creationTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "environmentArn": {
                return Optional.ofNullable(clazz.cast(this.environmentArn()));
            }
            case "kmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "creationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.creationTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("environmentId", ENVIRONMENT_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("environmentArn", ENVIRONMENT_ARN_FIELD);
        map.put("kmsKeyId", KMS_KEY_ID_FIELD);
        map.put("creationTimestamp", CREATION_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateKxEnvironmentResponse, T> g) {
        return obj -> g.apply((CreateKxEnvironmentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceResponse.BuilderImpl
    implements Builder {
        private String name;
        private String status;
        private String environmentId;
        private String description;
        private String environmentArn;
        private String kmsKeyId;
        private Instant creationTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKxEnvironmentResponse model) {
            super(model);
            this.name(model.name);
            this.status(model.status);
            this.environmentId(model.environmentId);
            this.description(model.description);
            this.environmentArn(model.environmentArn);
            this.kmsKeyId(model.kmsKeyId);
            this.creationTimestamp(model.creationTimestamp);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EnvironmentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEnvironmentArn() {
            return this.environmentArn;
        }

        public final void setEnvironmentArn(String environmentArn) {
            this.environmentArn = environmentArn;
        }

        @Override
        public final Builder environmentArn(String environmentArn) {
            this.environmentArn = environmentArn;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Instant getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        @Override
        public CreateKxEnvironmentResponse build() {
            return new CreateKxEnvironmentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FinspaceResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateKxEnvironmentResponse> {
        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(EnvironmentStatus var1);

        public Builder environmentId(String var1);

        public Builder description(String var1);

        public Builder environmentArn(String var1);

        public Builder kmsKeyId(String var1);

        public Builder creationTimestamp(Instant var1);
    }
}

