/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.finspace.model.FinspaceResponse;
import software.amazon.awssdk.services.finspace.model.KxAzMode;
import software.amazon.awssdk.services.finspace.model.KxDataviewSegmentConfiguration;
import software.amazon.awssdk.services.finspace.model.KxDataviewSegmentConfigurationListCopier;
import software.amazon.awssdk.services.finspace.model.KxDataviewStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateKxDataviewResponse
extends FinspaceResponse
implements ToCopyableBuilder<Builder, CreateKxDataviewResponse> {
    private static final SdkField<String> DATAVIEW_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataviewName").getter(CreateKxDataviewResponse.getter(CreateKxDataviewResponse::dataviewName)).setter(CreateKxDataviewResponse.setter(Builder::dataviewName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataviewName").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("databaseName").getter(CreateKxDataviewResponse.getter(CreateKxDataviewResponse::databaseName)).setter(CreateKxDataviewResponse.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseName").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentId").getter(CreateKxDataviewResponse.getter(CreateKxDataviewResponse::environmentId)).setter(CreateKxDataviewResponse.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()}).build();
    private static final SdkField<String> AZ_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("azMode").getter(CreateKxDataviewResponse.getter(CreateKxDataviewResponse::azModeAsString)).setter(CreateKxDataviewResponse.setter(Builder::azMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("azMode").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("availabilityZoneId").getter(CreateKxDataviewResponse.getter(CreateKxDataviewResponse::availabilityZoneId)).setter(CreateKxDataviewResponse.setter(Builder::availabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZoneId").build()}).build();
    private static final SdkField<String> CHANGESET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("changesetId").getter(CreateKxDataviewResponse.getter(CreateKxDataviewResponse::changesetId)).setter(CreateKxDataviewResponse.setter(Builder::changesetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changesetId").build()}).build();
    private static final SdkField<List<KxDataviewSegmentConfiguration>> SEGMENT_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("segmentConfigurations").getter(CreateKxDataviewResponse.getter(CreateKxDataviewResponse::segmentConfigurations)).setter(CreateKxDataviewResponse.setter(Builder::segmentConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KxDataviewSegmentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateKxDataviewResponse.getter(CreateKxDataviewResponse::description)).setter(CreateKxDataviewResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Boolean> AUTO_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("autoUpdate").getter(CreateKxDataviewResponse.getter(CreateKxDataviewResponse::autoUpdate)).setter(CreateKxDataviewResponse.setter(Builder::autoUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoUpdate").build()}).build();
    private static final SdkField<Boolean> READ_WRITE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("readWrite").getter(CreateKxDataviewResponse.getter(CreateKxDataviewResponse::readWrite)).setter(CreateKxDataviewResponse.setter(Builder::readWrite)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readWrite").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdTimestamp").getter(CreateKxDataviewResponse.getter(CreateKxDataviewResponse::createdTimestamp)).setter(CreateKxDataviewResponse.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTimestamp").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedTimestamp").getter(CreateKxDataviewResponse.getter(CreateKxDataviewResponse::lastModifiedTimestamp)).setter(CreateKxDataviewResponse.setter(Builder::lastModifiedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTimestamp").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CreateKxDataviewResponse.getter(CreateKxDataviewResponse::statusAsString)).setter(CreateKxDataviewResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATAVIEW_NAME_FIELD, DATABASE_NAME_FIELD, ENVIRONMENT_ID_FIELD, AZ_MODE_FIELD, AVAILABILITY_ZONE_ID_FIELD, CHANGESET_ID_FIELD, SEGMENT_CONFIGURATIONS_FIELD, DESCRIPTION_FIELD, AUTO_UPDATE_FIELD, READ_WRITE_FIELD, CREATED_TIMESTAMP_FIELD, LAST_MODIFIED_TIMESTAMP_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateKxDataviewResponse.memberNameToFieldInitializer();
    private final String dataviewName;
    private final String databaseName;
    private final String environmentId;
    private final String azMode;
    private final String availabilityZoneId;
    private final String changesetId;
    private final List<KxDataviewSegmentConfiguration> segmentConfigurations;
    private final String description;
    private final Boolean autoUpdate;
    private final Boolean readWrite;
    private final Instant createdTimestamp;
    private final Instant lastModifiedTimestamp;
    private final String status;

    private CreateKxDataviewResponse(BuilderImpl builder) {
        super(builder);
        this.dataviewName = builder.dataviewName;
        this.databaseName = builder.databaseName;
        this.environmentId = builder.environmentId;
        this.azMode = builder.azMode;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.changesetId = builder.changesetId;
        this.segmentConfigurations = builder.segmentConfigurations;
        this.description = builder.description;
        this.autoUpdate = builder.autoUpdate;
        this.readWrite = builder.readWrite;
        this.createdTimestamp = builder.createdTimestamp;
        this.lastModifiedTimestamp = builder.lastModifiedTimestamp;
        this.status = builder.status;
    }

    public final String dataviewName() {
        return this.dataviewName;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final KxAzMode azMode() {
        return KxAzMode.fromValue(this.azMode);
    }

    public final String azModeAsString() {
        return this.azMode;
    }

    public final String availabilityZoneId() {
        return this.availabilityZoneId;
    }

    public final String changesetId() {
        return this.changesetId;
    }

    public final boolean hasSegmentConfigurations() {
        return this.segmentConfigurations != null && !(this.segmentConfigurations instanceof SdkAutoConstructList);
    }

    public final List<KxDataviewSegmentConfiguration> segmentConfigurations() {
        return this.segmentConfigurations;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean autoUpdate() {
        return this.autoUpdate;
    }

    public final Boolean readWrite() {
        return this.readWrite;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final Instant lastModifiedTimestamp() {
        return this.lastModifiedTimestamp;
    }

    public final KxDataviewStatus status() {
        return KxDataviewStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dataviewName());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.azModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.changesetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSegmentConfigurations() ? this.segmentConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.readWrite());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKxDataviewResponse)) {
            return false;
        }
        CreateKxDataviewResponse other = (CreateKxDataviewResponse)((Object)obj);
        return Objects.equals(this.dataviewName(), other.dataviewName()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.azModeAsString(), other.azModeAsString()) && Objects.equals(this.availabilityZoneId(), other.availabilityZoneId()) && Objects.equals(this.changesetId(), other.changesetId()) && this.hasSegmentConfigurations() == other.hasSegmentConfigurations() && Objects.equals(this.segmentConfigurations(), other.segmentConfigurations()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.autoUpdate(), other.autoUpdate()) && Objects.equals(this.readWrite(), other.readWrite()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.lastModifiedTimestamp(), other.lastModifiedTimestamp()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateKxDataviewResponse").add("DataviewName", (Object)this.dataviewName()).add("DatabaseName", (Object)this.databaseName()).add("EnvironmentId", (Object)this.environmentId()).add("AzMode", (Object)this.azModeAsString()).add("AvailabilityZoneId", (Object)this.availabilityZoneId()).add("ChangesetId", (Object)this.changesetId()).add("SegmentConfigurations", this.hasSegmentConfigurations() ? this.segmentConfigurations() : null).add("Description", (Object)this.description()).add("AutoUpdate", (Object)this.autoUpdate()).add("ReadWrite", (Object)this.readWrite()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("LastModifiedTimestamp", (Object)this.lastModifiedTimestamp()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataviewName": {
                return Optional.ofNullable(clazz.cast(this.dataviewName()));
            }
            case "databaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "azMode": {
                return Optional.ofNullable(clazz.cast(this.azModeAsString()));
            }
            case "availabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneId()));
            }
            case "changesetId": {
                return Optional.ofNullable(clazz.cast(this.changesetId()));
            }
            case "segmentConfigurations": {
                return Optional.ofNullable(clazz.cast(this.segmentConfigurations()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "autoUpdate": {
                return Optional.ofNullable(clazz.cast(this.autoUpdate()));
            }
            case "readWrite": {
                return Optional.ofNullable(clazz.cast(this.readWrite()));
            }
            case "createdTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "lastModifiedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTimestamp()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataviewName", DATAVIEW_NAME_FIELD);
        map.put("databaseName", DATABASE_NAME_FIELD);
        map.put("environmentId", ENVIRONMENT_ID_FIELD);
        map.put("azMode", AZ_MODE_FIELD);
        map.put("availabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        map.put("changesetId", CHANGESET_ID_FIELD);
        map.put("segmentConfigurations", SEGMENT_CONFIGURATIONS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("autoUpdate", AUTO_UPDATE_FIELD);
        map.put("readWrite", READ_WRITE_FIELD);
        map.put("createdTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("lastModifiedTimestamp", LAST_MODIFIED_TIMESTAMP_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateKxDataviewResponse, T> g) {
        return obj -> g.apply((CreateKxDataviewResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceResponse.BuilderImpl
    implements Builder {
        private String dataviewName;
        private String databaseName;
        private String environmentId;
        private String azMode;
        private String availabilityZoneId;
        private String changesetId;
        private List<KxDataviewSegmentConfiguration> segmentConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private Boolean autoUpdate;
        private Boolean readWrite;
        private Instant createdTimestamp;
        private Instant lastModifiedTimestamp;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKxDataviewResponse model) {
            super(model);
            this.dataviewName(model.dataviewName);
            this.databaseName(model.databaseName);
            this.environmentId(model.environmentId);
            this.azMode(model.azMode);
            this.availabilityZoneId(model.availabilityZoneId);
            this.changesetId(model.changesetId);
            this.segmentConfigurations(model.segmentConfigurations);
            this.description(model.description);
            this.autoUpdate(model.autoUpdate);
            this.readWrite(model.readWrite);
            this.createdTimestamp(model.createdTimestamp);
            this.lastModifiedTimestamp(model.lastModifiedTimestamp);
            this.status(model.status);
        }

        public final String getDataviewName() {
            return this.dataviewName;
        }

        public final void setDataviewName(String dataviewName) {
            this.dataviewName = dataviewName;
        }

        @Override
        public final Builder dataviewName(String dataviewName) {
            this.dataviewName = dataviewName;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getAzMode() {
            return this.azMode;
        }

        public final void setAzMode(String azMode) {
            this.azMode = azMode;
        }

        @Override
        public final Builder azMode(String azMode) {
            this.azMode = azMode;
            return this;
        }

        @Override
        public final Builder azMode(KxAzMode azMode) {
            this.azMode(azMode == null ? null : azMode.toString());
            return this;
        }

        public final String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final String getChangesetId() {
            return this.changesetId;
        }

        public final void setChangesetId(String changesetId) {
            this.changesetId = changesetId;
        }

        @Override
        public final Builder changesetId(String changesetId) {
            this.changesetId = changesetId;
            return this;
        }

        public final List<KxDataviewSegmentConfiguration.Builder> getSegmentConfigurations() {
            List<KxDataviewSegmentConfiguration.Builder> result = KxDataviewSegmentConfigurationListCopier.copyToBuilder(this.segmentConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSegmentConfigurations(Collection<KxDataviewSegmentConfiguration.BuilderImpl> segmentConfigurations) {
            this.segmentConfigurations = KxDataviewSegmentConfigurationListCopier.copyFromBuilder(segmentConfigurations);
        }

        @Override
        public final Builder segmentConfigurations(Collection<KxDataviewSegmentConfiguration> segmentConfigurations) {
            this.segmentConfigurations = KxDataviewSegmentConfigurationListCopier.copy(segmentConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segmentConfigurations(KxDataviewSegmentConfiguration ... segmentConfigurations) {
            this.segmentConfigurations(Arrays.asList(segmentConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segmentConfigurations(Consumer<KxDataviewSegmentConfiguration.Builder> ... segmentConfigurations) {
            this.segmentConfigurations(Stream.of(segmentConfigurations).map(c -> (KxDataviewSegmentConfiguration)((KxDataviewSegmentConfiguration.Builder)KxDataviewSegmentConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getAutoUpdate() {
            return this.autoUpdate;
        }

        public final void setAutoUpdate(Boolean autoUpdate) {
            this.autoUpdate = autoUpdate;
        }

        @Override
        public final Builder autoUpdate(Boolean autoUpdate) {
            this.autoUpdate = autoUpdate;
            return this;
        }

        public final Boolean getReadWrite() {
            return this.readWrite;
        }

        public final void setReadWrite(Boolean readWrite) {
            this.readWrite = readWrite;
        }

        @Override
        public final Builder readWrite(Boolean readWrite) {
            this.readWrite = readWrite;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getLastModifiedTimestamp() {
            return this.lastModifiedTimestamp;
        }

        public final void setLastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
        }

        @Override
        public final Builder lastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(KxDataviewStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public CreateKxDataviewResponse build() {
            return new CreateKxDataviewResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FinspaceResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateKxDataviewResponse> {
        public Builder dataviewName(String var1);

        public Builder databaseName(String var1);

        public Builder environmentId(String var1);

        public Builder azMode(String var1);

        public Builder azMode(KxAzMode var1);

        public Builder availabilityZoneId(String var1);

        public Builder changesetId(String var1);

        public Builder segmentConfigurations(Collection<KxDataviewSegmentConfiguration> var1);

        public Builder segmentConfigurations(KxDataviewSegmentConfiguration ... var1);

        public Builder segmentConfigurations(Consumer<KxDataviewSegmentConfiguration.Builder> ... var1);

        public Builder description(String var1);

        public Builder autoUpdate(Boolean var1);

        public Builder readWrite(Boolean var1);

        public Builder createdTimestamp(Instant var1);

        public Builder lastModifiedTimestamp(Instant var1);

        public Builder status(String var1);

        public Builder status(KxDataviewStatus var1);
    }
}

