/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.finspace.model.FinspaceRequest;
import software.amazon.awssdk.services.finspace.model.KxDatabaseConfiguration;
import software.amazon.awssdk.services.finspace.model.KxDatabaseConfigurationsCopier;
import software.amazon.awssdk.services.finspace.model.KxDeploymentConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateKxClusterDatabasesRequest
extends FinspaceRequest
implements ToCopyableBuilder<Builder, UpdateKxClusterDatabasesRequest> {
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentId").getter(UpdateKxClusterDatabasesRequest.getter(UpdateKxClusterDatabasesRequest::environmentId)).setter(UpdateKxClusterDatabasesRequest.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("environmentId").build()}).build();
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterName").getter(UpdateKxClusterDatabasesRequest.getter(UpdateKxClusterDatabasesRequest::clusterName)).setter(UpdateKxClusterDatabasesRequest.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("clusterName").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateKxClusterDatabasesRequest.getter(UpdateKxClusterDatabasesRequest::clientToken)).setter(UpdateKxClusterDatabasesRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<KxDatabaseConfiguration>> DATABASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("databases").getter(UpdateKxClusterDatabasesRequest.getter(UpdateKxClusterDatabasesRequest::databases)).setter(UpdateKxClusterDatabasesRequest.setter(Builder::databases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KxDatabaseConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<KxDeploymentConfiguration> DEPLOYMENT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("deploymentConfiguration").getter(UpdateKxClusterDatabasesRequest.getter(UpdateKxClusterDatabasesRequest::deploymentConfiguration)).setter(UpdateKxClusterDatabasesRequest.setter(Builder::deploymentConfiguration)).constructor(KxDeploymentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_ID_FIELD, CLUSTER_NAME_FIELD, CLIENT_TOKEN_FIELD, DATABASES_FIELD, DEPLOYMENT_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateKxClusterDatabasesRequest.memberNameToFieldInitializer();
    private final String environmentId;
    private final String clusterName;
    private final String clientToken;
    private final List<KxDatabaseConfiguration> databases;
    private final KxDeploymentConfiguration deploymentConfiguration;

    private UpdateKxClusterDatabasesRequest(BuilderImpl builder) {
        super(builder);
        this.environmentId = builder.environmentId;
        this.clusterName = builder.clusterName;
        this.clientToken = builder.clientToken;
        this.databases = builder.databases;
        this.deploymentConfiguration = builder.deploymentConfiguration;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasDatabases() {
        return this.databases != null && !(this.databases instanceof SdkAutoConstructList);
    }

    public final List<KxDatabaseConfiguration> databases() {
        return this.databases;
    }

    public final KxDeploymentConfiguration deploymentConfiguration() {
        return this.deploymentConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDatabases() ? this.databases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateKxClusterDatabasesRequest)) {
            return false;
        }
        UpdateKxClusterDatabasesRequest other = (UpdateKxClusterDatabasesRequest)((Object)obj);
        return Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasDatabases() == other.hasDatabases() && Objects.equals(this.databases(), other.databases()) && Objects.equals(this.deploymentConfiguration(), other.deploymentConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateKxClusterDatabasesRequest").add("EnvironmentId", (Object)this.environmentId()).add("ClusterName", (Object)this.clusterName()).add("ClientToken", (Object)this.clientToken()).add("Databases", this.hasDatabases() ? this.databases() : null).add("DeploymentConfiguration", (Object)this.deploymentConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "databases": {
                return Optional.ofNullable(clazz.cast(this.databases()));
            }
            case "deploymentConfiguration": {
                return Optional.ofNullable(clazz.cast(this.deploymentConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("environmentId", ENVIRONMENT_ID_FIELD);
        map.put("clusterName", CLUSTER_NAME_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("databases", DATABASES_FIELD);
        map.put("deploymentConfiguration", DEPLOYMENT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateKxClusterDatabasesRequest, T> g) {
        return obj -> g.apply((UpdateKxClusterDatabasesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceRequest.BuilderImpl
    implements Builder {
        private String environmentId;
        private String clusterName;
        private String clientToken;
        private List<KxDatabaseConfiguration> databases = DefaultSdkAutoConstructList.getInstance();
        private KxDeploymentConfiguration deploymentConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateKxClusterDatabasesRequest model) {
            super(model);
            this.environmentId(model.environmentId);
            this.clusterName(model.clusterName);
            this.clientToken(model.clientToken);
            this.databases(model.databases);
            this.deploymentConfiguration(model.deploymentConfiguration);
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<KxDatabaseConfiguration.Builder> getDatabases() {
            List<KxDatabaseConfiguration.Builder> result = KxDatabaseConfigurationsCopier.copyToBuilder(this.databases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDatabases(Collection<KxDatabaseConfiguration.BuilderImpl> databases) {
            this.databases = KxDatabaseConfigurationsCopier.copyFromBuilder(databases);
        }

        @Override
        public final Builder databases(Collection<KxDatabaseConfiguration> databases) {
            this.databases = KxDatabaseConfigurationsCopier.copy(databases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder databases(KxDatabaseConfiguration ... databases) {
            this.databases(Arrays.asList(databases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder databases(Consumer<KxDatabaseConfiguration.Builder> ... databases) {
            this.databases(Stream.of(databases).map(c -> (KxDatabaseConfiguration)((KxDatabaseConfiguration.Builder)KxDatabaseConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final KxDeploymentConfiguration.Builder getDeploymentConfiguration() {
            return this.deploymentConfiguration != null ? this.deploymentConfiguration.toBuilder() : null;
        }

        public final void setDeploymentConfiguration(KxDeploymentConfiguration.BuilderImpl deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration != null ? deploymentConfiguration.build() : null;
        }

        @Override
        public final Builder deploymentConfiguration(KxDeploymentConfiguration deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateKxClusterDatabasesRequest build() {
            return new UpdateKxClusterDatabasesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FinspaceRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateKxClusterDatabasesRequest> {
        public Builder environmentId(String var1);

        public Builder clusterName(String var1);

        public Builder clientToken(String var1);

        public Builder databases(Collection<KxDatabaseConfiguration> var1);

        public Builder databases(KxDatabaseConfiguration ... var1);

        public Builder databases(Consumer<KxDatabaseConfiguration.Builder> ... var1);

        public Builder deploymentConfiguration(KxDeploymentConfiguration var1);

        default public Builder deploymentConfiguration(Consumer<KxDeploymentConfiguration.Builder> deploymentConfiguration) {
            return this.deploymentConfiguration((KxDeploymentConfiguration)((KxDeploymentConfiguration.Builder)KxDeploymentConfiguration.builder().applyMutation(deploymentConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

