/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.finspace.model.DataBundleArnsCopier;
import software.amazon.awssdk.services.finspace.model.FederationMode;
import software.amazon.awssdk.services.finspace.model.FederationParameters;
import software.amazon.awssdk.services.finspace.model.FinspaceRequest;
import software.amazon.awssdk.services.finspace.model.SuperuserParameters;
import software.amazon.awssdk.services.finspace.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEnvironmentRequest
extends FinspaceRequest
implements ToCopyableBuilder<Builder, CreateEnvironmentRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::name)).setter(CreateEnvironmentRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::description)).setter(CreateEnvironmentRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyId").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::kmsKeyId)).setter(CreateEnvironmentRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::tags)).setter(CreateEnvironmentRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> FEDERATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("federationMode").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::federationModeAsString)).setter(CreateEnvironmentRequest.setter(Builder::federationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("federationMode").build()}).build();
    private static final SdkField<FederationParameters> FEDERATION_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("federationParameters").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::federationParameters)).setter(CreateEnvironmentRequest.setter(Builder::federationParameters)).constructor(FederationParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("federationParameters").build()}).build();
    private static final SdkField<SuperuserParameters> SUPERUSER_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("superuserParameters").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::superuserParameters)).setter(CreateEnvironmentRequest.setter(Builder::superuserParameters)).constructor(SuperuserParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("superuserParameters").build()}).build();
    private static final SdkField<List<String>> DATA_BUNDLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dataBundles").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::dataBundles)).setter(CreateEnvironmentRequest.setter(Builder::dataBundles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataBundles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, KMS_KEY_ID_FIELD, TAGS_FIELD, FEDERATION_MODE_FIELD, FEDERATION_PARAMETERS_FIELD, SUPERUSER_PARAMETERS_FIELD, DATA_BUNDLES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateEnvironmentRequest.memberNameToFieldInitializer();
    private final String name;
    private final String description;
    private final String kmsKeyId;
    private final Map<String, String> tags;
    private final String federationMode;
    private final FederationParameters federationParameters;
    private final SuperuserParameters superuserParameters;
    private final List<String> dataBundles;

    private CreateEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.kmsKeyId = builder.kmsKeyId;
        this.tags = builder.tags;
        this.federationMode = builder.federationMode;
        this.federationParameters = builder.federationParameters;
        this.superuserParameters = builder.superuserParameters;
        this.dataBundles = builder.dataBundles;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final FederationMode federationMode() {
        return FederationMode.fromValue(this.federationMode);
    }

    public final String federationModeAsString() {
        return this.federationMode;
    }

    public final FederationParameters federationParameters() {
        return this.federationParameters;
    }

    public final SuperuserParameters superuserParameters() {
        return this.superuserParameters;
    }

    public final boolean hasDataBundles() {
        return this.dataBundles != null && !(this.dataBundles instanceof SdkAutoConstructList);
    }

    public final List<String> dataBundles() {
        return this.dataBundles;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.federationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.federationParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.superuserParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataBundles() ? this.dataBundles() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEnvironmentRequest)) {
            return false;
        }
        CreateEnvironmentRequest other = (CreateEnvironmentRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.federationModeAsString(), other.federationModeAsString()) && Objects.equals(this.federationParameters(), other.federationParameters()) && Objects.equals(this.superuserParameters(), other.superuserParameters()) && this.hasDataBundles() == other.hasDataBundles() && Objects.equals(this.dataBundles(), other.dataBundles());
    }

    public final String toString() {
        return ToString.builder((String)"CreateEnvironmentRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("KmsKeyId", (Object)this.kmsKeyId()).add("Tags", this.hasTags() ? this.tags() : null).add("FederationMode", (Object)this.federationModeAsString()).add("FederationParameters", (Object)this.federationParameters()).add("SuperuserParameters", (Object)this.superuserParameters()).add("DataBundles", this.hasDataBundles() ? this.dataBundles() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "kmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "federationMode": {
                return Optional.ofNullable(clazz.cast(this.federationModeAsString()));
            }
            case "federationParameters": {
                return Optional.ofNullable(clazz.cast(this.federationParameters()));
            }
            case "superuserParameters": {
                return Optional.ofNullable(clazz.cast(this.superuserParameters()));
            }
            case "dataBundles": {
                return Optional.ofNullable(clazz.cast(this.dataBundles()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("kmsKeyId", KMS_KEY_ID_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("federationMode", FEDERATION_MODE_FIELD);
        map.put("federationParameters", FEDERATION_PARAMETERS_FIELD);
        map.put("superuserParameters", SUPERUSER_PARAMETERS_FIELD);
        map.put("dataBundles", DATA_BUNDLES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateEnvironmentRequest, T> g) {
        return obj -> g.apply((CreateEnvironmentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String kmsKeyId;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String federationMode;
        private FederationParameters federationParameters;
        private SuperuserParameters superuserParameters;
        private List<String> dataBundles = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEnvironmentRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.kmsKeyId(model.kmsKeyId);
            this.tags(model.tags);
            this.federationMode(model.federationMode);
            this.federationParameters(model.federationParameters);
            this.superuserParameters(model.superuserParameters);
            this.dataBundles(model.dataBundles);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getFederationMode() {
            return this.federationMode;
        }

        public final void setFederationMode(String federationMode) {
            this.federationMode = federationMode;
        }

        @Override
        public final Builder federationMode(String federationMode) {
            this.federationMode = federationMode;
            return this;
        }

        @Override
        public final Builder federationMode(FederationMode federationMode) {
            this.federationMode(federationMode == null ? null : federationMode.toString());
            return this;
        }

        public final FederationParameters.Builder getFederationParameters() {
            return this.federationParameters != null ? this.federationParameters.toBuilder() : null;
        }

        public final void setFederationParameters(FederationParameters.BuilderImpl federationParameters) {
            this.federationParameters = federationParameters != null ? federationParameters.build() : null;
        }

        @Override
        public final Builder federationParameters(FederationParameters federationParameters) {
            this.federationParameters = federationParameters;
            return this;
        }

        public final SuperuserParameters.Builder getSuperuserParameters() {
            return this.superuserParameters != null ? this.superuserParameters.toBuilder() : null;
        }

        public final void setSuperuserParameters(SuperuserParameters.BuilderImpl superuserParameters) {
            this.superuserParameters = superuserParameters != null ? superuserParameters.build() : null;
        }

        @Override
        public final Builder superuserParameters(SuperuserParameters superuserParameters) {
            this.superuserParameters = superuserParameters;
            return this;
        }

        public final Collection<String> getDataBundles() {
            if (this.dataBundles instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dataBundles;
        }

        public final void setDataBundles(Collection<String> dataBundles) {
            this.dataBundles = DataBundleArnsCopier.copy(dataBundles);
        }

        @Override
        public final Builder dataBundles(Collection<String> dataBundles) {
            this.dataBundles = DataBundleArnsCopier.copy(dataBundles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataBundles(String ... dataBundles) {
            this.dataBundles(Arrays.asList(dataBundles));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEnvironmentRequest build() {
            return new CreateEnvironmentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FinspaceRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateEnvironmentRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder kmsKeyId(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder federationMode(String var1);

        public Builder federationMode(FederationMode var1);

        public Builder federationParameters(FederationParameters var1);

        default public Builder federationParameters(Consumer<FederationParameters.Builder> federationParameters) {
            return this.federationParameters((FederationParameters)((FederationParameters.Builder)FederationParameters.builder().applyMutation(federationParameters)).build());
        }

        public Builder superuserParameters(SuperuserParameters var1);

        default public Builder superuserParameters(Consumer<SuperuserParameters.Builder> superuserParameters) {
            return this.superuserParameters((SuperuserParameters)((SuperuserParameters.Builder)SuperuserParameters.builder().applyMutation(superuserParameters)).build());
        }

        public Builder dataBundles(Collection<String> var1);

        public Builder dataBundles(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

