/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.finspace.model.AutoScalingMetric;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoScalingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoScalingConfiguration> {
    private static final SdkField<Integer> MIN_NODE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("minNodeCount").getter(AutoScalingConfiguration.getter(AutoScalingConfiguration::minNodeCount)).setter(AutoScalingConfiguration.setter(Builder::minNodeCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minNodeCount").build()}).build();
    private static final SdkField<Integer> MAX_NODE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxNodeCount").getter(AutoScalingConfiguration.getter(AutoScalingConfiguration::maxNodeCount)).setter(AutoScalingConfiguration.setter(Builder::maxNodeCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxNodeCount").build()}).build();
    private static final SdkField<String> AUTO_SCALING_METRIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("autoScalingMetric").getter(AutoScalingConfiguration.getter(AutoScalingConfiguration::autoScalingMetricAsString)).setter(AutoScalingConfiguration.setter(Builder::autoScalingMetric)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingMetric").build()}).build();
    private static final SdkField<Double> METRIC_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("metricTarget").getter(AutoScalingConfiguration.getter(AutoScalingConfiguration::metricTarget)).setter(AutoScalingConfiguration.setter(Builder::metricTarget)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricTarget").build()}).build();
    private static final SdkField<Double> SCALE_IN_COOLDOWN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("scaleInCooldownSeconds").getter(AutoScalingConfiguration.getter(AutoScalingConfiguration::scaleInCooldownSeconds)).setter(AutoScalingConfiguration.setter(Builder::scaleInCooldownSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scaleInCooldownSeconds").build()}).build();
    private static final SdkField<Double> SCALE_OUT_COOLDOWN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("scaleOutCooldownSeconds").getter(AutoScalingConfiguration.getter(AutoScalingConfiguration::scaleOutCooldownSeconds)).setter(AutoScalingConfiguration.setter(Builder::scaleOutCooldownSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scaleOutCooldownSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_NODE_COUNT_FIELD, MAX_NODE_COUNT_FIELD, AUTO_SCALING_METRIC_FIELD, METRIC_TARGET_FIELD, SCALE_IN_COOLDOWN_SECONDS_FIELD, SCALE_OUT_COOLDOWN_SECONDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("minNodeCount", MIN_NODE_COUNT_FIELD);
            this.put("maxNodeCount", MAX_NODE_COUNT_FIELD);
            this.put("autoScalingMetric", AUTO_SCALING_METRIC_FIELD);
            this.put("metricTarget", METRIC_TARGET_FIELD);
            this.put("scaleInCooldownSeconds", SCALE_IN_COOLDOWN_SECONDS_FIELD);
            this.put("scaleOutCooldownSeconds", SCALE_OUT_COOLDOWN_SECONDS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Integer minNodeCount;
    private final Integer maxNodeCount;
    private final String autoScalingMetric;
    private final Double metricTarget;
    private final Double scaleInCooldownSeconds;
    private final Double scaleOutCooldownSeconds;

    private AutoScalingConfiguration(BuilderImpl builder) {
        this.minNodeCount = builder.minNodeCount;
        this.maxNodeCount = builder.maxNodeCount;
        this.autoScalingMetric = builder.autoScalingMetric;
        this.metricTarget = builder.metricTarget;
        this.scaleInCooldownSeconds = builder.scaleInCooldownSeconds;
        this.scaleOutCooldownSeconds = builder.scaleOutCooldownSeconds;
    }

    public final Integer minNodeCount() {
        return this.minNodeCount;
    }

    public final Integer maxNodeCount() {
        return this.maxNodeCount;
    }

    public final AutoScalingMetric autoScalingMetric() {
        return AutoScalingMetric.fromValue(this.autoScalingMetric);
    }

    public final String autoScalingMetricAsString() {
        return this.autoScalingMetric;
    }

    public final Double metricTarget() {
        return this.metricTarget;
    }

    public final Double scaleInCooldownSeconds() {
        return this.scaleInCooldownSeconds;
    }

    public final Double scaleOutCooldownSeconds() {
        return this.scaleOutCooldownSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.minNodeCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxNodeCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingMetricAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricTarget());
        hashCode = 31 * hashCode + Objects.hashCode(this.scaleInCooldownSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.scaleOutCooldownSeconds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingConfiguration)) {
            return false;
        }
        AutoScalingConfiguration other = (AutoScalingConfiguration)obj;
        return Objects.equals(this.minNodeCount(), other.minNodeCount()) && Objects.equals(this.maxNodeCount(), other.maxNodeCount()) && Objects.equals(this.autoScalingMetricAsString(), other.autoScalingMetricAsString()) && Objects.equals(this.metricTarget(), other.metricTarget()) && Objects.equals(this.scaleInCooldownSeconds(), other.scaleInCooldownSeconds()) && Objects.equals(this.scaleOutCooldownSeconds(), other.scaleOutCooldownSeconds());
    }

    public final String toString() {
        return ToString.builder((String)"AutoScalingConfiguration").add("MinNodeCount", (Object)this.minNodeCount()).add("MaxNodeCount", (Object)this.maxNodeCount()).add("AutoScalingMetric", (Object)this.autoScalingMetricAsString()).add("MetricTarget", (Object)this.metricTarget()).add("ScaleInCooldownSeconds", (Object)this.scaleInCooldownSeconds()).add("ScaleOutCooldownSeconds", (Object)this.scaleOutCooldownSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "minNodeCount": {
                return Optional.ofNullable(clazz.cast(this.minNodeCount()));
            }
            case "maxNodeCount": {
                return Optional.ofNullable(clazz.cast(this.maxNodeCount()));
            }
            case "autoScalingMetric": {
                return Optional.ofNullable(clazz.cast(this.autoScalingMetricAsString()));
            }
            case "metricTarget": {
                return Optional.ofNullable(clazz.cast(this.metricTarget()));
            }
            case "scaleInCooldownSeconds": {
                return Optional.ofNullable(clazz.cast(this.scaleInCooldownSeconds()));
            }
            case "scaleOutCooldownSeconds": {
                return Optional.ofNullable(clazz.cast(this.scaleOutCooldownSeconds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingConfiguration, T> g) {
        return obj -> g.apply((AutoScalingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer minNodeCount;
        private Integer maxNodeCount;
        private String autoScalingMetric;
        private Double metricTarget;
        private Double scaleInCooldownSeconds;
        private Double scaleOutCooldownSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingConfiguration model) {
            this.minNodeCount(model.minNodeCount);
            this.maxNodeCount(model.maxNodeCount);
            this.autoScalingMetric(model.autoScalingMetric);
            this.metricTarget(model.metricTarget);
            this.scaleInCooldownSeconds(model.scaleInCooldownSeconds);
            this.scaleOutCooldownSeconds(model.scaleOutCooldownSeconds);
        }

        public final Integer getMinNodeCount() {
            return this.minNodeCount;
        }

        public final void setMinNodeCount(Integer minNodeCount) {
            this.minNodeCount = minNodeCount;
        }

        @Override
        public final Builder minNodeCount(Integer minNodeCount) {
            this.minNodeCount = minNodeCount;
            return this;
        }

        public final Integer getMaxNodeCount() {
            return this.maxNodeCount;
        }

        public final void setMaxNodeCount(Integer maxNodeCount) {
            this.maxNodeCount = maxNodeCount;
        }

        @Override
        public final Builder maxNodeCount(Integer maxNodeCount) {
            this.maxNodeCount = maxNodeCount;
            return this;
        }

        public final String getAutoScalingMetric() {
            return this.autoScalingMetric;
        }

        public final void setAutoScalingMetric(String autoScalingMetric) {
            this.autoScalingMetric = autoScalingMetric;
        }

        @Override
        public final Builder autoScalingMetric(String autoScalingMetric) {
            this.autoScalingMetric = autoScalingMetric;
            return this;
        }

        @Override
        public final Builder autoScalingMetric(AutoScalingMetric autoScalingMetric) {
            this.autoScalingMetric(autoScalingMetric == null ? null : autoScalingMetric.toString());
            return this;
        }

        public final Double getMetricTarget() {
            return this.metricTarget;
        }

        public final void setMetricTarget(Double metricTarget) {
            this.metricTarget = metricTarget;
        }

        @Override
        public final Builder metricTarget(Double metricTarget) {
            this.metricTarget = metricTarget;
            return this;
        }

        public final Double getScaleInCooldownSeconds() {
            return this.scaleInCooldownSeconds;
        }

        public final void setScaleInCooldownSeconds(Double scaleInCooldownSeconds) {
            this.scaleInCooldownSeconds = scaleInCooldownSeconds;
        }

        @Override
        public final Builder scaleInCooldownSeconds(Double scaleInCooldownSeconds) {
            this.scaleInCooldownSeconds = scaleInCooldownSeconds;
            return this;
        }

        public final Double getScaleOutCooldownSeconds() {
            return this.scaleOutCooldownSeconds;
        }

        public final void setScaleOutCooldownSeconds(Double scaleOutCooldownSeconds) {
            this.scaleOutCooldownSeconds = scaleOutCooldownSeconds;
        }

        @Override
        public final Builder scaleOutCooldownSeconds(Double scaleOutCooldownSeconds) {
            this.scaleOutCooldownSeconds = scaleOutCooldownSeconds;
            return this;
        }

        public AutoScalingConfiguration build() {
            return new AutoScalingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoScalingConfiguration> {
        public Builder minNodeCount(Integer var1);

        public Builder maxNodeCount(Integer var1);

        public Builder autoScalingMetric(String var1);

        public Builder autoScalingMetric(AutoScalingMetric var1);

        public Builder metricTarget(Double var1);

        public Builder scaleInCooldownSeconds(Double var1);

        public Builder scaleOutCooldownSeconds(Double var1);
    }
}

