/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.finspace.model.FinspaceResponse;
import software.amazon.awssdk.services.finspace.model.KxDataviewListEntry;
import software.amazon.awssdk.services.finspace.model.KxDataviewsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListKxDataviewsResponse
extends FinspaceResponse
implements ToCopyableBuilder<Builder, ListKxDataviewsResponse> {
    private static final SdkField<List<KxDataviewListEntry>> KX_DATAVIEWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("kxDataviews").getter(ListKxDataviewsResponse.getter(ListKxDataviewsResponse::kxDataviews)).setter(ListKxDataviewsResponse.setter(Builder::kxDataviews)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kxDataviews").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KxDataviewListEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListKxDataviewsResponse.getter(ListKxDataviewsResponse::nextToken)).setter(ListKxDataviewsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KX_DATAVIEWS_FIELD, NEXT_TOKEN_FIELD));
    private final List<KxDataviewListEntry> kxDataviews;
    private final String nextToken;

    private ListKxDataviewsResponse(BuilderImpl builder) {
        super(builder);
        this.kxDataviews = builder.kxDataviews;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasKxDataviews() {
        return this.kxDataviews != null && !(this.kxDataviews instanceof SdkAutoConstructList);
    }

    public final List<KxDataviewListEntry> kxDataviews() {
        return this.kxDataviews;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKxDataviews() ? this.kxDataviews() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListKxDataviewsResponse)) {
            return false;
        }
        ListKxDataviewsResponse other = (ListKxDataviewsResponse)((Object)obj);
        return this.hasKxDataviews() == other.hasKxDataviews() && Objects.equals(this.kxDataviews(), other.kxDataviews()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListKxDataviewsResponse").add("KxDataviews", this.hasKxDataviews() ? this.kxDataviews() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "kxDataviews": {
                return Optional.ofNullable(clazz.cast(this.kxDataviews()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListKxDataviewsResponse, T> g) {
        return obj -> g.apply((ListKxDataviewsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceResponse.BuilderImpl
    implements Builder {
        private List<KxDataviewListEntry> kxDataviews = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListKxDataviewsResponse model) {
            super(model);
            this.kxDataviews(model.kxDataviews);
            this.nextToken(model.nextToken);
        }

        public final List<KxDataviewListEntry.Builder> getKxDataviews() {
            List<KxDataviewListEntry.Builder> result = KxDataviewsCopier.copyToBuilder(this.kxDataviews);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKxDataviews(Collection<KxDataviewListEntry.BuilderImpl> kxDataviews) {
            this.kxDataviews = KxDataviewsCopier.copyFromBuilder(kxDataviews);
        }

        @Override
        public final Builder kxDataviews(Collection<KxDataviewListEntry> kxDataviews) {
            this.kxDataviews = KxDataviewsCopier.copy(kxDataviews);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kxDataviews(KxDataviewListEntry ... kxDataviews) {
            this.kxDataviews(Arrays.asList(kxDataviews));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kxDataviews(Consumer<KxDataviewListEntry.Builder> ... kxDataviews) {
            this.kxDataviews(Stream.of(kxDataviews).map(c -> (KxDataviewListEntry)((KxDataviewListEntry.Builder)KxDataviewListEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListKxDataviewsResponse build() {
            return new ListKxDataviewsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FinspaceResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListKxDataviewsResponse> {
        public Builder kxDataviews(Collection<KxDataviewListEntry> var1);

        public Builder kxDataviews(KxDataviewListEntry ... var1);

        public Builder kxDataviews(Consumer<KxDataviewListEntry.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

