/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.finspace.model.KxClusterNameListCopier;
import software.amazon.awssdk.services.finspace.model.KxScalingGroupStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KxScalingGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KxScalingGroup> {
    private static final SdkField<String> SCALING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scalingGroupName").getter(KxScalingGroup.getter(KxScalingGroup::scalingGroupName)).setter(KxScalingGroup.setter(Builder::scalingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalingGroupName").build()}).build();
    private static final SdkField<String> HOST_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("hostType").getter(KxScalingGroup.getter(KxScalingGroup::hostType)).setter(KxScalingGroup.setter(Builder::hostType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostType").build()}).build();
    private static final SdkField<List<String>> CLUSTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("clusters").getter(KxScalingGroup.getter(KxScalingGroup::clusters)).setter(KxScalingGroup.setter(Builder::clusters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("availabilityZoneId").getter(KxScalingGroup.getter(KxScalingGroup::availabilityZoneId)).setter(KxScalingGroup.setter(Builder::availabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZoneId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(KxScalingGroup.getter(KxScalingGroup::statusAsString)).setter(KxScalingGroup.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(KxScalingGroup.getter(KxScalingGroup::statusReason)).setter(KxScalingGroup.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedTimestamp").getter(KxScalingGroup.getter(KxScalingGroup::lastModifiedTimestamp)).setter(KxScalingGroup.setter(Builder::lastModifiedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTimestamp").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdTimestamp").getter(KxScalingGroup.getter(KxScalingGroup::createdTimestamp)).setter(KxScalingGroup.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALING_GROUP_NAME_FIELD, HOST_TYPE_FIELD, CLUSTERS_FIELD, AVAILABILITY_ZONE_ID_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, LAST_MODIFIED_TIMESTAMP_FIELD, CREATED_TIMESTAMP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String scalingGroupName;
    private final String hostType;
    private final List<String> clusters;
    private final String availabilityZoneId;
    private final String status;
    private final String statusReason;
    private final Instant lastModifiedTimestamp;
    private final Instant createdTimestamp;

    private KxScalingGroup(BuilderImpl builder) {
        this.scalingGroupName = builder.scalingGroupName;
        this.hostType = builder.hostType;
        this.clusters = builder.clusters;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.lastModifiedTimestamp = builder.lastModifiedTimestamp;
        this.createdTimestamp = builder.createdTimestamp;
    }

    public final String scalingGroupName() {
        return this.scalingGroupName;
    }

    public final String hostType() {
        return this.hostType;
    }

    public final boolean hasClusters() {
        return this.clusters != null && !(this.clusters instanceof SdkAutoConstructList);
    }

    public final List<String> clusters() {
        return this.clusters;
    }

    public final String availabilityZoneId() {
        return this.availabilityZoneId;
    }

    public final KxScalingGroupStatus status() {
        return KxScalingGroupStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final Instant lastModifiedTimestamp() {
        return this.lastModifiedTimestamp;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClusters() ? this.clusters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KxScalingGroup)) {
            return false;
        }
        KxScalingGroup other = (KxScalingGroup)obj;
        return Objects.equals(this.scalingGroupName(), other.scalingGroupName()) && Objects.equals(this.hostType(), other.hostType()) && this.hasClusters() == other.hasClusters() && Objects.equals(this.clusters(), other.clusters()) && Objects.equals(this.availabilityZoneId(), other.availabilityZoneId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.lastModifiedTimestamp(), other.lastModifiedTimestamp()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"KxScalingGroup").add("ScalingGroupName", (Object)this.scalingGroupName()).add("HostType", (Object)this.hostType()).add("Clusters", this.hasClusters() ? this.clusters() : null).add("AvailabilityZoneId", (Object)this.availabilityZoneId()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("LastModifiedTimestamp", (Object)this.lastModifiedTimestamp()).add("CreatedTimestamp", (Object)this.createdTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "scalingGroupName": {
                return Optional.ofNullable(clazz.cast(this.scalingGroupName()));
            }
            case "hostType": {
                return Optional.ofNullable(clazz.cast(this.hostType()));
            }
            case "clusters": {
                return Optional.ofNullable(clazz.cast(this.clusters()));
            }
            case "availabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "lastModifiedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTimestamp()));
            }
            case "createdTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KxScalingGroup, T> g) {
        return obj -> g.apply((KxScalingGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String scalingGroupName;
        private String hostType;
        private List<String> clusters = DefaultSdkAutoConstructList.getInstance();
        private String availabilityZoneId;
        private String status;
        private String statusReason;
        private Instant lastModifiedTimestamp;
        private Instant createdTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(KxScalingGroup model) {
            this.scalingGroupName(model.scalingGroupName);
            this.hostType(model.hostType);
            this.clusters(model.clusters);
            this.availabilityZoneId(model.availabilityZoneId);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.lastModifiedTimestamp(model.lastModifiedTimestamp);
            this.createdTimestamp(model.createdTimestamp);
        }

        public final String getScalingGroupName() {
            return this.scalingGroupName;
        }

        public final void setScalingGroupName(String scalingGroupName) {
            this.scalingGroupName = scalingGroupName;
        }

        @Override
        public final Builder scalingGroupName(String scalingGroupName) {
            this.scalingGroupName = scalingGroupName;
            return this;
        }

        public final String getHostType() {
            return this.hostType;
        }

        public final void setHostType(String hostType) {
            this.hostType = hostType;
        }

        @Override
        public final Builder hostType(String hostType) {
            this.hostType = hostType;
            return this;
        }

        public final Collection<String> getClusters() {
            if (this.clusters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.clusters;
        }

        public final void setClusters(Collection<String> clusters) {
            this.clusters = KxClusterNameListCopier.copy(clusters);
        }

        @Override
        public final Builder clusters(Collection<String> clusters) {
            this.clusters = KxClusterNameListCopier.copy(clusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusters(String ... clusters) {
            this.clusters(Arrays.asList(clusters));
            return this;
        }

        public final String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(KxScalingGroupStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Instant getLastModifiedTimestamp() {
            return this.lastModifiedTimestamp;
        }

        public final void setLastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
        }

        @Override
        public final Builder lastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public KxScalingGroup build() {
            return new KxScalingGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KxScalingGroup> {
        public Builder scalingGroupName(String var1);

        public Builder hostType(String var1);

        public Builder clusters(Collection<String> var1);

        public Builder clusters(String ... var1);

        public Builder availabilityZoneId(String var1);

        public Builder status(String var1);

        public Builder status(KxScalingGroupStatus var1);

        public Builder statusReason(String var1);

        public Builder lastModifiedTimestamp(Instant var1);

        public Builder createdTimestamp(Instant var1);
    }
}

